/*
 * Decompiled with CFR 0.152.
 */
package com.sky.hcm.util;

import com.sky.hcm.Settings;
import com.sky.hcm.util.PlayerHandler;
import com.sky.hcm.window.HCMTab;
import com.sky.hcm.window.HCMTabbedPane;
import java.awt.Color;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ChatHandler {
    static HCMTabbedPane tabbedPane;
    private String[] filter = new String[]{" Reason: ", "minutes before the Green Walls fall", "minutes before the Red Walls fall", "c0:01 ", "c0:02 ", "c0:03 ", "c0:04 ", "c0:05 ", "Cages open in: ", "INSANE MODIFIER: ", "Round Winner:", "Top Cop:", "Most Wanted:", "Your party can't queue for Turbo Kart Racers:", "You received: ", "Found a server running ", "You were kicked while joining that server!", "Rate this map by clicking: [5] [4] [3] [2] [1]", "Total Earned Coins: ", "Total Earned Experience: ", "Winners:", "Winner:", "If you happen to come across any bugs make sure you report them at http://www.hypixel.net", "https://store.hypixel.net/", "http://store.hypixel.net/", "Now playing: ", "--- Info about"};

    public ChatHandler(HCMTabbedPane tabbedPane) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ChatHandler.tabbedPane = tabbedPane;
    }

    public static void sendChatToTab(String tabName, String prefix, String message, boolean doPling) {
        if (tabName == null || tabName.equalsIgnoreCase("null") || tabName.isEmpty() || message.isEmpty() || message == null) {
            return;
        }
        boolean foundSpecialPling = false;
        boolean foundNotify = false;
        HCMTab tab = tabbedPane.getTab(tabName);
        tab.appendText(prefix, Color.BLACK, false);
        for (String sm : message.trim().split(" ")) {
            for (String sn : Settings.getNotifyWordsAsArray()) {
                if (!sm.toLowerCase().trim().contains(sn.toLowerCase().trim())) continue;
                foundNotify = true;
                foundSpecialPling = true;
                tab.appendText(sm.trim(), Color.RED, false);
                break;
            }
            if (foundNotify) {
                foundNotify = false;
                continue;
            }
            tab.appendText(sm.trim(), Color.BLACK, false);
        }
        tab.appendText("", Color.black, true);
        if (Settings.chatPling) {
            if (foundSpecialPling) {
                if (tabbedPane.getSelectedIndex() != tabbedPane.indexOfTab(tab.getName())) {
                    tab.setLabelBackground(new Color(255, 255, 0));
                }
                Minecraft.func_71410_x().field_71439_g.func_85030_a("random.orb", 10.0f, 1.4f);
            } else if (doPling && tabbedPane.getSelectedIndex() != tabbedPane.indexOfTab(tab.getName())) {
                if (tabbedPane.getSelectedIndex() != tabbedPane.indexOfTab(tab.getName())) {
                    tab.setLabelBackground(new Color(255, 142, 239));
                }
                Minecraft.func_71410_x().field_71439_g.func_85030_a("random.orb", 10.0f, 1.1f);
            }
        }
    }

    public static void log(String message) {
        tabbedPane.getTab("HCM INFO").appendText(message, Color.BLACK, true);
    }

    public static void logFriendRequest(String message) {
        tabbedPane.getTab("FRIEND REQUESTS").appendText(message, Color.BLACK, true);
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent e) {
        if (e.type != 0) {
            return;
        }
        String fullMessage = e.message.func_150260_c().replaceAll("\u00a7\\w", "");
        String[] splitMessage = fullMessage.split(" ");
        if (fullMessage.contains("---------------------------------------")) {
            fullMessage = fullMessage.replaceAll("(-)+\b", "");
            splitMessage = fullMessage.split(" ");
            return;
        }
        if (splitMessage.length < 2) {
            return;
        }
        if (splitMessage[0].contains("[") && splitMessage[0].contains(":")) {
            return;
        }
        if (splitMessage[0].equalsIgnoreCase("to") || splitMessage[0].equalsIgnoreCase("from")) {
            boolean incoming = splitMessage[0].equalsIgnoreCase("from");
            this.findMsgChatTab(fullMessage, incoming);
            if (Settings.blockChatDisplay) {
                e.setCanceled(true);
            }
            return;
        }
        if (splitMessage[1].equalsIgnoreCase("left.")) {
            if (!Settings.showFriendMessages) {
                e.setCanceled(true);
            }
            return;
        }
        if (splitMessage[1].equalsIgnoreCase("joined.")) {
            if (!Settings.showFriendMessages) {
                e.setCanceled(true);
            }
            return;
        }
        if (fullMessage.contains("[STAFF]") && Settings.blockChatDisplay) {
            e.setCanceled(true);
        }
        if (fullMessage.contains(":")) {
            for (String s : this.filter) {
                if (!fullMessage.toLowerCase().contains(s.toLowerCase())) continue;
                return;
            }
            this.findOtherChatTab(fullMessage);
            if (Settings.blockChatDisplay) {
                e.setCanceled(true);
            }
        }
    }

    private void findMsgChatTab(String fullMessage, boolean incoming) {
        String playerTabName = this.getPlayerTabName(fullMessage);
        String prefix = ChatHandler.getCurrentTimeStamp();
        prefix = !incoming ? prefix + " " + Minecraft.func_71410_x().field_71439_g.func_70005_c_() + ":" : prefix + " " + playerTabName + ":";
        String message = "";
        boolean foundPlayer = false;
        for (String s : fullMessage.split(" ")) {
            if (foundPlayer) {
                message = message + " " + s;
                continue;
            }
            if (!s.contains(":")) continue;
            foundPlayer = true;
        }
        ChatHandler.sendChatToTab(playerTabName, prefix, message, incoming);
    }

    private void findOtherChatTab(String fullMessage) {
        String[] splitMessage = fullMessage.split(" ");
        String prefix = ChatHandler.getCurrentTimeStamp() + " ";
        int start = 1;
        switch (splitMessage[0].toLowerCase().trim()) {
            case "guild": 
            case "party": {
                start = 2;
                break;
            }
            case "[staff]": 
            case "[t]": {
                break;
            }
            default: {
                start = 0;
            }
        }
        String message = "";
        boolean foundPlayer = false;
        for (int i = start; i < splitMessage.length; ++i) {
            String s = splitMessage[i];
            if (foundPlayer) {
                message = message + " " + s;
                continue;
            }
            if (!s.contains(":")) continue;
            foundPlayer = true;
        }
        if (start == 0) {
            ChatHandler.sendChatToTab("Lobby", prefix + fullMessage.replace(message, "").trim(), message, false);
            return;
        }
        ChatHandler.sendChatToTab(splitMessage[0].trim(), prefix + fullMessage.replace(message, "").trim(), message, true);
    }

    private String getPlayerTabName(String fullMessage) {
        String[] split = fullMessage.split(" ");
        if (split[0].equalsIgnoreCase("to") || split[0].equalsIgnoreCase("from")) {
            if (split.length > 2) {
                return PlayerHandler.getPlayerTabName(split[1] + " " + split[2]);
            }
            if (split.length > 1) {
                return PlayerHandler.getPlayerTabName(split[1]);
            }
        }
        return split[0];
    }

    private static String getCurrentTimeStamp() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        int minutes = c.get(12);
        String multiple = "";
        if (minutes < 10) {
            multiple = "0";
        }
        return "[" + c.get(11) + ":" + multiple + minutes + "] ";
    }
}

