/*
 * Decompiled with CFR 0.152.
 */
package com.sky.hcm.window;

import com.sky.hcm.util.PlayerHandler;
import com.sky.hcm.window.HCMKeyListener;
import com.sky.hcm.window.HCMTabbedPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class HCMTab
extends JPanel {
    private HCMTabbedPane parent;
    private String name;
    private JLabel lblTitle;
    private JScrollPane scroll;
    private JTextPane textField;
    private JTextPane sendText;
    private JPanel bag;

    public HCMTab(HCMTabbedPane parent, LayoutManager layout, String name) {
        super(layout);
        this.parent = parent;
        this.name = name;
        this.initialize();
    }

    private void initialize() {
        this.createLabel();
        this.createTextFields();
        this.setVisible(true);
    }

    public void createLabel() {
        JButton btnClose = new JButton("x");
        this.lblTitle = new JLabel(this.name);
        this.lblTitle.setOpaque(true);
        this.lblTitle.setForeground(PlayerHandler.getPlayerColor(this.name));
        this.setOpaque(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.lblTitle.setOpaque(true);
        this.add((Component)this.lblTitle, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        this.add((Component)btnClose, gbc);
        btnClose.addActionListener(new CloseActionListener());
    }

    public void createTextFields() {
        this.bag = new JPanel();
        this.bag.setBackground(Color.black);
        this.textField = new JTextPane();
        this.textField.setEditable(false);
        this.scroll = new JScrollPane(this.textField);
        DefaultCaret caret = (DefaultCaret)this.textField.getCaret();
        caret.setUpdatePolicy(2);
        this.scroll.setPreferredSize(new Dimension(500, 510));
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setVerticalScrollBarPolicy(20);
        this.sendText = new JTextPane();
        if (this.name.equals("HCM INFO")) {
            this.sendText.setEditable(false);
        } else {
            this.sendText.addKeyListener(new HCMKeyListener(this));
        }
        this.bag.add(this.scroll);
        this.bag.add(this.sendText);
    }

    public void appendText(String message, Color c, boolean doEnter) {
        message = message.replace("\n", "").replaceAll("\u00c2\u00a7\\w", "").trim() + " ";
        if (doEnter) {
            message = message + "\n";
        }
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, c);
        StyledDocument doc = this.textField.getStyledDocument();
        try {
            doc.insertString(doc.getLength(), message, aset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void resizeScreen(int height, int width) {
        Dimension text = new Dimension(width, 50);
        Dimension view = new Dimension(width, height - 50);
        this.sendText.setPreferredSize(text);
        this.scroll.setPreferredSize(view);
    }

    public void setLabelBackground(Color color) {
        this.lblTitle.setBackground(color);
    }

    public void setScrollDimension(Dimension dim) {
        this.scroll.setPreferredSize(dim);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getChatText() {
        return this.sendText.getText();
    }

    public void deleteChatText() {
        this.sendText.setText("");
    }

    public JPanel getBag() {
        return this.bag;
    }

    public class CloseActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            HCMTab.this.parent.removeTab(HCMTab.this);
        }
    }
}

