/*
 * Decompiled with CFR 0.152.
 */
package com.sky.hcm;

import com.sky.hcm.HCM;
import com.sky.hcm.util.ChatHandler;
import net.minecraftforge.common.config.Configuration;

public class Settings {
    public static boolean chatPling;
    public static boolean showLobbyChat;
    public static boolean showFriendRequests;
    public static boolean autoAcceptFriends;
    public static boolean showFriendMessages;
    public static boolean showServerChat;
    public static boolean blockChatDisplay;
    public static String[] notifyWords;

    public static String getNotifyWordsAsString() {
        String notify = "";
        for (String s : notifyWords) {
            notify = notify + s + ",";
        }
        return notify;
    }

    public static String[] getNotifyWordsAsArray() {
        return notifyWords;
    }

    public static void setNotifyWords(String notify) {
        notifyWords = notify.split(",");
    }

    public static void setConfigValue(String key, String value) {
        HCM.config.get("general", key, value).set(value);
        ChatHandler.log(key + " set to " + value);
        HCM.config.save();
    }

    public static void setConfigValue(String key, boolean value) {
        HCM.config.get("general", key, value).set(value);
        ChatHandler.log(key + " set to " + value);
        HCM.config.save();
    }

    public static void setConfigValue(String key, int value) {
        HCM.config.get("general", key, value).set(value);
        ChatHandler.log(key + " set to " + value);
        HCM.config.save();
    }

    public static void load() {
        Configuration config = HCM.config;
        config.load();
        chatPling = config.get("general", "chatpling", true).getBoolean();
        ChatHandler.log("Chatpling set to " + chatPling);
        showLobbyChat = config.get("general", "lobbychat", true).getBoolean();
        ChatHandler.log("Lobbychat set to " + showLobbyChat);
        showFriendRequests = config.get("general", "frequests", false).getBoolean();
        ChatHandler.log("Friend Requests set to " + showFriendRequests);
        showFriendMessages = config.get("general", "friendnotifications", true).getBoolean();
        ChatHandler.log("Friend Login Messages set to " + showFriendMessages);
        showServerChat = config.get("general", "notifyserver", true).getBoolean();
        ChatHandler.log("Server chat set to " + showServerChat);
        blockChatDisplay = config.get("general", "blockdisplay", false).getBoolean();
        ChatHandler.log("Block visual chat set to " + blockChatDisplay);
        Settings.setNotifyWords(config.get("general", "notifyword", "").getString());
        ChatHandler.log("Notification words set to " + Settings.getNotifyWordsAsString());
    }
}

