/*
 * Decompiled with CFR 0.152.
 */
package com.sky.hcm.window;

import com.sky.hcm.Settings;
import com.sky.hcm.window.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class HCMToolbar
extends JMenuBar
implements ActionListener {
    private Frame frame;

    public HCMToolbar(Frame frame) {
        this.frame = frame;
        this.initialize();
    }

    private void initialize() {
        JMenu optionsMenu = new JMenu("options");
        JMenuItem togglePling = new JMenuItem("Toggle chatpling");
        JMenuItem toggleLobbyChat = new JMenuItem("Toggle Lobby Chat");
        JMenuItem notifyWord = new JMenuItem("Notify Word");
        JMenuItem server = new JMenuItem("Toggle Server Chat");
        notifyWord.addActionListener(this);
        optionsMenu.add(notifyWord);
        togglePling.addActionListener(this);
        optionsMenu.add(togglePling);
        toggleLobbyChat.addActionListener(this);
        optionsMenu.add(toggleLobbyChat);
        server.addActionListener(this);
        optionsMenu.add(server);
        this.add(optionsMenu);
        JMenu friendsMenu = new JMenu("friends");
        JMenuItem toggleFreq = new JMenuItem("Toggle friend request notify");
        toggleFreq.addActionListener(this);
        friendsMenu.add(toggleFreq);
        JMenuItem toggleAutoAccept = new JMenuItem("Toggle Automatically accepting friends");
        toggleAutoAccept.addActionListener(this);
        JMenuItem toggleFnotification = new JMenuItem("Toggle friends join/leave messages");
        toggleFnotification.addActionListener(this);
        friendsMenu.add(toggleFnotification);
        this.add(friendsMenu);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o instanceof JMenuItem) {
            JMenuItem menu = (JMenuItem)o;
            String name = menu.getText();
            if (name.equals("Toggle chatpling")) {
                Settings.chatPling = !Settings.chatPling;
                Settings.setConfigValue("chatpling", Settings.chatPling);
                return;
            }
            if (name.equals("Toggle Lobby Chat")) {
                Settings.showLobbyChat = !Settings.showLobbyChat;
                Settings.setConfigValue("lobbychat", Settings.showLobbyChat);
                return;
            }
            if (name.equals("Notify Word")) {
                String word = JOptionPane.showInputDialog(this.frame, "Please put in your notify words (seperate using \",\" :", Settings.getNotifyWordsAsString());
                if (word == null) {
                    word = "";
                }
                Settings.setNotifyWords(word);
                Settings.setConfigValue("notifyword", word);
                return;
            }
            if (name.equals("Toggle friend request notify")) {
                Settings.showFriendRequests = !Settings.showFriendRequests;
                Settings.setConfigValue("frequests", Settings.showFriendRequests);
                return;
            }
            if (name.equals("Toggle Automatically accepting friends")) {
                Settings.autoAcceptFriends = !Settings.autoAcceptFriends;
                Settings.setConfigValue("autoacceptf", Settings.autoAcceptFriends);
                return;
            }
            if (name.equals("Toggle friends join/leave messages")) {
                Settings.showFriendMessages = !Settings.showFriendMessages;
                Settings.setConfigValue("friendnotifications", Settings.showFriendMessages);
                return;
            }
            if (name.equals("Toggle Server Chat")) {
                Settings.showServerChat = !Settings.showServerChat;
                Settings.setConfigValue("notifyserver", Settings.showServerChat);
                return;
            }
        }
    }
}

