/*
 * Decompiled with CFR 0.152.
 */
package com.sky.hcm.window;

import com.sky.hcm.util.ChatHandler;
import com.sky.hcm.window.HCMTab;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HCMTabbedPane
extends JTabbedPane {
    public ArrayList<HCMTab> tabs = new ArrayList();
    public ChatHandler chatHandler = new ChatHandler(this);

    public HCMTabbedPane() {
        this.initialize();
    }

    private void initialize() {
        this.addChangeListener();
    }

    public HCMTab getTab(String name) {
        for (HCMTab tab : this.tabs) {
            if (!tab.getName().equals(name)) continue;
            return tab;
        }
        HCMTab tab = new HCMTab(this, new GridBagLayout(), name);
        this.add(name, tab.getBag());
        this.setTabComponentAt(this.indexOfTab(name), tab);
        this.tabs.add(tab);
        this.resize();
        return tab;
    }

    public HCMTab removeTab(String name) {
        for (HCMTab tab : this.tabs) {
            if (!tab.getName().equals(name)) continue;
            this.tabs.remove(tab);
            this.remove(this.indexOfTab(tab.getName()));
            return tab;
        }
        return null;
    }

    public void removeTab(HCMTab tab) {
        this.tabs.remove(tab);
        this.remove(this.indexOfTab(tab.getName()));
    }

    private void addChangeListener() {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HCMTabbedPane.this.getSelectedIndex() < 0) {
                    return;
                }
                Component source = HCMTabbedPane.this.getTabComponentAt(HCMTabbedPane.this.getSelectedIndex());
                if (source == null) {
                    return;
                }
                if (source instanceof HCMTab) {
                    HCMTab panel = (HCMTab)source;
                    panel.setLabelBackground(null);
                }
            }
        });
    }

    public void resize() {
        Insets scnMax = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        int taskBarSize = scnMax.top;
        int bottomBarSize = scnMax.bottom;
        int heightD = this.getHeight() - taskBarSize - bottomBarSize + 20 - 30 * this.getTabRunCount();
        int widthD = this.getWidth() - 10;
        for (HCMTab tab : this.tabs) {
            tab.resizeScreen(heightD, widthD);
        }
    }
}

