/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.friendremover.data;

import com.google.gson.JsonObject;
import com.skyerzz.friendremover.api.exception.MalformedAPIKeyException;
import com.skyerzz.friendremover.api.exception.PlayerNonExistentException;
import com.skyerzz.friendremover.api.exception.RequestTypeException;
import com.skyerzz.friendremover.data.HypixelPlayerData;
import com.skyerzz.friendremover.data.UUIDHelper;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.Minecraft;

public class HypixelFriend {
    UUID ourUUID;
    UUID friendUUID;
    long friendEpoch;
    private HypixelPlayerData friendData;
    private boolean shouldBeRemoved = true;

    public HypixelFriend(UUID ourUUID, UUID friendUUID, long friendEpoch) {
        this.ourUUID = ourUUID;
        this.friendUUID = friendUUID;
        this.friendEpoch = friendEpoch;
    }

    public HypixelFriend(JsonObject json) {
        UUID firstUUID = UUIDHelper.getUUID(json.get("uuidSender").getAsString());
        UUID secondUUID = UUIDHelper.getUUID(json.get("uuidReceiver").getAsString());
        if (firstUUID.equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            this.ourUUID = firstUUID;
            this.friendUUID = secondUUID;
        } else {
            this.ourUUID = secondUUID;
            this.friendUUID = firstUUID;
        }
        this.friendEpoch = json.get("started").getAsLong();
    }

    public UUID getOurUUID() {
        return this.ourUUID;
    }

    public UUID getFriendUUID() {
        return this.friendUUID;
    }

    public long getFriendEpoch() {
        return this.friendEpoch;
    }

    public void getAPIData(String apiKey) throws RequestTypeException, PlayerNonExistentException, MalformedAPIKeyException, IOException {
        this.friendData = new HypixelPlayerData(this.friendUUID, apiKey);
    }

    public HypixelPlayerData getFriendData() {
        return this.friendData;
    }

    public boolean shouldBeRemoved() {
        return this.shouldBeRemoved;
    }

    public void setShouldBeRemoved(boolean shouldBeRemoved) {
        this.shouldBeRemoved = shouldBeRemoved;
    }
}

