/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.friendremover.gui;

import com.skyerzz.friendremover.FriendRemover;
import com.skyerzz.friendremover.RemoveFriendsCommand;
import com.skyerzz.friendremover.data.HypixelFriend;
import com.skyerzz.friendremover.gui.DrawHelper;
import com.skyerzz.friendremover.gui.GUI;

public class Button {
    public int x;
    public int y;
    public int width;
    public int height;
    public int state;

    public Button(int state) {
        this.state = state;
    }

    public void draw(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        DrawHelper.drawSquare(x, y, width, height, 0, -1426128896, true);
        if (this.state == 0) {
            DrawHelper.drawText("Remove Selected (" + this.countFriendsToRemove() + ") Friends", x + 5, y + 5, -1);
        } else if (this.state == 1) {
            DrawHelper.drawText("I'm sure, remove them", x + 5, y + 5, -1);
        }
    }

    private int countFriendsToRemove() {
        int cnt = 0;
        for (HypixelFriend friend : RemoveFriendsCommand.friends) {
            if (!friend.shouldBeRemoved()) continue;
            ++cnt;
        }
        return cnt;
    }

    public void mouseClicked(int mouseX, int mouseY) {
        if (this.state == 0) {
            System.out.println("Found click on remove button!");
            GUI.enableDangerMode();
        } else {
            System.out.println("Click on DANGER button");
            FriendRemover.removeFriends(GUI.FRIENDS_TO_REMOVE);
        }
    }
}

