/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.friendremover.gui;

import com.skyerzz.friendremover.data.HypixelFriend;
import com.skyerzz.friendremover.data.Rank;
import com.skyerzz.friendremover.gui.DrawHelper;
import com.skyerzz.friendremover.gui.OptionMenu;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;

public class ScrollableList {
    public static final int MIN_WIDTH = 200;
    private static final int BACKGROUND = -1436129690;
    private static final int SCROLLBAR = -1;
    private static final int SCROLLBAR_WIDTH = 5;
    private static final int SCROLLBAR_HEIGHT = 60;
    private static final int FRIEND_BOX_HEIGHT = 24;
    private static final int FRIEND_BOX_SPACER = 2;
    private ArrayList<HypixelFriend> friends;
    public int x;
    public int y;
    public int width;
    public int height;
    private int lastMouseClickX;
    private int lastMouseClickY;
    private int originalIndex = 0;
    private String filterName = "";
    private OptionMenu menu;
    private int index = 0;

    public ScrollableList(OptionMenu optionMenu, ArrayList<HypixelFriend> friends) {
        this.friends = friends;
        this.menu = optionMenu;
    }

    public void draw(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        if (!this.filterName.isEmpty()) {
            DrawHelper.drawText("Filter: " + this.filterName, x, y - 20, -14430272);
        }
        if (this.menu != null) {
            this.drawShowingString(x, y - 10);
        } else {
            DrawHelper.drawText("Removing " + this.friends.size() + " friends:", x, y - 10, -65536);
        }
        DrawHelper.drawSquare(x, y, width, height, 0, -1436129690, true);
        this.drawScrollbar(x, y, width, height);
        this.drawFriends(x, y, width, height);
    }

    private void drawShowingString(int x, int y) {
        String showing = "";
        if (this.filterName == null || this.filterName.isEmpty()) {
            showing = "Showing " + this.friends.size() + "/" + this.friends.size();
        } else {
            int cnt = 0;
            for (HypixelFriend friend : this.friends) {
                if (!friend.getFriendData().getName().toLowerCase().contains(this.filterName)) continue;
                ++cnt;
            }
            showing = "Showing " + cnt + "/" + this.friends.size();
        }
        DrawHelper.drawText(showing, x, y, -14430272);
    }

    private void drawFriends(int x, int y, int width, int height) {
        int maxFriends = height / 26;
        ArrayList<HypixelFriend> list = this.filteredFriends();
        for (int i = 0; i < maxFriends && list.size() > this.index + i; ++i) {
            HypixelFriend friend = list.get(this.index + i);
            this.drawFriend(x, y + 26 * i, friend);
        }
    }

    private ArrayList<HypixelFriend> filteredFriends() {
        if (this.filterName.isEmpty()) {
            return this.friends;
        }
        ArrayList<HypixelFriend> filtered = new ArrayList<HypixelFriend>();
        for (HypixelFriend f : this.friends) {
            if (!f.getFriendData().getName().toLowerCase().contains(this.filterName)) continue;
            filtered.add(f);
        }
        return filtered;
    }

    private void drawFriend(int x, int y, HypixelFriend friend) {
        DrawHelper.drawSquare(x, y, this.width - 5 - 2, 24.0, 0, friend.shouldBeRemoved() ? -3072256 : -14426589, false);
        int orgx = x += 2;
        Rank rank = friend.getFriendData().getRank();
        if (rank != Rank.NONE) {
            if (friend.getFriendData().getPrefix() != null && friend.getFriendData().getRank() != Rank.BUILD_TEAM) {
                DrawHelper.drawText(friend.getFriendData().getPrefix(), x, y + 2, rank.getColor());
                x += Minecraft.func_71410_x().field_71466_p.func_78256_a(friend.getFriendData().getPrefix());
            } else if (rank == Rank.VIP_PLUS || rank == Rank.MVP_PLUS || rank == Rank.SUPERSTAR) {
                DrawHelper.drawText(rank.getDisplayName().substring(0, 4), x, y + 2, rank.getColor());
                int plusColor = rank == Rank.VIP_PLUS ? -22016 : -43691;
                DrawHelper.drawText("+", x += Minecraft.func_71410_x().field_71466_p.func_78256_a(rank.getDisplayName().substring(0, 4)), y + 2, plusColor);
                x += Minecraft.func_71410_x().field_71466_p.func_78256_a("+");
                if (rank == Rank.SUPERSTAR) {
                    DrawHelper.drawText("+", x, y + 2, plusColor);
                    x += Minecraft.func_71410_x().field_71466_p.func_78256_a("+");
                }
                DrawHelper.drawText("]", x, y + 2, rank.getColor());
                x += Minecraft.func_71410_x().field_71466_p.func_78256_a("]");
            } else {
                DrawHelper.drawText(rank.getDisplayName(), x, y + 2, rank.getColor());
                x += Minecraft.func_71410_x().field_71466_p.func_78256_a(rank.getDisplayName());
            }
            DrawHelper.drawText(" ", x, y + 2, -5592406);
            x += Minecraft.func_71410_x().field_71466_p.func_78256_a(" ");
        }
        DrawHelper.drawText(friend.getFriendData().getName(), x, y + 2, rank.getColor());
        DrawHelper.drawText("Network Level: " + (friend.getFriendData().getNetworkLevel() == -1 ? "PRIVATE" : Integer.valueOf(friend.getFriendData().getNetworkLevel())), orgx, y + 2 + 10, -16733526);
        if (this.menu != null) {
            DrawHelper.drawText("\u267b", this.x + this.width - 40, (float)(y + 2) + 4.25f, -1886421);
            DrawHelper.drawText("\u2764", this.x + this.width - 60, y + 2 + 4, -14426589);
        }
    }

    private void drawScrollbar(int x, int y, int width, int height) {
        int maxFriends = height / 26;
        float ppt = (float)(height - 60) / (float)(this.friends.size() - maxFriends);
        float scrollbarStart = ppt * (float)this.index;
        DrawHelper.drawSquare(x + width - 6, y, 6.0, height, 1, -12237499, true);
        DrawHelper.drawSquare(x + width - 5, (float)y + scrollbarStart, 5.0, 60.0, 1, -1434090107, true);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        int maxFriends = this.height / 26;
        this.index = index;
        if (this.index < 0) {
            this.index = 0;
        } else if (this.index > this.friends.size() - maxFriends) {
            this.index = this.friends.size() - maxFriends;
        }
    }

    public void mouseClicked(int mouseX, int mouseY) {
        this.lastMouseClickX = mouseX;
        this.lastMouseClickY = mouseY;
        this.originalIndex = this.index;
        if (mouseX >= this.x + (this.width - 5) - 1 || mouseX < this.x) {
            return;
        }
        int maxFriends = this.height / 26;
        int actualFriendsOnScreenSize = maxFriends * 26;
        int perFriend = actualFriendsOnScreenSize / maxFriends;
        int relIndex = (mouseY - this.y) / perFriend;
        int clickedIndex = this.index + relIndex;
        ArrayList<HypixelFriend> filter = this.filteredFriends();
        if (clickedIndex < filter.size() && clickedIndex >= 0) {
            HypixelFriend fr = filter.get(clickedIndex);
            this.handleFriendClick(mouseX, mouseY, fr, relIndex);
        }
    }

    private void handleFriendClick(int mouseX, int mouseY, HypixelFriend fr, int relIndex) {
        int relY = this.y + relIndex * 24 + (relIndex > 0 ? (relIndex - 1) * 2 : 0);
        if ((float)mouseY > (float)relY + 6.0f && (float)mouseY < (float)relY + 16.0f) {
            if (mouseX > this.x + this.width - 40 && mouseX < this.x + this.width - 30) {
                this.updateFriend(fr, true);
            } else if (mouseX > this.x + this.width - 60 && mouseX < this.x + this.width - 50) {
                this.updateFriend(fr, false);
            }
        }
    }

    private void updateFriend(HypixelFriend friend, boolean shouldBeRemoved) {
        friend.setShouldBeRemoved(shouldBeRemoved);
        for (HypixelFriend fr : this.friends) {
            if (fr.equals(friend) || !fr.getFriendData().getRank().equals((Object)friend.getFriendData().getRank()) || fr.shouldBeRemoved() == friend.shouldBeRemoved()) continue;
            this.menu.updateRankState(fr.getFriendData().getRank(), OptionMenu.MIXED);
            return;
        }
        this.menu.updateRankState(friend.getFriendData().getRank(), shouldBeRemoved ? OptionMenu.REMOVE_ALL : OptionMenu.KEEP_ALL);
    }

    public void resetClicks() {
        this.lastMouseClickY = -1;
        this.lastMouseClickX = -1;
    }

    public void drag(int toX, int toY) {
        if (this.lastMouseClickX < this.x + this.width - 5 - 1) {
            return;
        }
        int maxFriends = this.height / 26;
        float ppt = (float)(this.height - 60) / (float)(this.friends.size() - maxFriends);
        int relY = this.lastMouseClickY - toY;
        if (relY == 0) {
            return;
        }
        this.setIndex(this.originalIndex + (int)((float)(-relY) / ppt));
    }

    public void backspace() {
        this.index = 0;
        if (this.filterName != null && !this.filterName.isEmpty()) {
            this.filterName = this.filterName.substring(0, this.filterName.length() - 1);
        }
    }

    public void handleCharTyped(char typedChar) {
        this.index = 0;
        if (this.filterName.length() >= 16) {
            return;
        }
        this.filterName = this.filterName + typedChar;
    }
}

