/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.friendremover.gui;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TestDrawHelper {
    private boolean randomStyle;
    private boolean boldStyle;
    private boolean italicStyle;
    private boolean underlineStyle;
    private boolean strikethroughStyle;
    protected static int[] charWidth = new int[256];
    public int FONT_HEIGHT = 9;
    private static ResourceLocation ASCII_FONT;

    public static void init() {
        ASCII_FONT = new ResourceLocation("textures/font/ascii.png");
        TestDrawHelper.readFontTexture();
    }

    public int drawStringWithShadow(String text, float x, float y, int color) {
        return this.drawString(text, x, y, color, true);
    }

    protected static InputStream getResourceInputStream(ResourceLocation location) throws IOException {
        return Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b();
    }

    private static void readFontTexture() {
        BufferedImage bufferedimage;
        try {
            bufferedimage = TextureUtil.func_177053_a((InputStream)TestDrawHelper.getResourceInputStream(ASCII_FONT));
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        int i = bufferedimage.getWidth();
        int j = bufferedimage.getHeight();
        int[] aint = new int[i * j];
        bufferedimage.getRGB(0, 0, i, j, aint, 0, i);
        int k = j / 16;
        int l = i / 16;
        int i1 = 1;
        float f = 8.0f / (float)l;
        for (int j1 = 0; j1 < 256; ++j1) {
            int i2;
            int k1 = j1 % 16;
            int l1 = j1 / 16;
            if (j1 == 32) {
                TestDrawHelper.charWidth[j1] = 3 + i1;
            }
            for (i2 = l - 1; i2 >= 0; --i2) {
                int j2 = k1 * l + i2;
                boolean flag = true;
                for (int k2 = 0; k2 < k && flag; ++k2) {
                    int l2 = (l1 * l + k2) * i;
                    if ((aint[j2 + l2] >> 24 & 0xFF) == 0) continue;
                    flag = false;
                }
                if (!flag) break;
            }
            TestDrawHelper.charWidth[j1] = (int)(0.5 + (double)((float)(++i2) * f)) + i1;
        }
    }

    public int drawString(String text, float x, float y, int color, boolean dropShadow) {
        int i;
        GlStateManager.func_179141_d();
        this.resetStyles();
        if (dropShadow) {
            i = this.renderString(text, x + 1.0f, y + 1.0f, color, true);
            i = Math.max(i, this.renderString(text, x, y, color, false));
        } else {
            i = this.renderString(text, x, y, color, false);
        }
        return i;
    }

    private int renderString(String text, float x, float y, int color, boolean dropShadow) {
        if (text == null) {
            return 0;
        }
        if ((color & 0xFC000000) == 0) {
            color |= 0xFF000000;
        }
        if (dropShadow) {
            color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float blue = (float)(color >> 8 & 0xFF) / 255.0f;
        float green = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        this.setColor(red, blue, green, alpha);
        this.renderStringAtPos(text, x, y, dropShadow, color);
        return (int)x;
    }

    private void renderStringAtPos(String text, float x, float y, boolean shadow, int color) {
        float acX = x;
        float acY = y;
        for (int i = 0; i < text.length(); ++i) {
            boolean flag;
            char c0 = text.charAt(i);
            int j = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(c0);
            float f1 = j == -1 ? 0.5f : 1.0f;
            boolean bl = flag = (c0 == '\u0000' || j == -1) && shadow;
            if (flag) {
                acX -= f1;
                acY -= f1;
            }
            float f = this.func_181559_a(c0, this.italicStyle, acX, acY);
            if (flag) {
                acX += f1;
                acY += f1;
            }
            if (this.boldStyle) {
                acX += f1;
                if (flag) {
                    acX -= f1;
                    acY -= f1;
                }
                this.func_181559_a(c0, this.italicStyle, x, y);
                acX -= f1;
                if (flag) {
                    acX += f1;
                    acY += f1;
                }
                f += 1.0f;
            }
            this.doDraw(f, acX, acY);
            acX += f;
        }
    }

    protected void doDraw(float f, float x, float y) {
        if (this.strikethroughStyle) {
            Tessellator tessellator = Tessellator.func_178181_a();
            WorldRenderer worldrenderer = tessellator.func_178180_c();
            GlStateManager.func_179090_x();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            worldrenderer.func_181662_b((double)x, (double)(y + (float)(this.FONT_HEIGHT / 2)), 0.0).func_181675_d();
            worldrenderer.func_181662_b((double)(x + f), (double)(y + (float)(this.FONT_HEIGHT / 2)), 0.0).func_181675_d();
            worldrenderer.func_181662_b((double)(x + f), (double)(y + (float)(this.FONT_HEIGHT / 2) - 1.0f), 0.0).func_181675_d();
            worldrenderer.func_181662_b((double)x, (double)(y + (float)(this.FONT_HEIGHT / 2) - 1.0f), 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
        }
        if (this.underlineStyle) {
            Tessellator tessellator1 = Tessellator.func_178181_a();
            WorldRenderer worldrenderer1 = tessellator1.func_178180_c();
            GlStateManager.func_179090_x();
            worldrenderer1.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            int l = this.underlineStyle ? -1 : 0;
            worldrenderer1.func_181662_b((double)(x + (float)l), (double)(y + (float)this.FONT_HEIGHT), 0.0).func_181675_d();
            worldrenderer1.func_181662_b((double)(x + f), (double)(y + (float)this.FONT_HEIGHT), 0.0).func_181675_d();
            worldrenderer1.func_181662_b((double)(x + f), (double)(y + (float)this.FONT_HEIGHT - 1.0f), 0.0).func_181675_d();
            worldrenderer1.func_181662_b((double)(x + (float)l), (double)(y + (float)this.FONT_HEIGHT - 1.0f), 0.0).func_181675_d();
            tessellator1.func_78381_a();
            GlStateManager.func_179098_w();
        }
        x += (float)((int)f);
    }

    private float func_181559_a(char ch, boolean italic, float x, float y) {
        if (ch == ' ') {
            return 4.0f;
        }
        int i = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(ch);
        return this.renderDefaultChar(i, italic, x, y);
    }

    protected void bindTexture(ResourceLocation location) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(location);
    }

    protected float renderDefaultChar(int ch, boolean italic, float x, float y) {
        float z = 1.0f;
        int i = ch % 16 * 8;
        int j = ch / 16 * 8;
        boolean k = italic;
        this.bindTexture(ASCII_FONT);
        int l = charWidth[ch];
        float f = (float)l - 0.01f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)((float)i / 128.0f), (float)((float)j / 128.0f));
        GL11.glVertex3f((float)(x + (float)k), (float)y, (float)z);
        GL11.glTexCoord2f((float)((float)i / 128.0f), (float)(((float)j + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(x - (float)k), (float)(y + 7.99f), (float)z);
        GL11.glTexCoord2f((float)(((float)i + f - 1.0f) / 128.0f), (float)((float)j / 128.0f));
        GL11.glVertex3f((float)(x + f - 1.0f + (float)k), (float)y, (float)z);
        GL11.glTexCoord2f((float)(((float)i + f - 1.0f) / 128.0f), (float)(((float)j + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(x + f - 1.0f - (float)k), (float)(y + 7.99f), (float)z);
        GL11.glEnd();
        return l;
    }

    protected void setColor(float r, float g, float b, float a) {
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }

    private void resetStyles() {
        this.randomStyle = false;
        this.boldStyle = false;
        this.italicStyle = false;
        this.underlineStyle = false;
        this.strikethroughStyle = false;
    }
}

