/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.friendremover.gui;

import com.skyerzz.friendremover.RemoveFriendsCommand;
import com.skyerzz.friendremover.data.HypixelFriend;
import com.skyerzz.friendremover.data.Rank;
import com.skyerzz.friendremover.gui.DrawHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class OptionMenu {
    public static final int MIN_WIDTH = 100;
    public static final int CHECKBOX_HEIGHT = 10;
    public static final int CHECKBOX_SPACER = 2;
    public static final int SPACE_BORDER = 5;
    public static int REMOVE_ALL = 0;
    public static int KEEP_ALL = 1;
    public static int MIXED = 2;
    public int x;
    public int y;
    public int width;
    public int height;
    private int lastMouseClickX;
    private int lastMouseClickY;
    private ArrayList<Rank> ranks = new ArrayList();
    private HashMap<Rank, Integer> states = new HashMap();

    public OptionMenu() {
        this.indexRanks();
    }

    public void updateRankState(Rank rank, int state) {
        this.states.put(rank, state);
    }

    private void indexRanks() {
        ArrayList<Rank> rks = new ArrayList<Rank>();
        for (HypixelFriend f : RemoveFriendsCommand.friends) {
            Rank r = f.getFriendData().getRank();
            if (rks.contains((Object)r)) continue;
            rks.add(r);
        }
        for (Rank r : Rank.values()) {
            if (!rks.contains((Object)r)) continue;
            this.ranks.add(r);
            this.states.put(r, REMOVE_ALL);
        }
    }

    public void draw(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        DrawHelper.drawSquare(x, y, width, height, 0, 0x44666666, true);
        x += 5;
        y += 5;
        for (Rank r : this.ranks) {
            this.drawCheckBox(r, x, y);
            y += 12;
        }
    }

    private void drawCheckBox(Rank r, int x, int y) {
        int state = this.states.get((Object)r);
        DrawHelper.drawSquare(x, y, 10.0, 10.0, 1, -10066330, false);
        if (state == MIXED) {
            DrawHelper.drawShape(true, 0.0, -1442775296, x + 9, y + 1, x + 1, y + 1, x + 1, y + 9);
            DrawHelper.drawShape(true, 0.0, -1426128896, x + 9, y + 1, x + 1, y + 9, x + 9, y + 9);
        } else {
            DrawHelper.drawSquare(x, y, 10.0, 10.0, 0, state == KEEP_ALL ? -1442775296 : -1426128896, true);
        }
        DrawHelper.drawText(r.getDisplayName(), x + 20, y + 2, r.getColor());
    }

    public void mouseClicked(int mouseX, int mouseY) {
        this.lastMouseClickX = mouseX;
        this.lastMouseClickY = mouseY;
        if (mouseX >= this.x + this.width || mouseX < this.x) {
            return;
        }
        if (mouseX >= this.x + 5 && mouseX <= this.x + 5 + 10) {
            int index;
            int relY = mouseY - this.y - 5;
            int ppr = 12;
            int clickedIndex = relY / ppr;
            if (clickedIndex >= this.ranks.size()) {
                return;
            }
            this.setAllRanks(this.ranks.get(clickedIndex), (index = this.states.get((Object)this.ranks.get(clickedIndex)).intValue()) != REMOVE_ALL);
        }
    }

    private void setAllRanks(Rank rank, boolean shouldRemove) {
        for (HypixelFriend friend : RemoveFriendsCommand.friends) {
            if (friend.getFriendData().getRank() != rank) continue;
            friend.setShouldBeRemoved(shouldRemove);
        }
        this.updateRankState(rank, shouldRemove ? REMOVE_ALL : KEEP_ALL);
    }

    public void resetClicks() {
        this.lastMouseClickY = -1;
        this.lastMouseClickX = -1;
    }
}

