/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.friendremover;

import com.google.gson.JsonElement;
import com.skyerzz.friendremover.FriendRemover;
import com.skyerzz.friendremover.api.APIRequest;
import com.skyerzz.friendremover.api.APIRequestBuilder;
import com.skyerzz.friendremover.api.FriendAPI;
import com.skyerzz.friendremover.api.exception.MalformedAPIKeyException;
import com.skyerzz.friendremover.api.exception.PlayerNonExistentException;
import com.skyerzz.friendremover.api.exception.RequestTypeException;
import com.skyerzz.friendremover.data.HypixelFriend;
import com.skyerzz.friendremover.gui.GUI;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class RemoveFriendsCommand
extends CommandBase {
    public static ArrayList<HypixelFriend> friends = new ArrayList();
    private static boolean isIndexing = false;

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("apikey") || args[0].equalsIgnoreCase("setkey") || args[0].equalsIgnoreCase("setapikey")) {
                if (args.length < 2) {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Invalid use! Usage: /removefriends apikey <Key>"));
                    return;
                }
                FriendRemover.API_KEY = args[1];
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Succesfully set your API key to " + args[1]));
            } else {
                if (args[0].equalsIgnoreCase("resetIndexing") || args[0].equalsIgnoreCase("refresh") || args[0].equalsIgnoreCase("reset")) {
                    if (isIndexing) {
                        ChatComponentText txt = new ChatComponentText("[FriendRemover] We're still indexing! You can't reset till we're done!");
                        txt.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)txt);
                        return;
                    }
                    isIndexing = true;
                    friends.clear();
                    this.startIndexing();
                    ChatComponentText txt = new ChatComponentText("[FriendRemover] Resetting your friends, and re-indexing...");
                    txt.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)txt);
                    return;
                }
                ChatComponentText txt = new ChatComponentText("[FriendRemover] Unknown argument! use /removefriends to open the GUI, or /removefriends apikey <apikey> to set your apikey");
                txt.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)txt);
            }
            return;
        }
        if (FriendRemover.API_KEY == null || FriendRemover.API_KEY.isEmpty()) {
            ChatComponentText txt = new ChatComponentText("[FriendRemover] We do not have your API key yet! use /removefriends apikey <key> to set manually, or use /api new to create a new API key for the Hypixel API");
            txt.func_150256_b().func_150238_a(EnumChatFormatting.RED);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)txt);
            return;
        }
        if (isIndexing) {
            ChatComponentText txt = new ChatComponentText("[FriendRemover] We're still indexing your friends, we'll notify you when we're done!");
            txt.func_150256_b().func_150238_a(EnumChatFormatting.RED);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)txt);
            return;
        }
        if (friends.isEmpty()) {
            isIndexing = true;
            this.startIndexing();
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void startIndexing() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                int count = 0;
                long lastSleep = System.currentTimeMillis();
                System.out.println("Getting friendJSON...");
                friends.clear();
                APIRequestBuilder builder = new APIRequestBuilder(APIRequest.RequestType.FRIENDS);
                try {
                    builder.addParam(APIRequest.RequestParam.FRIENDS_BY_UUID, Minecraft.func_71410_x().field_71439_g.func_110124_au().toString().replace("-", ""));
                    APIRequest request = builder.build();
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Getting your friends list..."));
                    FriendAPI fAPI = new FriendAPI(request.getJSON(request.getURL(FriendRemover.API_KEY)));
                    for (JsonElement e : fAPI.getFriends()) {
                        friends.add(new HypixelFriend(e.getAsJsonObject()));
                    }
                    ChatComponentText txt = new ChatComponentText("[FriendRemover] Found " + friends.size() + " friends, indexing... This may take up to " + (friends.size() / 100 + 2) + " minutes");
                    txt.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)txt);
                    System.out.println("Found " + friends.size() + " friends, getting their API data...");
                    for (HypixelFriend friend : friends) {
                        if (++count % 100 == 0) {
                            long sleepTime = 0L;
                            if (System.currentTimeMillis() - lastSleep < 60000L) {
                                sleepTime = 60000L - (System.currentTimeMillis() - lastSleep);
                            }
                            System.out.println("Sleeping on 100 interval at " + count + ". Sleeping for " + sleepTime + " ms.");
                            Thread.sleep(sleepTime);
                            lastSleep = System.currentTimeMillis();
                        }
                        System.out.println("[" + count + "] Getting data for friend " + friend.getFriendUUID());
                        friend.getAPIData(FriendRemover.API_KEY);
                    }
                    txt = new ChatComponentText("[FriendRemover] Your friends have been indexed! use /removefriends to open the GUI!");
                    txt.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)txt);
                    System.out.println("Got all friends indexed!");
                    isIndexing = false;
                }
                catch (RequestTypeException e) {
                    e.printStackTrace();
                }
                catch (MalformedAPIKeyException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (PlayerNonExistentException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            System.out.println("Opening GUIScreen & unregistring");
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GUI(friends));
        }
    }

    public String func_71517_b() {
        return "removefriends";
    }

    public int func_82362_a() {
        return 0;
    }

    public String func_71518_a(ICommandSender sender) {
        return "removefriends";
    }
}

