/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.friendremover.data;

import com.google.gson.JsonObject;
import com.skyerzz.friendremover.api.APIRequest;
import com.skyerzz.friendremover.api.APIRequestBuilder;
import com.skyerzz.friendremover.api.exception.MalformedAPIKeyException;
import com.skyerzz.friendremover.api.exception.PlayerNonExistentException;
import com.skyerzz.friendremover.api.exception.RequestTypeException;
import com.skyerzz.friendremover.data.ILevel;
import com.skyerzz.friendremover.data.Rank;
import java.io.IOException;
import java.util.UUID;

public class HypixelPlayerData {
    private Rank rank;
    private Rank newPackageRank;
    private Rank superStarRank;
    private Rank packageRank;
    private Rank specialRank;
    private int networkLevel = -1;
    private String name;
    private String prefix = null;

    public HypixelPlayerData(UUID friendUUID, String apiKey) throws RequestTypeException, MalformedAPIKeyException, IOException, PlayerNonExistentException {
        APIRequestBuilder builder = new APIRequestBuilder(APIRequest.RequestType.PLAYER).addParam(APIRequest.RequestParam.PLAYER_BY_UUID, friendUUID.toString());
        APIRequest req = builder.build();
        JsonObject json = req.getJSON(req.getURL(apiKey));
        this.indexJson(json);
    }

    private void indexJson(JsonObject json) {
        JsonObject player = json.get("player").getAsJsonObject();
        if (player.has("packageRank")) {
            this.packageRank = Rank.valueOf(player.get("packageRank").getAsString());
        }
        if (player.has("rank")) {
            this.rank = Rank.valueOf(player.get("rank").getAsString());
        }
        if (player.has("newPackageRank")) {
            this.newPackageRank = Rank.valueOf(player.get("newPackageRank").getAsString());
        }
        if (player.has("monthlyPackageRank")) {
            this.superStarRank = Rank.valueOf(player.get("monthlyPackageRank").getAsString());
        }
        int lastLevel = -1;
        int networkEXP = -1;
        if (player.has("networkLevel")) {
            lastLevel = player.get("networkLevel").getAsInt();
        }
        if (player.has("networkExp")) {
            networkEXP = player.get("networkExp").getAsInt();
        }
        this.name = player.get("displayname").getAsString();
        this.networkLevel = networkEXP == -1 && lastLevel == -1 ? -1 : (int)(ILevel.getExactLevel((double)networkEXP + ILevel.getTotalExpToLevel(lastLevel)) + 1.0);
        if (player.has("prefix")) {
            this.prefix = player.get("prefix").getAsString();
            this.prefix = this.prefix.substring(this.prefix.indexOf("[", 0));
            if (this.prefix.toLowerCase().contains("build")) {
                this.specialRank = Rank.BUILD_TEAM;
            }
        }
    }

    public Rank getRank() {
        if (this.specialRank != null) {
            return this.specialRank;
        }
        if (this.rank != null && this.rank != Rank.NONE && this.rank != Rank.DEFAULT && this.rank != Rank.NORMAL) {
            return this.rank;
        }
        if (this.superStarRank == Rank.SUPERSTAR) {
            return this.superStarRank;
        }
        if (this.newPackageRank != null && this.newPackageRank != Rank.NONE && this.newPackageRank != Rank.DEFAULT && this.newPackageRank != Rank.NORMAL) {
            return this.newPackageRank;
        }
        if (this.packageRank != null && this.packageRank != Rank.NONE && this.packageRank != Rank.DEFAULT && this.packageRank != Rank.NORMAL) {
            return this.packageRank;
        }
        return Rank.NONE;
    }

    public int getNetworkLevel() {
        return this.networkLevel;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

