/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util.games.smashheroes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skyerzz.hypixellib.Logger;
import com.skyerzz.hypixellib.OutDated;
import com.skyerzz.hypixellib.util.games.smashheroes.HERO;
import com.skyerzz.hypixellib.util.games.smashheroes.SmashAbility;
import java.util.HashMap;
import java.util.Map;

public class SmashClass {
    private int level = 0;
    private int exp = 0;
    private int prestigeLevel = 0;
    private boolean hasClassUnlocked = false;
    private boolean hasMasterSkinUnlocked = false;
    private HERO hero;
    private HashMap<SmashAbility, Integer> smashedByMove = new HashMap();
    private HashMap<SmashAbility, Integer> smashedByMoveteam = new HashMap();
    private HashMap<SmashAbility, Integer> smashedByMovenormal = new HashMap();
    private HashMap<SmashAbility, Integer> smashedByMove2v2 = new HashMap();
    private HashMap<SmashAbility, Integer> smashedByMove3v3 = new HashMap();
    private HashMap<SmashAbility, Integer> OWNKills2v2 = new HashMap();
    private HashMap<SmashAbility, Integer> OWNkills = new HashMap();
    private HashMap<SmashAbility, Integer> OWNkillsNormal = new HashMap();
    private HashMap<SmashAbility, Integer> OWNKillsTeams = new HashMap();
    private HashMap<SmashAbility, Integer> OWNdamagedealt = new HashMap();
    private HashMap<SmashAbility, Integer> OWNdamagedealtTeams = new HashMap();
    private HashMap<SmashAbility, Integer> OWNdamagedealtNormal = new HashMap();
    private HashMap<SmashAbility, Integer> OWNdamagedealt2v2 = new HashMap();
    private HashMap<SmashAbility, Integer> OWNsmasher = new HashMap();
    private HashMap<SmashAbility, Integer> OWNsmasherNormal = new HashMap();
    private HashMap<SmashAbility, Integer> OWNsmasherTeams = new HashMap();
    private HashMap<SmashAbility, Integer> OWNsmasher2v2 = new HashMap();
    private int deathsNormal;
    private int gamesNormal;
    private int damageDealtNormal;
    private int lossesNormal;
    private int killsNormal;
    private int winsNormal;
    private int smasherNormal;
    private int smashedNormal;
    private int assistsNormal;
    private int winStreakNormal;
    private int deathsTeams;
    private int gamesTeams;
    private int damageDealtTeams;
    private int lossesTeams;
    private int killsTeams;
    private int winsTeams;
    private int smasherTeams;
    private int smashedTeams;
    private int assistsTeams;
    private int winStreakTeams;
    private int deathsFriends;
    private int gamesFriends;
    private int damageDealtFriends;
    private int lossesFriends;
    private int killsFriends;
    private int winsFriends;
    private int smasherFriends;
    private int smashedFriends;
    private int assistsFriends;
    private int winStreakFriends;
    private int deaths2v2;
    private int games2v2;
    private int damageDealt2v2;
    private int losses2v2;
    private int kills2v2;
    private int wins2v2;
    private int smasher2v2;
    private int smashed2v2;
    private int assists2v2;
    private int winStreak2v2;
    private int deaths;
    private int games;
    private int damageDealt;
    private int losses;
    private int kills;
    private int wins;
    private int smasher;
    private int smashed;
    private int assists;
    private int winStreak;
    @OutDated
    private int deaths3v3;
    @OutDated
    private int games3v3;
    @OutDated
    private int damageDealt3v3;
    @OutDated
    private int losses3v3;
    @OutDated
    private int kills3v3;
    @OutDated
    private int wins3v3;
    @OutDated
    private int smasher3v3;
    @OutDated
    private int smashed3v3;
    @OutDated
    private int assists3v3;
    @OutDated
    private int winStreak3v3;
    private HashMap<SmashAbility, Integer> OWNkills3v3 = new HashMap();
    private HashMap<SmashAbility, Integer> OWNdamagedealt3v3 = new HashMap();
    private HashMap<SmashAbility, Integer> OWNsmasher3v3 = new HashMap();

    public SmashClass(HERO hero) {
        this.hero = hero;
    }

    public void setClassJson(JsonObject classJson) {
        this.runJsonInitialisation(classJson);
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setExp(int exp) {
        this.exp = exp;
    }

    public void setPrestigeLevel(int prestigeLevel) {
        this.prestigeLevel = prestigeLevel;
    }

    public void setHasClassUnlocked(boolean hasClassUnlocked) {
        this.hasClassUnlocked = hasClassUnlocked;
    }

    public void setHasMasterSkinUnlocked(boolean hasMasterSkinUnlocked) {
        this.hasMasterSkinUnlocked = hasMasterSkinUnlocked;
    }

    private void runJsonInitialisation(JsonObject json) {
        for (Map.Entry e : json.entrySet()) {
            String key = ((String)e.getKey()).toUpperCase();
            if (((JsonElement)e.getValue()).isJsonObject()) {
                this.runMoveStatsInitialisation(key, ((JsonElement)e.getValue()).getAsJsonObject());
                continue;
            }
            if (this.setValue(key, (JsonElement)e.getValue())) continue;
            Logger.logWarn("[PlayerAPI.SmashHeroes.initializeJson] Unknown value: " + key + " in Hero: " + this.hero.getDisplayName());
        }
    }

    private boolean setValue(String key, JsonElement value) {
        if (key.contains("FRIEND") && key.contains("NORMAL")) {
            Logger.logInfo("Skipping value " + key + " , not known what it is.");
            return true;
        }
        switch (key) {
            case "DEATHS_NORMAL": {
                this.deathsNormal = value.getAsInt();
                return true;
            }
            case "GAMES_NORMAL": {
                this.gamesNormal = value.getAsInt();
                return true;
            }
            case "LOSSES_NORMAL": {
                this.lossesNormal = value.getAsInt();
                return true;
            }
            case "KILLS_NORMAL": {
                this.killsNormal = value.getAsInt();
                return true;
            }
            case "DAMAGE_DEALT_NORMAL": {
                this.damageDealtNormal = value.getAsInt();
                return true;
            }
            case "SMASHER_NORMAL": {
                this.smasherNormal = value.getAsInt();
                return true;
            }
            case "SMASHED_NORMAL": {
                this.smashedNormal = value.getAsInt();
                return true;
            }
            case "WINS_NORMAL": {
                this.winsNormal = value.getAsInt();
                return true;
            }
            case "ASSISTS_NORMAL": {
                this.assistsNormal = value.getAsInt();
                return true;
            }
            case "WIN_STREAK_NORMAL": {
                this.winStreakNormal = value.getAsInt();
                return true;
            }
            case "DEATHS_TEAMS": {
                this.deathsTeams = value.getAsInt();
                return true;
            }
            case "GAMES_TEAMS": {
                this.gamesTeams = value.getAsInt();
                return true;
            }
            case "LOSSES_TEAMS": {
                this.lossesTeams = value.getAsInt();
                return true;
            }
            case "KILLS_TEAMS": {
                this.killsTeams = value.getAsInt();
                return true;
            }
            case "DAMAGE_DEALT_TEAMS": {
                this.damageDealtTeams = value.getAsInt();
                return true;
            }
            case "SMASHER_TEAMS": {
                this.smasherTeams = value.getAsInt();
                return true;
            }
            case "SMASHED_TEAMS": {
                this.smashedTeams = value.getAsInt();
                return true;
            }
            case "WINS_TEAMS": {
                this.winsTeams = value.getAsInt();
                return true;
            }
            case "ASSISTS_TEAMS": {
                this.assistsTeams = value.getAsInt();
                return true;
            }
            case "WIN_STREAK_TEAMS": {
                this.winStreakTeams = value.getAsInt();
                return true;
            }
            case "FRIEND_DEATHS": {
                this.deathsFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_GAMES": {
                this.gamesFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_LOSSES": {
                this.lossesFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_KILLS": {
                this.killsFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_DAMAGE_DEALT": {
                this.damageDealtFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_SMASHER": {
                this.smasherFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_SMASHED": {
                this.smashedFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_WINS": {
                this.winsFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_ASSISTS": {
                this.assistsFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_WIN_STREAK": {
                this.winStreakFriends = value.getAsInt();
                return true;
            }
            case "DEATHS_2V2": {
                this.deaths2v2 = value.getAsInt();
                return true;
            }
            case "GAMES_2V2": {
                this.games2v2 = value.getAsInt();
                return true;
            }
            case "LOSSES_2V2": {
                this.losses2v2 = value.getAsInt();
                return true;
            }
            case "KILLS_2V2": {
                this.kills2v2 = value.getAsInt();
                return true;
            }
            case "DAMAGE_DEALT_2V2": {
                this.damageDealt2v2 = value.getAsInt();
                return true;
            }
            case "SMASHER_2V2": {
                this.smasher2v2 = value.getAsInt();
                return true;
            }
            case "SMASHED_2V2": {
                this.smashed2v2 = value.getAsInt();
                return true;
            }
            case "WINS_2V2": {
                this.wins2v2 = value.getAsInt();
                return true;
            }
            case "ASSISTS_2V2": {
                this.assists2v2 = value.getAsInt();
                return true;
            }
            case "WIN_STREAK_2V2": {
                this.winStreak2v2 = value.getAsInt();
                return true;
            }
            case "DEATHS_3V3": 
            case "DEATHS3V3": {
                this.deaths3v3 = value.getAsInt();
                return true;
            }
            case "GAMES_3V3": 
            case "GAMES3V3": {
                this.games3v3 = value.getAsInt();
                return true;
            }
            case "LOSSES_3V3": 
            case "LOSSES3V3": {
                this.losses3v3 = value.getAsInt();
                return true;
            }
            case "KILLS_3V3": 
            case "KILLS3V3": {
                this.kills3v3 = value.getAsInt();
                return true;
            }
            case "DAMAGE_DEALT3V3": 
            case "DAMAGE_DEALT_3V3": 
            case "DAMAGEDEALT3V3": 
            case "DAMAGEDEALT_3V3": {
                this.damageDealt3v3 = value.getAsInt();
                return true;
            }
            case "SMASHER3V3": 
            case "SMASHER_3V3": {
                this.smasher3v3 = value.getAsInt();
                return true;
            }
            case "SMASHED3V3": 
            case "SMASHED_3V3": {
                this.smashed3v3 = value.getAsInt();
                return true;
            }
            case "WINS3V3": 
            case "WINS_3V3": {
                this.wins3v3 = value.getAsInt();
                return true;
            }
            case "ASSISTS3V3": 
            case "ASSISTS_3V3": {
                this.assists3v3 = value.getAsInt();
                return true;
            }
            case "WIN_STREAK_3V3": 
            case "WIN_STREAK3V3": 
            case "WINSTREAK3V3": 
            case "WINSTREAK_3V3": {
                this.winStreak3v3 = value.getAsInt();
                return true;
            }
            case "DEATHS": {
                this.deaths = value.getAsInt();
                return true;
            }
            case "GAMES": {
                this.games = value.getAsInt();
                return true;
            }
            case "LOSSES": {
                this.losses = value.getAsInt();
                return true;
            }
            case "KILLS": {
                this.kills = value.getAsInt();
                return true;
            }
            case "DAMAGE_DEALT": {
                this.damageDealt = value.getAsInt();
                return true;
            }
            case "SMASHER": {
                this.smasher = value.getAsInt();
                return true;
            }
            case "SMASHED": {
                this.smashed = value.getAsInt();
                return true;
            }
            case "WINS": {
                this.wins = value.getAsInt();
                return true;
            }
            case "ASSISTS": {
                this.assists = value.getAsInt();
                return true;
            }
            case "WIN_STREAK": {
                this.winStreak = value.getAsInt();
                return true;
            }
        }
        return false;
    }

    private void runMoveStatsInitialisation(String move, JsonObject moveJson) {
        SmashAbility smashAbility = this.getMoveByName(move);
        if (smashAbility == null) {
            return;
        }
        block48: for (Map.Entry e : moveJson.entrySet()) {
            String key;
            JsonElement value = (JsonElement)e.getValue();
            switch (key = ((String)e.getKey()).toUpperCase()) {
                case "SMASHER_TEAMS": {
                    this.OWNsmasherTeams.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "SMASHER_NORMAL": {
                    this.OWNsmasherNormal.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "SMASHER_2V2": {
                    this.OWNsmasher2v2.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "SMASHER_3V3": 
                case "SMASHER3V3": {
                    this.OWNsmasher3v3.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "SMASHER": {
                    this.OWNsmasher.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "KILLS_TEAMS": {
                    this.OWNKillsTeams.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "KILLS_NORMAL": {
                    this.OWNkillsNormal.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "KILLS_2V2": {
                    this.OWNKills2v2.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "KILLS_3V3": 
                case "KILLS3V3": {
                    this.OWNkills3v3.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "KILLS": {
                    this.OWNkills.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "DAMAGE_DEALT_TEAMS": {
                    this.OWNdamagedealtTeams.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "DAMAGE_DEALT_NORMAL": {
                    this.OWNdamagedealtNormal.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "DAMAGE_DEALT_2V2": {
                    this.OWNdamagedealt2v2.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "DAMAGE_DEALT_3V3": 
                case "DAMAGE_DEALT3V3": {
                    this.OWNdamagedealt3v3.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "DAMAGE_DEALT": {
                    this.OWNdamagedealt.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "SMASHED_TEAMS": {
                    this.smashedByMoveteam.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "SMASHED_NORMAL": {
                    this.smashedByMovenormal.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "SMASHED_2V2": {
                    this.smashedByMove2v2.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "SMASHED_3V3": 
                case "SMASHED3V3": {
                    this.smashedByMove3v3.put(smashAbility, value.getAsInt());
                    continue block48;
                }
                case "SMASHED": {
                    this.smashedByMove.put(smashAbility, value.getAsInt());
                    continue block48;
                }
            }
            Logger.logWarn("[PlayerAPI.SmashHeroes.initializeMove] Unknown value: " + key + " in Hero: " + this.hero.getDisplayName() + " and Move: " + move);
        }
    }

    private SmashAbility getMoveByName(String move) {
        if (move.equals("MELEE")) {
            return new SmashAbility("MELEE", "Melee", "Hitting your opponent by left-click", new String[0]);
        }
        for (String string : HERO.mapping) {
            HERO hero = HERO.valueOf(string);
            if (hero.getQuickMove().getAPIName().equals(move)) {
                return hero.getQuickMove();
            }
            if (hero.getChargeMove().getAPIName().equals(move)) {
                return hero.getChargeMove();
            }
            if (hero.getSmashMove().getAPIName().equals(move)) {
                return hero.getSmashMove();
            }
            if (!hero.getPassive().getAPIName().equals(move)) continue;
            return hero.getPassive();
        }
        if (move.equals("SHIELD")) {
            return HERO.SERGEANT_SHIELD.getQuickMove();
        }
        if (move.equals("ARROW_STORM")) {
            return HERO.GREEN_HOOD.getSmashMove();
        }
        if (move.equals("SANIC_BOOM")) {
            return HERO.SANIC.getChargeMove();
        }
        if (move.equals("SPIN_DASH")) {
            return HERO.SANIC.getQuickMove();
        }
        if (move.equals("BOUNCE")) {
            return HERO.PUG.getPassive();
        }
        if (move.equals("ANGRY_CUB")) {
            return HERO.PUG.getSmashMove();
        }
        Logger.logError("[PlayerAPI.SmashHeroes.getMove] Could not find move: " + move);
        return null;
    }

    private boolean hasMove(String move) {
        return this.hero.getQuickMove().getAPIName().equals(move) || this.hero.getChargeMove().getAPIName().equals(move) || this.hero.getPassive().getAPIName().equals(move) || this.hero.getSmashMove().getAPIName().equals(move);
    }

    public int getLevel() {
        return this.level;
    }

    public int getExp() {
        return this.exp;
    }

    public int getPrestigeLevel() {
        return this.prestigeLevel;
    }

    public boolean isHasClassUnlocked() {
        return this.hasClassUnlocked;
    }

    public boolean isHasMasterSkinUnlocked() {
        return this.hasMasterSkinUnlocked;
    }

    public HERO getHero() {
        return this.hero;
    }

    public HashMap<SmashAbility, Integer> getSmashedByMove() {
        return this.smashedByMove;
    }

    public HashMap<SmashAbility, Integer> getSmashedByMoveteam() {
        return this.smashedByMoveteam;
    }

    public HashMap<SmashAbility, Integer> getSmashedByMovenormal() {
        return this.smashedByMovenormal;
    }

    public HashMap<SmashAbility, Integer> getSmashedByMove2v2() {
        return this.smashedByMove2v2;
    }

    public HashMap<SmashAbility, Integer> getOWNKills2v2() {
        return this.OWNKills2v2;
    }

    public HashMap<SmashAbility, Integer> getOWNkills() {
        return this.OWNkills;
    }

    public HashMap<SmashAbility, Integer> getOWNkillsNormal() {
        return this.OWNkillsNormal;
    }

    public HashMap<SmashAbility, Integer> getOWNKillsTeams() {
        return this.OWNKillsTeams;
    }

    public HashMap<SmashAbility, Integer> getOWNdamagedealt() {
        return this.OWNdamagedealt;
    }

    public HashMap<SmashAbility, Integer> getOWNdamagedealtTeams() {
        return this.OWNdamagedealtTeams;
    }

    public HashMap<SmashAbility, Integer> getOWNdamagedealtNormal() {
        return this.OWNdamagedealtNormal;
    }

    public HashMap<SmashAbility, Integer> getOWNdamagedealt2v2() {
        return this.OWNdamagedealt2v2;
    }

    public HashMap<SmashAbility, Integer> getOWNsmasher() {
        return this.OWNsmasher;
    }

    public HashMap<SmashAbility, Integer> getOWNsmasherNormal() {
        return this.OWNsmasherNormal;
    }

    public HashMap<SmashAbility, Integer> getOWNsmasherTeams() {
        return this.OWNsmasherTeams;
    }

    public HashMap<SmashAbility, Integer> getOWNsmasher2v2() {
        return this.OWNsmasher2v2;
    }

    public int getDeathsNormal() {
        return this.deathsNormal;
    }

    public int getGamesNormal() {
        return this.gamesNormal;
    }

    public int getDamageDealtNormal() {
        return this.damageDealtNormal;
    }

    public int getLossesNormal() {
        return this.lossesNormal;
    }

    public int getKillsNormal() {
        return this.killsNormal;
    }

    public int getWinsNormal() {
        return this.winsNormal;
    }

    public int getSmasherNormal() {
        return this.smasherNormal;
    }

    public int getSmashedNormal() {
        return this.smashedNormal;
    }

    public int getAssistsNormal() {
        return this.assistsNormal;
    }

    public int getDeathsTeams() {
        return this.deathsTeams;
    }

    public int getGamesTeams() {
        return this.gamesTeams;
    }

    public int getDamageDealtTeams() {
        return this.damageDealtTeams;
    }

    public int getLossesTeams() {
        return this.lossesTeams;
    }

    public int getKillsTeams() {
        return this.killsTeams;
    }

    public int getWinsTeams() {
        return this.winsTeams;
    }

    public int getSmasherTeams() {
        return this.smasherTeams;
    }

    public int getSmashedTeams() {
        return this.smashedTeams;
    }

    public int getAssistsTeams() {
        return this.assistsTeams;
    }

    public int getDeathsFriends() {
        return this.deathsFriends;
    }

    public int getGamesFriends() {
        return this.gamesFriends;
    }

    public int getDamageDealtFriends() {
        return this.damageDealtFriends;
    }

    public int getLossesFriends() {
        return this.lossesFriends;
    }

    public int getKillsFriends() {
        return this.killsFriends;
    }

    public int getWinsFriends() {
        return this.winsFriends;
    }

    public int getSmasherFriends() {
        return this.smasherFriends;
    }

    public int getSmashedFriends() {
        return this.smashedFriends;
    }

    public int getAssistsFriends() {
        return this.assistsFriends;
    }

    public int getDeaths2v2() {
        return this.deaths2v2;
    }

    public int getGames2v2() {
        return this.games2v2;
    }

    public int getDamageDealt2v2() {
        return this.damageDealt2v2;
    }

    public int getLosses2v2() {
        return this.losses2v2;
    }

    public int getKills2v2() {
        return this.kills2v2;
    }

    public int getWins2v2() {
        return this.wins2v2;
    }

    public int getSmasher2v2() {
        return this.smasher2v2;
    }

    public int getSmashed2v2() {
        return this.smashed2v2;
    }

    public int getAssists2v2() {
        return this.assists2v2;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public int getGames() {
        return this.games;
    }

    public int getDamageDealt() {
        return this.damageDealt;
    }

    public int getLosses() {
        return this.losses;
    }

    public int getKills() {
        return this.kills;
    }

    public int getWins() {
        return this.wins;
    }

    public int getSmasher() {
        return this.smasher;
    }

    public int getSmashed() {
        return this.smashed;
    }

    public int getAssists() {
        return this.assists;
    }
}

