/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util.hypixelapi.playerstats;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skyerzz.hypixellib.Logger;
import com.skyerzz.hypixellib.OutDated;
import com.skyerzz.hypixellib.util.games.paintball.HAT;
import com.skyerzz.hypixellib.util.games.paintball.KILLSTREAK;
import com.skyerzz.hypixellib.util.games.paintball.PERK;
import com.skyerzz.hypixellib.util.hypixelapi.playerstats.PlayerGameStats;
import java.util.HashMap;
import java.util.Map;

public class PlayerPaintballStats
extends PlayerGameStats {
    private int coins;
    private int kills;
    private int deaths;
    private int wins;
    private int shots;
    private int killstreaks;
    @OutDated
    private int teamDeaths;
    private int fortuneLevel;
    private int enduranceLevel;
    private int godfatherLevel;
    private int superluckLevel;
    private int adrenalineLevel;
    private int transfusionLevel;
    private int headstartLevel;
    private int forcefieldTime;
    private int weekly_kills_b;
    private int weekly_kills_a;
    private int monthly_kills_b;
    private int monthly_kills_a;
    private HAT selectedHat;
    private HashMap<String, HAT> unlockedHats = new HashMap();
    private HashMap<String, KILLSTREAK> unlockedKillstreaks = new HashMap();
    private HashMap<String, PERK> unlockedPerks = new HashMap();
    @OutDated
    private int votes_Juice;
    @OutDated
    private int votes_Babyland;
    @OutDated
    private int votes_Victorian;
    @OutDated
    private int votes_Courtyard;
    @OutDated
    private int votes_Outback;
    @OutDated
    private int votes_Herobrine;
    @OutDated
    private int votes_Octagon;
    @OutDated
    private int votes_OhCanada;
    @OutDated
    private int votes_Egypt;
    @OutDated
    private int votes_Market;
    @OutDated
    private boolean achievement_flag_1;
    @OutDated
    private boolean instantRespawn;

    public PlayerPaintballStats(JsonObject json) {
        super(json);
        this.initialize();
    }

    private void initialize() {
        for (Map.Entry e : this.json.entrySet()) {
            String key = ((String)e.getKey()).toUpperCase();
            if (this.setValue(key, (JsonElement)e.getValue()) || this.setSpecialValue(key, (JsonElement)e.getValue())) continue;
            Logger.logWarn("[PlayerAPI.Paintball.initialize] Unknown value: " + key);
        }
    }

    private boolean setValue(String key, JsonElement value) {
        switch (key) {
            case "COINS": {
                this.coins = value.getAsInt();
                break;
            }
            case "DEATHS": {
                this.deaths = value.getAsInt();
                break;
            }
            case "DEATHS_TEAMS": {
                this.teamDeaths = value.getAsInt();
                break;
            }
            case "ENDURANCE": {
                this.enduranceLevel = value.getAsInt();
                break;
            }
            case "ADRENALINE": {
                this.adrenalineLevel = value.getAsInt();
                break;
            }
            case "FORTUNE": {
                this.fortuneLevel = value.getAsInt();
                break;
            }
            case "GODFATHER": {
                this.godfatherLevel = value.getAsInt();
                break;
            }
            case "HEADSTART": {
                this.headstartLevel = value.getAsInt();
                break;
            }
            case "KILLS": {
                this.kills = value.getAsInt();
                break;
            }
            case "KILLSTREAKS": {
                this.killstreaks = value.getAsInt();
                break;
            }
            case "SHOTS_FIRED": {
                this.shots = value.getAsInt();
                break;
            }
            case "SUPERLUCK": {
                this.superluckLevel = value.getAsInt();
                break;
            }
            case "TRANSFUSION": {
                this.transfusionLevel = value.getAsInt();
                break;
            }
            case "WINS": {
                this.wins = value.getAsInt();
                break;
            }
            case "WEEKLY_KILLS_B": {
                this.weekly_kills_b = value.getAsInt();
                break;
            }
            case "WEEKLY_KILLS_A": {
                this.weekly_kills_a = value.getAsInt();
                break;
            }
            case "MONTHLY_KILLS_A": {
                this.monthly_kills_a = value.getAsInt();
                break;
            }
            case "MONTHLY_KILLS_B": {
                this.monthly_kills_b = value.getAsInt();
                break;
            }
            case "FORCEFIELDTIME": {
                this.forcefieldTime = value.getAsInt();
                break;
            }
            case "SHOTS": {
                break;
            }
            case "HAT": {
                if (HAT.mapping.contains(value.getAsString().toUpperCase())) {
                    this.selectedHat = HAT.valueOf(value.getAsString().toUpperCase());
                    break;
                }
                Logger.logWarn("[HypixelAPI.Paintball.Hat] Unsupported Value: " + value.getAsString().toUpperCase());
                break;
            }
            case "INSTANT_RESPAWN": {
                this.instantRespawn = value.getAsBoolean();
                return true;
            }
            case "VOTES_JUICE": {
                this.votes_Juice = value.getAsInt();
                break;
            }
            case "VOTES_BABYLAND": {
                this.votes_Babyland = value.getAsInt();
                return true;
            }
            case "VOTES_VICTORIAN": {
                this.votes_Victorian = value.getAsInt();
                return true;
            }
            case "VOTES_COURTYARD": {
                this.votes_Courtyard = value.getAsInt();
                return true;
            }
            case "VOTES_OUTBACK": {
                this.votes_Outback = value.getAsInt();
                return true;
            }
            case "VOTES_HEROBRINE": {
                this.votes_Herobrine = value.getAsInt();
                return true;
            }
            case "VOTES_OCTAGON": {
                this.votes_Octagon = value.getAsInt();
                return true;
            }
            case "VOTES_OH CANADA!": {
                this.votes_OhCanada = value.getAsInt();
                return true;
            }
            case "VOTES_EGYPT": {
                this.votes_Egypt = value.getAsInt();
                return true;
            }
            case "VOTES_MARKET": {
                this.votes_Market = value.getAsInt();
                return true;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean setSpecialValue(String key, JsonElement value) {
        switch (key) {
            case "PACKAGES": {
                this.setPackageValues(value.getAsJsonArray());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void setPackageValues(JsonArray array) {
        for (JsonElement element : array) {
            String value = element.getAsString().toUpperCase();
            if (PERK.mapping.contains(value)) {
                PERK item = PERK.valueOf(value);
                this.unlockedPerks.put(value, item);
                return;
            }
            if (HAT.mapping.contains(value)) {
                HAT item = HAT.valueOf(value);
                this.unlockedHats.put(value, item);
                return;
            }
            if (KILLSTREAK.mapping.contains(value)) {
                KILLSTREAK item = KILLSTREAK.valueOf(value);
                this.unlockedKillstreaks.put(value, item);
                return;
            }
            if (value.equals("ACHIEVEMENT_FLAG_1")) {
                this.achievement_flag_1 = true;
                return;
            }
            Logger.logWarn("[PlayerAPI.Paintball.package] Unknown value: " + value);
        }
    }

    public int getCoins() {
        return this.coins;
    }

    public int getKills() {
        return this.kills;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public int getWins() {
        return this.wins;
    }

    public int getShots() {
        return this.shots;
    }

    public int getKillstreaks() {
        return this.killstreaks;
    }

    public int getFortuneLevel() {
        if (this.fortuneLevel == 0) {
            return 0;
        }
        return this.fortuneLevel + 1;
    }

    public int getEnduranceLevel() {
        if (this.enduranceLevel == 0) {
            return 0;
        }
        return this.enduranceLevel + 1;
    }

    public int getGodfatherLevel() {
        if (this.godfatherLevel == 0) {
            return 0;
        }
        return this.godfatherLevel + 1;
    }

    public int getSuperluckLevel() {
        if (this.superluckLevel == 0) {
            return 0;
        }
        return this.superluckLevel + 1;
    }

    public int getAdrenalineLevel() {
        if (this.adrenalineLevel == 0) {
            return 0;
        }
        return this.adrenalineLevel + 1;
    }

    public int getTransfusionLevel() {
        if (this.transfusionLevel == 0) {
            return 0;
        }
        return this.transfusionLevel + 1;
    }

    public int getHeadstartLevel() {
        if (this.headstartLevel == 0) {
            return 0;
        }
        return this.headstartLevel;
    }

    public int getTeamDeaths() {
        return this.teamDeaths;
    }

    public int getForcefieldTime() {
        return this.forcefieldTime;
    }

    @OutDated
    public int getWeekly_kills_b() {
        return this.weekly_kills_b;
    }

    @OutDated
    public int getWeekly_kills_a() {
        return this.weekly_kills_a;
    }

    @OutDated
    public int getMonthly_kills_b() {
        return this.monthly_kills_b;
    }

    @OutDated
    public int getMonthly_kills_a() {
        return this.monthly_kills_a;
    }

    public HAT getSelectedHat() {
        return this.selectedHat;
    }

    public HashMap<String, HAT> getUnlockedHats() {
        return this.unlockedHats;
    }

    public HashMap<String, KILLSTREAK> getUnlockedKillstreaks() {
        return this.unlockedKillstreaks;
    }

    public HashMap<String, PERK> getUnlockedPerks() {
        return this.unlockedPerks;
    }

    @OutDated
    public int getVotes_Juice() {
        return this.votes_Juice;
    }

    @OutDated
    public int getVotes_Babyland() {
        return this.votes_Babyland;
    }

    @OutDated
    public int getVotes_Victorian() {
        return this.votes_Victorian;
    }

    @OutDated
    public int getVotes_Courtyard() {
        return this.votes_Courtyard;
    }

    @OutDated
    public int getVotes_Outback() {
        return this.votes_Outback;
    }

    @OutDated
    public int getVotes_Herobrine() {
        return this.votes_Herobrine;
    }

    @OutDated
    public int getVotes_Octagon() {
        return this.votes_Octagon;
    }

    @OutDated
    public int getVotes_Market() {
        return this.votes_Market;
    }

    @OutDated
    public int getVotes_Egypt() {
        return this.votes_Egypt;
    }

    @OutDated
    public int getVotes_OhCanada() {
        return this.votes_OhCanada;
    }

    @OutDated
    public boolean isAchievement_flag_1() {
        return this.achievement_flag_1;
    }

    @OutDated
    public boolean isInstantRespawn() {
        return this.instantRespawn;
    }
}

