/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util.hypixelapi.playerstats;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skyerzz.hypixellib.Logger;
import com.skyerzz.hypixellib.OutDated;
import com.skyerzz.hypixellib.util.games.smashheroes.HERO;
import com.skyerzz.hypixellib.util.games.smashheroes.MAP;
import com.skyerzz.hypixellib.util.games.smashheroes.SmashClass;
import com.skyerzz.hypixellib.util.hypixelapi.playerstats.PlayerGameStats;
import java.util.HashMap;
import java.util.Map;

public class PlayerSmashStats
extends PlayerGameStats {
    private int smashLevel;
    private int damageDealt;
    private int coins;
    private int deathsNormal;
    private int gamesNormal;
    private int lossesNormal;
    private int killsNormal;
    private int damageDealtNormal;
    private int smasherNormal;
    private int smashedNormal;
    private int winsNormal;
    private int assistsNormal;
    private int deathsTeams;
    private int gamesTeams;
    private int lossesTeams;
    private int killsTeams;
    private int damageDealtTeams;
    private int smasherTeams;
    private int smashedTeams;
    private int winsTeams;
    private int assistsTeams;
    private int deaths2v2;
    private int games2v2;
    private int losses2v2;
    private int kills2v2;
    private int damageDealt2v2;
    private int smasher2v2;
    private int smashed2v2;
    private int wins2v2;
    private int assists2v2;
    private int deathsFriends;
    private int gamesFriends;
    private int lossesFriends;
    private int killsFriends;
    private int damageDealtFriends;
    private int smasherFriends;
    private int smashedFriends;
    private int winsFriends;
    private int assistsFriends;
    private int firstFriendsGame;
    private int gamesDayFriends;
    private int losses;
    private int quits;
    private int kills;
    private int deaths;
    private int games;
    private int smashed;
    private int smasher;
    private int wins;
    private int assists;
    private int expBooster10Uses;
    private int expBooster30Uses;
    private int expBooster50Uses;
    private int expBooster100Uses;
    private boolean combatTracker;
    private HERO activeHero;
    private SmashClass bulk = new SmashClass(HERO.THE_BULK);
    private SmashClass generalCluck = new SmashClass(HERO.GENERAL_CLUCK);
    private SmashClass cakeMonster = new SmashClass(HERO.CAKE_MONSTER);
    private SmashClass botmon = new SmashClass(HERO.BOTMUN);
    private SmashClass tinman = new SmashClass(HERO.TINMAN);
    private SmashClass marauder = new SmashClass(HERO.MARAUDER);
    private SmashClass spooderman = new SmashClass(HERO.SPODERMAN);
    private SmashClass pug = new SmashClass(HERO.PUG);
    private SmashClass cryomancer = new SmashClass(HERO.FROSTY);
    private SmashClass sgtShield = new SmashClass(HERO.SERGEANT_SHIELD);
    private SmashClass karakot = new SmashClass(HERO.GOKU);
    private SmashClass skullfire = new SmashClass(HERO.SKULLFIRE);
    private SmashClass sanic = new SmashClass(HERO.SANIC);
    private SmashClass voidCrawler = new SmashClass(HERO.DUSK_CRAWLER);
    private SmashClass shoop = new SmashClass(HERO.SHOOP_DA_WHOOP);
    private SmashClass greenHood = new SmashClass(HERO.GREEN_HOOD);
    private int winStreak;
    private boolean expiredBooster;
    @OutDated
    private int losses_weekly_b;
    @OutDated
    private int losses_monthly_b;
    @OutDated
    private int games_monthly_b;
    @OutDated
    private int kills_monthly_b;
    @OutDated
    private int games_weekly_b;
    @OutDated
    private int kills_weekly_b;
    @OutDated
    private int wins_weekly_b;
    @OutDated
    private int wins_monthly_b;
    private int losses_weekly_a;
    private int losses_monthly_a;
    private int games_monthly_a;
    private int kills_monthly_a;
    private int games_weekly_a;
    private int kills_weekly_a;
    private int wins_weekly_a;
    private int wins_monthly_a;
    private HashMap<MAP, Integer> mapVotes = new HashMap();
    private SmashClass shaun = new SmashClass(HERO.SHAUN_SHEEP);
    private int deaths3v3;
    private int games3v3;
    private int losses3v3;
    private int kills3v3;
    private int damageDealt3v3;
    private int smasher3v3;
    private int smashed3v3;
    private int wins3v3;
    private int assists3v3;

    public PlayerSmashStats(JsonObject json) {
        super(json);
        this.initialize();
    }

    private void initialize() {
        for (Map.Entry e : this.json.entrySet()) {
            String key = ((String)e.getKey()).toUpperCase().trim();
            if (this.setValue(key, (JsonElement)e.getValue()) || this.setSpecialValue(key, (JsonElement)e.getValue())) continue;
            Logger.logWarn("[PlayerAPI.SmashHeroes.initialize] Unknown value: " + key);
        }
    }

    private boolean setValue(String key, JsonElement value) {
        if (key.contains("FRIEND") && key.contains("NORMAL")) {
            return true;
        }
        switch (key) {
            case "LOSSES_WEEKLY_B": {
                this.losses_weekly_b = value.getAsInt();
                return true;
            }
            case "LOSSES_MONTHLY_B": {
                this.losses_monthly_b = value.getAsInt();
                return true;
            }
            case "GAMES_MONTHLY_B": {
                this.games_monthly_b = value.getAsInt();
                return true;
            }
            case "KILLS_MONTHLY_B": {
                this.kills_monthly_b = value.getAsInt();
                return true;
            }
            case "GAMES_WEEKLY_B": {
                this.games_weekly_b = value.getAsInt();
                return true;
            }
            case "KILLS_WEEKLY_B": {
                this.kills_weekly_b = value.getAsInt();
                return true;
            }
            case "LOSSES_WEEKLY_A": {
                this.losses_weekly_a = value.getAsInt();
                return true;
            }
            case "LOSSES_MONTHLY_A": {
                this.losses_monthly_a = value.getAsInt();
                return true;
            }
            case "GAMES_MONTHLY_A": {
                this.games_monthly_a = value.getAsInt();
                return true;
            }
            case "KILLS_MONTHLY_A": {
                this.kills_monthly_a = value.getAsInt();
                return true;
            }
            case "GAMES_WEEKLY_A": {
                this.games_weekly_a = value.getAsInt();
                return true;
            }
            case "KILLS_WEEKLY_A": {
                this.kills_weekly_a = value.getAsInt();
                return true;
            }
            case "WINS_WEEKLY_B": {
                this.wins_weekly_b = value.getAsInt();
                return true;
            }
            case "WINS_WEEKLY_A": {
                this.wins_weekly_a = value.getAsInt();
                return true;
            }
            case "WINS_MONTHLY_A": {
                this.wins_monthly_a = value.getAsInt();
                return true;
            }
            case "WINS_MONTHLY_B": {
                this.wins_monthly_b = value.getAsInt();
                return true;
            }
            case "EXPIRED_BOOSTER": {
                this.expiredBooster = value.getAsBoolean();
                return true;
            }
            case "FRIENDS_FIRSTGAME": {
                this.firstFriendsGame = value.getAsInt();
                return true;
            }
            case "FRIENDS_GAMESDAY": {
                this.gamesDayFriends = value.getAsInt();
                return true;
            }
            case "COMBATTRACKER": {
                this.combatTracker = value.getAsBoolean();
                return true;
            }
            case "SMASHED": {
                this.smashed = value.getAsInt();
                return true;
            }
            case "SMASHER": {
                this.smasher = value.getAsInt();
                return true;
            }
            case "WINS": {
                this.wins = value.getAsInt();
                return true;
            }
            case "ASSISTS": {
                this.assists = value.getAsInt();
                return true;
            }
            case "SMASHLEVEL": 
            case "SMASH_LEVEL_TOTAL": {
                this.smashLevel = value.getAsInt();
                return true;
            }
            case "WIN_STREAK": {
                this.winStreak = value.getAsInt();
                return true;
            }
            case "DAMAGE_DEALT": {
                this.damageDealt = value.getAsInt();
                return true;
            }
            case "COINS": {
                this.coins = value.getAsInt();
                return true;
            }
            case "LOSSES": {
                this.losses = value.getAsInt();
                return true;
            }
            case "QUITS": {
                this.quits = value.getAsInt();
                return true;
            }
            case "KILLS": {
                this.kills = value.getAsInt();
                return true;
            }
            case "DEATHS": {
                this.deaths = value.getAsInt();
                return true;
            }
            case "GAMES": {
                this.games = value.getAsInt();
                return true;
            }
            case "EXPBOOSTER_PURCHASES_10_PLAYS": {
                this.expBooster10Uses = value.getAsInt();
                return true;
            }
            case "EXPBOOSTER_PURCHASES_30_PLAYS": {
                this.expBooster30Uses = value.getAsInt();
                return true;
            }
            case "EXPBOOSTER_PURCHASES_50_PLAYS": {
                this.expBooster50Uses = value.getAsInt();
                return true;
            }
            case "EXPBOOSTER_PURCHASES_100_PLAYS": {
                this.expBooster100Uses = value.getAsInt();
                return true;
            }
            case "DEATHS_NORMAL": {
                this.deathsNormal = value.getAsInt();
                return true;
            }
            case "GAMES_NORMAL": {
                this.gamesNormal = value.getAsInt();
                return true;
            }
            case "LOSSES_NORMAL": {
                this.lossesNormal = value.getAsInt();
                return true;
            }
            case "KILLS_NORMAL": {
                this.killsNormal = value.getAsInt();
                return true;
            }
            case "DAMAGE_DEALT_NORMAL": {
                this.damageDealtNormal = value.getAsInt();
                return true;
            }
            case "SMASHER_NORMAL": {
                this.smasherNormal = value.getAsInt();
                return true;
            }
            case "SMASHED_NORMAL": {
                this.smashedNormal = value.getAsInt();
                return true;
            }
            case "WINS_NORMAL": {
                this.winsNormal = value.getAsInt();
                return true;
            }
            case "ASSISTS_NORMAL": {
                this.assistsNormal = value.getAsInt();
                return true;
            }
            case "DEATHS_TEAMS": {
                this.deathsTeams = value.getAsInt();
                return true;
            }
            case "GAMES_TEAMS": {
                this.gamesTeams = value.getAsInt();
                return true;
            }
            case "LOSSES_TEAMS": {
                this.lossesTeams = value.getAsInt();
                return true;
            }
            case "KILLS_TEAMS": {
                this.killsTeams = value.getAsInt();
                return true;
            }
            case "DAMAGE_DEALT_TEAMS": {
                this.damageDealtTeams = value.getAsInt();
                return true;
            }
            case "SMASHER_TEAMS": {
                this.smasherTeams = value.getAsInt();
                return true;
            }
            case "SMASHED_TEAMS": {
                this.smashedTeams = value.getAsInt();
                return true;
            }
            case "WINS_TEAMS": {
                this.winsTeams = value.getAsInt();
                return true;
            }
            case "ASSISTS_TEAMS": {
                this.assistsTeams = value.getAsInt();
                return true;
            }
            case "FRIEND_DEATHS": {
                this.deathsFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_GAMES": {
                this.gamesFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_LOSSES": {
                this.lossesFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_KILLS": {
                this.killsFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_DAMAGE_DEALT": {
                this.damageDealtFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_SMASHER": {
                this.smasherFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_SMASHED": {
                this.smashedFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_WINS": {
                this.winsFriends = value.getAsInt();
                return true;
            }
            case "FRIEND_ASSISTS": {
                this.assistsFriends = value.getAsInt();
                return true;
            }
            case "DEATHS_2V2": {
                this.deaths2v2 = value.getAsInt();
                return true;
            }
            case "GAMES_2V2": {
                this.games2v2 = value.getAsInt();
                return true;
            }
            case "LOSSES_2V2": {
                this.losses2v2 = value.getAsInt();
                return true;
            }
            case "KILLS_2V2": {
                this.kills2v2 = value.getAsInt();
                return true;
            }
            case "DAMAGE_DEALT_2V2": {
                this.damageDealt2v2 = value.getAsInt();
                return true;
            }
            case "SMASHER_2V2": {
                this.smasher2v2 = value.getAsInt();
                return true;
            }
            case "SMASHED_2V2": {
                this.smashed2v2 = value.getAsInt();
                return true;
            }
            case "WINS_2V2": {
                this.wins2v2 = value.getAsInt();
                return true;
            }
            case "ASSISTS_2V2": {
                this.assists2v2 = value.getAsInt();
                return true;
            }
            case "DEATHS_3V3": 
            case "DEATHS3V3": {
                this.deaths3v3 = value.getAsInt();
                return true;
            }
            case "GAMES3V3": 
            case "GAMES_3V3": {
                this.games3v3 = value.getAsInt();
                return true;
            }
            case "LOSSES3V3": 
            case "LOSSES_3V3": {
                this.losses3v3 = value.getAsInt();
                return true;
            }
            case "KILLS3V3": 
            case "KILLS_3V3": {
                this.kills3v3 = value.getAsInt();
                return true;
            }
            case "DAMAGE_DEALT3V3": 
            case "DAMAGE_DEALT_3V3": {
                this.damageDealt3v3 = value.getAsInt();
                return true;
            }
            case "SMASHER3V3": 
            case "SMASHER_3V3": {
                this.smasher3v3 = value.getAsInt();
                return true;
            }
            case "SMASHED3V3": 
            case "SMASHED_3V3": {
                this.smashed3v3 = value.getAsInt();
                return true;
            }
            case "WINS3V3": 
            case "WINS_3V3": {
                this.wins3v3 = value.getAsInt();
                return true;
            }
            case "ASSISTS3V3": 
            case "ASSISTS_3V3": {
                this.assists3v3 = value.getAsInt();
                return true;
            }
        }
        return false;
    }

    private boolean setSpecialValue(String key, JsonElement value) {
        SmashClass smash;
        switch (key) {
            case "CLASSES": {
                this.setClasses(value.getAsJsonObject());
                return true;
            }
            case "CLASS_STATS": {
                this.setClassStats(value.getAsJsonObject());
                return true;
            }
            case "PACKAGES": {
                this.initPackages(value.getAsJsonArray());
                return true;
            }
            case "ACTIVE_CLASS": {
                if (HERO.mapping.contains(value.getAsString().toUpperCase())) {
                    this.activeHero = HERO.valueOf(value.getAsString().toUpperCase());
                    return true;
                }
                Logger.logWarn("[PlayerAPI.SmashHeroes.activeClass] Unknown value: " + value.getAsString().toUpperCase());
                return true;
            }
        }
        if (key.contains("XP_")) {
            smash = this.getClass(key.replace("XP_", ""));
            smash.setExp(value.getAsInt());
            return true;
        }
        if (key.contains("LASTLEVEL_")) {
            smash = this.getClass(key.replace("LASTLEVEL_", ""));
            smash.setLevel(value.getAsInt());
            return true;
        }
        if (key.contains("PG_")) {
            smash = this.getClass(key.replace("PG_", ""));
            smash.setPrestigeLevel(value.getAsInt());
            return true;
        }
        if (key.contains("MASTERARMOR_")) {
            smash = this.getClass(key.replace("MASTERARMOR_", ""));
            smash.setHasMasterSkinUnlocked(value.getAsBoolean());
            return true;
        }
        if (key.contains("VOTES_")) {
            String map = key.replace("VOTES_", "").replace(" ", "_");
            if (!MAP.mapping.contains(map)) {
                Logger.logWarn("[PlayerAPI.SmashHeroes.votes] Unknown map value: " + key);
                return true;
            }
            this.mapVotes.put(MAP.valueOf(map), value.getAsInt());
            return true;
        }
        return false;
    }

    private void setClassStats(JsonObject json) {
        for (Map.Entry e : json.entrySet()) {
            String key = ((String)e.getKey()).toUpperCase().trim();
            if (!HERO.mapping.contains(key)) {
                Logger.logWarn("[PlayerAPI.SmashHeroes.classStats] Unknown class: " + key);
                continue;
            }
            HERO hero = HERO.valueOf(key);
            SmashClass smash = this.getClass(hero);
            smash.setClassJson(((JsonElement)e.getValue()).getAsJsonObject());
        }
    }

    private void setClasses(JsonObject json) {
        for (Map.Entry e : json.entrySet()) {
            String key = ((String)e.getKey()).toUpperCase().trim();
            if (!HERO.mapping.contains(key)) {
                Logger.logWarn("[PlayerAPI.SmashHeroes.classes] Unknown value: " + key);
                continue;
            }
            HERO hero = HERO.valueOf(key);
            SmashClass smash = this.getClass(hero);
            smash.setHasClassUnlocked(((JsonElement)e.getValue()).getAsBoolean());
        }
    }

    private void initPackages(JsonArray array) {
        for (JsonElement value : array) {
            switch (value.getAsString().toUpperCase().trim()) {
                default: 
            }
            Logger.logWarn("[PlayerAPI.SmashHeroes.Packages] Unknown value: " + value);
        }
    }

    public SmashClass getClass(String hero) {
        if (HERO.mapping.contains(hero)) {
            return this.getClass(HERO.valueOf(hero));
        }
        Logger.logWarn("[PlayerAPI.SmashHeroes.getClass] Unknown class: " + hero);
        return null;
    }

    public SmashClass getClass(HERO hero) {
        switch (hero) {
            case THE_BULK: {
                return this.bulk;
            }
            case GENERAL_CLUCK: {
                return this.generalCluck;
            }
            case CAKE_MONSTER: {
                return this.cakeMonster;
            }
            case BOTMUN: {
                return this.botmon;
            }
            case TINMAN: {
                return this.tinman;
            }
            case MARAUDER: {
                return this.marauder;
            }
            case SPODERMAN: {
                return this.spooderman;
            }
            case PUG: {
                return this.pug;
            }
            case FROSTY: {
                return this.cryomancer;
            }
            case SERGEANT_SHIELD: {
                return this.sgtShield;
            }
            case GOKU: {
                return this.karakot;
            }
            case SKULLFIRE: {
                return this.skullfire;
            }
            case SANIC: {
                return this.sanic;
            }
            case DUSK_CRAWLER: {
                return this.voidCrawler;
            }
            case SHOOP_DA_WHOOP: {
                return this.shoop;
            }
            case GREEN_HOOD: {
                return this.greenHood;
            }
            case SHAUN_SHEEP: {
                return this.shaun;
            }
        }
        Logger.logError("[PlayerAPI.SmashHeroes.getClass] Unknown Class: " + (Object)((Object)hero) + " | " + hero.getDisplayName());
        return null;
    }
}

