/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util.hypixelapi.playerstats;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skyerzz.hypixellib.Logger;
import com.skyerzz.hypixellib.OutDated;
import com.skyerzz.hypixellib.util.games.tntgames.DEATHEFFECT;
import com.skyerzz.hypixellib.util.games.tntgames.HAT;
import com.skyerzz.hypixellib.util.games.tntgames.PARTICLEEFFECT;
import com.skyerzz.hypixellib.util.games.tntgames.WIZARD;
import com.skyerzz.hypixellib.util.hypixelapi.playerstats.PlayerGameStats;
import java.util.ArrayList;
import java.util.Map;

public class PlayerTNTGamesStats
extends PlayerGameStats {
    private int coins;
    private int winStreak;
    private int bowspleef_deaths;
    private int bowspleef_wins;
    private int bowspleef_shots;
    private int wizards_deaths;
    private int wizards_kills;
    private int wizards_wins;
    private int wizards_assists;
    private int tag_wins;
    private int tag_kills;
    private int run_wins;
    private int runDeaths;
    private int run_record;
    private int pvprun_wins;
    private int pvprun_kills;
    private int pvprun_record;
    private int run_doubleJump;
    private boolean speed_potion;
    private boolean slow_potion;
    private int bowspleef_doubleJump;
    private int bowspleef_tripleShot;
    private int bowspleef_repulsor;
    private int wizards_fire_explode;
    private int wizards_fire_regen;
    private int wizards_kinetic_explode;
    private int wizards_kinetic_regen;
    private int wizards_ice_explode;
    private int wizards_ice_regen;
    private int wizards_wither_explode;
    private int wizards_wither_regen;
    private int wizards_blood_explode;
    private int wizards_blood_regen;
    private int tag_speedy;
    private DEATHEFFECT selectedDeathEffect;
    private PARTICLEEFFECT selectedParticleEffect;
    private HAT selectedHat;
    private WIZARD selectedWizard;
    private ArrayList<HAT> unlockedHats = new ArrayList();
    private ArrayList<DEATHEFFECT> unlockedDeathEffects = new ArrayList();
    private ArrayList<PARTICLEEFFECT> unlockedParticleEffects = new ArrayList();
    @OutDated
    private int votes_Quadral;
    @OutDated
    private int votes_ForgottenPlanet;
    @OutDated
    private int votes_Atior;
    @OutDated
    private int votes_Node;
    @OutDated
    private int votes_TallGate;
    @OutDated
    private int votes_GreenBelt;
    @OutDated
    private int votes_TwinSpire;
    @OutDated
    private int votes_TheVale;
    @OutDated
    private int votes_Totum;
    @OutDated
    private int votes_FireFall;
    @OutDated
    private int votes_Blossom;
    @OutDated
    private int votes_Gladius;
    @OutDated
    private int votes_Crucible;
    @OutDated
    private int votes_Heather;
    @OutDated
    private int votes_Downvault;
    @OutDated
    private int votes_DreadPit;
    @OutDated
    private int votes_IceFortress;
    @OutDated
    private int votes_Tombed;
    @OutDated
    private int votes_BowSpleefC;
    @OutDated
    private int votes_Biosphere;
    @OutDated
    private int votes_Crystalline;
    @OutDated
    private int votes_bloom;
    @OutDated
    private int votes_Mars;
    @OutDated
    private int votes_Hypogeal;
    @OutDated
    private int deaths;
    @OutDated
    private int kills;
    @OutDated
    private int bombermanKills;
    @OutDated
    private int bombermanDeaths;
    private boolean tiered_achievement_flag_1;

    public PlayerTNTGamesStats(JsonObject json) {
        super(json);
        this.initialize();
    }

    private void initialize() {
        for (Map.Entry e : this.json.entrySet()) {
            String key = ((String)e.getKey()).toUpperCase();
            if (this.setValue(key, (JsonElement)e.getValue()) || this.setSpecialValue(key, (JsonElement)e.getValue())) continue;
            Logger.logWarn("[PlayerAPI.TNTGames.initialize] Unknown value: " + key);
        }
    }

    private boolean setValue(String key, JsonElement element) {
        switch (key) {
            case "FIREWIZARD_EXPLODE": {
                return true;
            }
            case "NEW_FIREWIZARD_EXPLODE": {
                this.wizards_fire_explode = element.getAsInt();
                return true;
            }
            case "FIREWIZARD_REGEN": {
                return true;
            }
            case "NEW_FIREWIZARD_REGEN": {
                this.wizards_fire_regen = element.getAsInt();
                return true;
            }
            case "KINETICWIZARD_EXPLODE": {
                return true;
            }
            case "NEW_KINETICWIZARD_EXPLODE": {
                this.wizards_kinetic_explode = element.getAsInt();
                return true;
            }
            case "KINETICWIZARD_REGEN": {
                return true;
            }
            case "NEW_KINETICWIZARD_REGEN": {
                this.wizards_kinetic_regen = element.getAsInt();
                return true;
            }
            case "ICEWIZARD_EXPLODE": {
                return true;
            }
            case "NEW_ICEWIZARD_EXPLODE": {
                this.wizards_ice_explode = element.getAsInt();
                return true;
            }
            case "ICEWIZARD_REGEN": {
                return true;
            }
            case "NEW_ICEWIZARD_REGEN": {
                this.wizards_ice_regen = element.getAsInt();
                return true;
            }
            case "WITHERWIZARD_EXPLODE": {
                return true;
            }
            case "NEW_WITHERWIZARD_EXPLODE": {
                this.wizards_wither_explode = element.getAsInt();
                return true;
            }
            case "WITHERWIZARD_REGEN": {
                return true;
            }
            case "NEW_WITHERWIZARD_REGEN": {
                this.wizards_wither_regen = element.getAsInt();
                return true;
            }
            case "BLOODWIZARD_EXPLODE": {
                return true;
            }
            case "NEW_BLOODWIZARD_EXPLODE": {
                this.wizards_blood_explode = element.getAsInt();
                return true;
            }
            case "BLOODWIZARD_REGEN": {
                return true;
            }
            case "NEW_BLOODWIZARD_REGEN": {
                this.wizards_blood_regen = element.getAsInt();
                return true;
            }
            case "ASSISTS_CAPTURE": {
                this.wizards_assists = element.getAsInt();
                return true;
            }
            case "WINS_CAPTURE": {
                this.wizards_wins = element.getAsInt();
                return true;
            }
            case "DEATHS_CAPTURE": {
                this.wizards_deaths = element.getAsInt();
                return true;
            }
            case "KILLS_CAPTURE": {
                this.wizards_kills = element.getAsInt();
                return true;
            }
            case "TAG_SPEED": {
                return true;
            }
            case "NEW_TAG_SPEEDY": {
                this.tag_speedy = element.getAsInt();
                return true;
            }
            case "KILLS_TNTAG": {
                this.tag_kills = element.getAsInt();
                return true;
            }
            case "WINS_TNTAG": {
                this.tag_wins = element.getAsInt();
                return true;
            }
            case "DEATHS_TNTRUN": {
                this.runDeaths = element.getAsInt();
                return true;
            }
            case "WINS_TNTRUN": {
                this.run_wins = element.getAsInt();
                return true;
            }
            case "RECORD_TNTRUN": {
                this.run_record = element.getAsInt();
                return true;
            }
            case "DOUBLEJUMP_TNTRUN": {
                return true;
            }
            case "NEW_TNTRUN_DOUBLE_JUMPS": {
                this.run_doubleJump = element.getAsInt();
                return true;
            }
            case "KILLS_PVPRUN": {
                this.pvprun_kills = element.getAsInt();
                return true;
            }
            case "WINS_PVPRUN": {
                this.pvprun_wins = element.getAsInt();
                return true;
            }
            case "RECORD_PVPRUN": {
                this.pvprun_record = element.getAsInt();
                return true;
            }
            case "DEATHS_BOWSPLEEF": {
                this.bowspleef_deaths = element.getAsInt();
                return true;
            }
            case "SPLEEF_DOUBLEJUMP": {
                return true;
            }
            case "NEW_SPLEEF_DOUBLE_JUMPS": {
                this.bowspleef_doubleJump = element.getAsInt();
                return true;
            }
            case "SPLEEF_REPULSE": {
                return true;
            }
            case "NEW_SPLEEF_REPULSOR": {
                this.bowspleef_repulsor = element.getAsInt();
                return true;
            }
            case "SPLEEF_TRIPLE": {
                return true;
            }
            case "NEW_SPLEEF_TRIPLESHOT": {
                this.bowspleef_tripleShot = element.getAsInt();
                return true;
            }
            case "TAGS_BOWSPLEEF": {
                this.bowspleef_shots = element.getAsInt();
                return true;
            }
            case "WINS_BOWSPLEEF": {
                this.bowspleef_wins = element.getAsInt();
                return true;
            }
            case "COINS": {
                this.coins = element.getAsInt();
                return true;
            }
            case "WINSTREAK": {
                this.winStreak = element.getAsInt();
                return true;
            }
            case "DEATHS": {
                this.deaths = element.getAsInt();
                return true;
            }
            case "KILLS": {
                this.kills = element.getAsInt();
                return true;
            }
            case "DEATHS_BOMBERMAN": {
                this.bombermanDeaths = element.getAsInt();
                return true;
            }
            case "KILLS_BOMBERMAN": {
                this.bombermanKills = element.getAsInt();
                return true;
            }
            case "VOTES_QUADRAL": {
                this.votes_Quadral = element.getAsInt();
                return true;
            }
            case "VOTES_FORGOTTEN PLANET": {
                this.votes_ForgottenPlanet = element.getAsInt();
                return true;
            }
            case "VOTES_ATIOR": {
                this.votes_Atior = element.getAsInt();
                return true;
            }
            case "VOTES_NODE": {
                this.votes_Node = element.getAsInt();
                return true;
            }
            case "VOTES_TALLGATE": {
                this.votes_TallGate = element.getAsInt();
                return true;
            }
            case "VOTES_GREENBELT": {
                this.votes_GreenBelt = element.getAsInt();
                return true;
            }
            case "VOTES_TWINSPIRE": {
                this.votes_TwinSpire = element.getAsInt();
                return true;
            }
            case "VOTES_THE VALE": {
                this.votes_TheVale = element.getAsInt();
                return true;
            }
            case "VOTES_TOTUM": {
                this.votes_Totum = element.getAsInt();
                return true;
            }
            case "VOTES_FIREFALL": {
                this.votes_FireFall = element.getAsInt();
                return true;
            }
            case "VOTES_BLOSSOM": {
                this.votes_Blossom = element.getAsInt();
                return true;
            }
            case "VOTES_CRUCIBLE": {
                this.votes_Crucible = element.getAsInt();
                return true;
            }
            case "VOTES_GLADIUS": {
                this.votes_Gladius = element.getAsInt();
                return true;
            }
            case "VOTES_HEATHER": {
                this.votes_Heather = element.getAsInt();
                return true;
            }
            case "VOTES_DOWNVAULT": {
                this.votes_Downvault = element.getAsInt();
                return true;
            }
            case "VOTES_DREAD PIT": {
                this.votes_DreadPit = element.getAsInt();
                return true;
            }
            case "VOTES_ICE FORTRESS": {
                this.votes_IceFortress = element.getAsInt();
                return true;
            }
            case "VOTES_TOMBED": {
                this.votes_Tombed = element.getAsInt();
                return true;
            }
            case "VOTES_BOW SPLEEF (C)": {
                this.votes_BowSpleefC = element.getAsInt();
                return true;
            }
            case "VOTES_BIOSPHERE": {
                this.votes_Biosphere = element.getAsInt();
                return true;
            }
            case "VOTES_CRYSTALLINE": {
                this.votes_Crystalline = element.getAsInt();
                return true;
            }
            case "VOTES_BLOOM": {
                this.votes_bloom = element.getAsInt();
                return true;
            }
            case "VOTES_MARS": {
                this.votes_Mars = element.getAsInt();
                return true;
            }
            case "VOTES_HYPOGEAL": {
                this.votes_Hypogeal = element.getAsInt();
                return true;
            }
        }
        return false;
    }

    private boolean setSpecialValue(String key, JsonElement element) {
        switch (key) {
            case "CAPTURE_CLASS": {
                String value = element.getAsString().toUpperCase().replace(" WIZARD", "");
                if (WIZARD.mapping.contains(value)) {
                    this.selectedWizard = WIZARD.valueOf(value);
                } else {
                    Logger.logWarn("[PlayerAPI.TNTGames.CaptureClass] Value not found: " + value);
                }
                return true;
            }
            case "ACTIVE_PARTICLE_EFFECT": {
                String value = element.getAsString().toUpperCase();
                if (PARTICLEEFFECT.mapping.contains(value)) {
                    this.selectedParticleEffect = PARTICLEEFFECT.valueOf(value);
                } else {
                    Logger.logWarn("[PlayerAPI.TNTGames.ParticleEffect] Value not found: " + value);
                }
                return true;
            }
            case "SELECTED_HAT": {
                String value = element.getAsString().toUpperCase();
                if (HAT.mapping.contains(value)) {
                    this.selectedHat = HAT.valueOf(value);
                } else {
                    Logger.logWarn("[PlayerAPI.TNTGames.Hat] Value not found: " + value);
                }
                return true;
            }
            case "ACTIVE_DEATH_EFFECT": {
                String value = element.getAsString().toUpperCase();
                if (DEATHEFFECT.mapping.contains(value)) {
                    this.selectedDeathEffect = DEATHEFFECT.valueOf(value);
                } else {
                    Logger.logWarn("[PlayerAPI.TNTGames.DeathEffect] Value not found: " + value);
                }
                return true;
            }
            case "PACKAGES": {
                this.setPackageValues(element.getAsJsonArray());
                return true;
            }
        }
        return false;
    }

    private void setPackageValues(JsonArray array) {
        for (JsonElement element : array) {
            String value = element.getAsString().toUpperCase();
            if (value.equals("SPEED_POTION")) {
                this.speed_potion = true;
                continue;
            }
            if (value.equals("SLOW_POTION")) {
                this.slow_potion = true;
                continue;
            }
            if (value.equals("TIERED_ACHIEVEMENT_FLAG_1")) {
                this.tiered_achievement_flag_1 = true;
                continue;
            }
            if (PARTICLEEFFECT.mapping.contains(value)) {
                this.unlockedParticleEffects.add(PARTICLEEFFECT.valueOf(value));
                continue;
            }
            if (HAT.mapping.contains(value)) {
                this.unlockedHats.add(HAT.valueOf(value));
                continue;
            }
            if (DEATHEFFECT.mapping.contains(value)) {
                this.unlockedDeathEffects.add(DEATHEFFECT.valueOf(value));
                continue;
            }
            Logger.logWarn("[PlayerAPI.TNTGames.package] Unknown value: " + value);
        }
    }

    public int getCoins() {
        return this.coins;
    }

    public int getBowspleef_deaths() {
        return this.bowspleef_deaths;
    }

    public int getBowspleef_wins() {
        return this.bowspleef_wins;
    }

    public int getBowspleef_shots() {
        return this.bowspleef_shots;
    }

    public int getWizards_deaths() {
        return this.wizards_deaths;
    }

    public int getWizards_kills() {
        return this.wizards_kills;
    }

    public int getWizards_wins() {
        return this.wizards_wins;
    }

    public int getWizards_assists() {
        return this.wizards_assists;
    }

    public int getTag_wins() {
        return this.tag_wins;
    }

    public int getTag_kills() {
        return this.tag_kills;
    }

    public int getRun_wins() {
        return this.run_wins;
    }

    public int getRun_record() {
        return this.run_record;
    }

    public int getPvprun_wins() {
        return this.pvprun_wins;
    }

    public int getPvprun_kills() {
        return this.pvprun_kills;
    }

    public int getPvprun_record() {
        return this.pvprun_record;
    }

    public int getRun_doubleJump() {
        return this.run_doubleJump + 1;
    }

    public int getBowspleef_doubleJump() {
        return this.bowspleef_doubleJump + 1;
    }

    public int getBowspleef_tripleShot() {
        return this.bowspleef_tripleShot + 1;
    }

    public int getBowspleef_repulsor() {
        return this.bowspleef_repulsor + 1;
    }

    public int getWizards_fire_explode() {
        return this.wizards_fire_explode;
    }

    public int getWizards_fire_regen() {
        return this.wizards_fire_regen;
    }

    public int getWizards_kinetic_explode() {
        return this.wizards_kinetic_explode;
    }

    public int getWizards_kinetic_regen() {
        return this.wizards_kinetic_regen;
    }

    public int getWizards_ice_explode() {
        return this.wizards_ice_explode;
    }

    public int getWizards_ice_regen() {
        return this.wizards_ice_regen;
    }

    public int getWizards_wither_explode() {
        return this.wizards_wither_explode;
    }

    public int getWizards_wither_regen() {
        return this.wizards_wither_regen;
    }

    public int getWizards_blood_explode() {
        return this.wizards_blood_explode;
    }

    public int getWizards_blood_regen() {
        return this.wizards_blood_regen;
    }

    public int getTag_speedy() {
        return this.tag_speedy;
    }

    public DEATHEFFECT getSelectedDeathEffect() {
        return this.selectedDeathEffect;
    }

    public PARTICLEEFFECT getSelectedParticleEffect() {
        return this.selectedParticleEffect;
    }

    public HAT getSelectedHat() {
        return this.selectedHat;
    }

    public WIZARD getSelectedWizard() {
        return this.selectedWizard;
    }

    public boolean isSpeed_potion() {
        return this.speed_potion;
    }

    public boolean isSlow_potion() {
        return this.slow_potion;
    }

    public ArrayList<HAT> getUnlockedHats() {
        return this.unlockedHats;
    }

    public ArrayList<DEATHEFFECT> getUnlockedDeathEffects() {
        return this.unlockedDeathEffects;
    }

    @OutDated
    public int getVotes_Quadral() {
        return this.votes_Quadral;
    }

    @OutDated
    public int getVotes_ForgottenPlanet() {
        return this.votes_ForgottenPlanet;
    }

    @OutDated
    public int getVotes_Atior() {
        return this.votes_Atior;
    }

    @OutDated
    public int getVotes_Node() {
        return this.votes_Node;
    }

    @OutDated
    public int getVotes_TallGate() {
        return this.votes_TallGate;
    }

    @OutDated
    public int getVotes_GreenBelt() {
        return this.votes_GreenBelt;
    }

    @OutDated
    public int getVotes_TwinSpire() {
        return this.votes_TwinSpire;
    }

    @OutDated
    public int getVotes_TheVale() {
        return this.votes_TheVale;
    }

    @OutDated
    public int getVotes_Totum() {
        return this.votes_Totum;
    }

    @OutDated
    public int getVotes_FireFall() {
        return this.votes_FireFall;
    }

    @OutDated
    public int getVotes_Blossom() {
        return this.votes_Blossom;
    }

    @OutDated
    public int getVotes_Gladius() {
        return this.votes_Gladius;
    }

    @OutDated
    public int getVotes_Crucible() {
        return this.votes_Crucible;
    }

    @OutDated
    public int getVotes_Heather() {
        return this.votes_Heather;
    }

    @OutDated
    public int getVotes_Downvault() {
        return this.votes_Downvault;
    }

    @OutDated
    public int getVotes_DreadPit() {
        return this.votes_DreadPit;
    }

    @OutDated
    public int getVotes_IceFortress() {
        return this.votes_IceFortress;
    }

    public ArrayList<PARTICLEEFFECT> getUnlockedParticleEffects() {
        return this.unlockedParticleEffects;
    }

    @OutDated
    public int getVotes_Tombed() {
        return this.votes_Tombed;
    }

    @OutDated
    public int getVotes_BowSpleefC() {
        return this.votes_BowSpleefC;
    }

    @OutDated
    public int getVotes_Biosphere() {
        return this.votes_Biosphere;
    }

    @OutDated
    public int getVotes_Crystalline() {
        return this.votes_Crystalline;
    }

    @OutDated
    public int getVotes_bloom() {
        return this.votes_bloom;
    }

    @OutDated
    public int getVotes_Mars() {
        return this.votes_Mars;
    }

    @OutDated
    public int getVotes_Hypogeal() {
        return this.votes_Hypogeal;
    }

    @OutDated
    public int getDeaths() {
        return this.deaths;
    }

    @OutDated
    public int getKills() {
        return this.kills;
    }

    @OutDated
    public int getBombermanKills() {
        return this.bombermanKills;
    }

    @OutDated
    public int getBombermanDeaths() {
        return this.bombermanDeaths;
    }
}

