/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib;

import com.skyerzz.hypixellib.util.hypixelapi.HypixelFriend;
import com.skyerzz.hypixellib.util.hypixelapi.HypixelPlayer;
import com.skyerzz.hypixellib.util.hypixelapi.exception.MalformedAPIKeyException;
import com.skyerzz.hypixellib.util.hypixelapi.exception.NoPlayerStatsException;
import com.skyerzz.hypixellib.util.hypixelapi.exception.PlayerNonExistentException;
import com.skyerzz.hypixellib.util.hypixelapi.exception.RequestTypeException;
import java.io.IOException;
import java.util.ArrayList;

public class AverageFriendLevel {
    private String player;
    public int totalFriendLevel = 0;
    public int friends = 0;
    double high = 0.0;
    public HypixelPlayer highestLevel;

    public AverageFriendLevel(String player) {
        this.player = player;
    }

    public void getAverageFriendLevel() {
        final HypixelPlayer origin = new HypixelPlayer(this.player, "41ca9ce5-314d-4bb1-b571-e01b38b6d855");
        new Thread(new Runnable(){

            @Override
            public void run() {
                int count = 0;
                long lastTime = System.currentTimeMillis();
                System.out.println("Getting & parsing friends");
                ArrayList<HypixelFriend> friend = null;
                try {
                    friend = origin.getPlayerFriends();
                }
                catch (PlayerNonExistentException e) {
                    e.printStackTrace();
                }
                catch (RequestTypeException e) {
                    e.printStackTrace();
                }
                catch (NoPlayerStatsException e) {
                    e.printStackTrace();
                }
                catch (MalformedAPIKeyException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (HypixelFriend f : friend) {
                    HypixelPlayer player = f.getAsHypixelPlayer("41ca9ce5-314d-4bb1-b571-e01b38b6d855");
                    double l = 0.0;
                    try {
                        l = player.getPlayerStats().getCommonStats().getNetworkLevel();
                    }
                    catch (RequestTypeException e) {
                        e.printStackTrace();
                    }
                    catch (PlayerNonExistentException e) {
                        System.out.println("NO PLAYER FOUND");
                    }
                    catch (NoPlayerStatsException e) {
                        System.out.println("NO STATS FOUND");
                    }
                    catch (MalformedAPIKeyException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    AverageFriendLevel.this.totalFriendLevel = (int)((double)AverageFriendLevel.this.totalFriendLevel + l);
                    if (l > AverageFriendLevel.this.high) {
                        AverageFriendLevel.this.high = l;
                        AverageFriendLevel.this.highestLevel = player;
                        System.out.println("Found new HighestLevel! Level: " + l + " UUID: " + f.getFriendUUID());
                    }
                    ++AverageFriendLevel.this.friends;
                    ++count;
                    if (AverageFriendLevel.this.friends % 3 == 0) {
                        System.out.println("Done friends: " + AverageFriendLevel.this.friends);
                        System.out.println("Current ratio: " + AverageFriendLevel.this.totalFriendLevel / AverageFriendLevel.this.friends);
                    }
                    if (count < 100) continue;
                    count = 0;
                    if (System.currentTimeMillis() - lastTime < 60000L) {
                        System.out.println("Done 100, Waiting " + (System.currentTimeMillis() - lastTime));
                        try {
                            Thread.sleep(System.currentTimeMillis() - lastTime);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    lastTime = System.currentTimeMillis();
                }
                System.out.println("Highest lvl: " + AverageFriendLevel.this.high);
                System.out.println("Done " + AverageFriendLevel.this.friends + " friends, total level: " + AverageFriendLevel.this.totalFriendLevel + " ratio: " + AverageFriendLevel.this.totalFriendLevel / AverageFriendLevel.this.friends);
            }
        }).start();
    }
}

