/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util;

public interface ILevel {
    public static final String EXP_FIELD = "networkExp";
    public static final String LVL_FIELD = "networkLevel";
    public static final double BASE = 10000.0;
    public static final double GROWTH = 2500.0;
    public static final double HALF_GROWTH = 1250.0;
    public static final double REVERSE_PQ_PREFIX = -3.5;
    public static final double REVERSE_CONST = 12.25;
    public static final double GROWTH_DIVIDES_2 = 8.0E-4;

    public static double getLevel(double exp) {
        return exp < 0.0 ? 1.0 : Math.floor(-2.5 + Math.sqrt(12.25 + 8.0E-4 * exp));
    }

    public static double getExactLevel(double exp) {
        return ILevel.getLevel(exp) + ILevel.getPercentageToNextLevel(exp);
    }

    public static double getExpFromLevelToNext(double level) {
        return level < 1.0 ? 10000.0 : 2500.0 * (level - 1.0) + 10000.0;
    }

    public static double getTotalExpToLevel(double level) {
        double lv = Math.floor(level);
        double x0 = ILevel.getTotalExpToFullLevel(lv);
        if (level == lv) {
            return x0;
        }
        return (ILevel.getTotalExpToFullLevel(lv + 1.0) - x0) * (level % 1.0) + x0;
    }

    public static double getTotalExpToFullLevel(double level) {
        return (1250.0 * (level - 2.0) + 10000.0) * (level - 1.0);
    }

    public static double getPercentageToNextLevel(double exp) {
        double lv = ILevel.getLevel(exp);
        double x0 = ILevel.getTotalExpToLevel(lv);
        return (exp - x0) / (ILevel.getTotalExpToLevel(lv + 1.0) - x0);
    }
}

