/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util.hypixelapi.playerstats;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skyerzz.hypixellib.Logger;
import com.skyerzz.hypixellib.OutDated;
import com.skyerzz.hypixellib.util.games.walls.ADVCANCEDSTARTER;
import com.skyerzz.hypixellib.util.games.walls.BASICSTARTER;
import com.skyerzz.hypixellib.util.games.walls.PERK;
import com.skyerzz.hypixellib.util.hypixelapi.playerstats.PlayerGameStats;
import java.util.HashMap;
import java.util.Map;

public class PlayerWallsStats
extends PlayerGameStats {
    private boolean blood;
    private int coins;
    private int wins;
    private int deaths;
    private int kills;
    private int losses;
    private HashMap<ADVCANCEDSTARTER, Integer> advancedStarters = new HashMap();
    private HashMap<PERK, Integer> perks = new HashMap();
    private HashMap<BASICSTARTER, Integer> basicStarters = new HashMap();
    @OutDated
    private int monthly_wins_a;
    @OutDated
    private int monthly_wins_b;
    @OutDated
    private int weekly_wins_a;
    @OutDated
    private int weekly_wins_b;
    @OutDated
    private int monthly_kills_a;
    @OutDated
    private int monthly_kills_b;
    @OutDated
    private int weekly_kills_a;
    @OutDated
    private int weekly_kills_b;

    public PlayerWallsStats(JsonObject json) {
        super(json);
    }

    private void initialize() {
        for (Map.Entry e : this.json.entrySet()) {
            String key = ((String)e.getKey()).toUpperCase();
            if (this.setValue(key, (JsonElement)e.getValue()) || this.setSpecialValue(key, (JsonElement)e.getValue())) continue;
            Logger.logWarn("[PlayerAPI.Walls.initialize] Unknown value: " + key);
        }
    }

    private boolean setValue(String key, JsonElement element) {
        switch (key.trim()) {
            case "COINS": {
                this.coins = element.getAsInt();
                return true;
            }
            case "WINS": {
                this.wins = element.getAsInt();
                return true;
            }
            case "LOSSES": {
                this.losses = element.getAsInt();
                return true;
            }
            case "KILLS": {
                this.kills = element.getAsInt();
                return true;
            }
            case "DEATHS": {
                this.deaths = element.getAsInt();
                return true;
            }
            case "WEEKLY_KILLS_A": {
                this.weekly_kills_a = element.getAsInt();
                return true;
            }
            case "WEEKLY_KILLS_B": {
                this.weekly_kills_b = element.getAsInt();
                return true;
            }
            case "MONTHLY_KILLS_A": {
                this.monthly_kills_a = element.getAsInt();
                return true;
            }
            case "MONTHLY_KILLS_B": {
                this.monthly_kills_b = element.getAsInt();
                return true;
            }
            case "WEEKLY_WINS_A": {
                this.weekly_wins_a = element.getAsInt();
                return true;
            }
            case "WEEKLY_WINS_B": {
                this.weekly_wins_b = element.getAsInt();
                return true;
            }
            case "MONTHLY_WINS_A": {
                this.monthly_wins_a = element.getAsInt();
                return true;
            }
            case "MONTHLY_WINS_B": {
                this.monthly_wins_b = element.getAsInt();
                return true;
            }
        }
        return false;
    }

    private boolean setSpecialValue(String key, JsonElement element) {
        if (key.equals("PACKAGES")) {
            this.setPackageValues(element.getAsJsonArray());
            return true;
        }
        if (ADVCANCEDSTARTER.mapping.contains(key)) {
            this.advancedStarters.put(ADVCANCEDSTARTER.valueOf(key), element.getAsInt());
            return true;
        }
        if (BASICSTARTER.mapping.contains(key)) {
            this.basicStarters.put(BASICSTARTER.valueOf(key), element.getAsInt());
            return true;
        }
        if (PERK.mapping.contains(key)) {
            this.perks.put(PERK.valueOf(key), element.getAsInt());
        }
        return false;
    }

    private void setPackageValues(JsonArray array) {
    }

    public boolean isBlood() {
        return this.blood;
    }

    public int getCoins() {
        return this.coins;
    }

    public int getWins() {
        return this.wins;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public int getKills() {
        return this.kills;
    }

    public int getLosses() {
        return this.losses;
    }

    public HashMap<ADVCANCEDSTARTER, Integer> getAdvancedStarters() {
        return this.advancedStarters;
    }

    public HashMap<PERK, Integer> getPerks() {
        return this.perks;
    }

    public HashMap<BASICSTARTER, Integer> getBasicStarters() {
        return this.basicStarters;
    }

    @OutDated
    public int getMonthly_wins_a() {
        return this.monthly_wins_a;
    }

    @OutDated
    public int getMonthly_wins_b() {
        return this.monthly_wins_b;
    }

    @OutDated
    public int getWeekly_wins_a() {
        return this.weekly_wins_a;
    }

    @OutDated
    public int getWeekly_wins_b() {
        return this.weekly_wins_b;
    }

    @OutDated
    public int getMonthly_kills_a() {
        return this.monthly_kills_a;
    }

    @OutDated
    public int getMonthly_kills_b() {
        return this.monthly_kills_b;
    }

    @OutDated
    public int getWeekly_kills_a() {
        return this.weekly_kills_a;
    }

    @OutDated
    public int getWeekly_kills_b() {
        return this.weekly_kills_b;
    }
}

