/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.friendremover;

import com.mojang.realmsclient.gui.ChatFormatting;
import com.skyerzz.friendremover.FriendRemover;
import com.skyerzz.hypixellib.Logger;
import com.skyerzz.hypixellib.util.RANK;
import com.skyerzz.hypixellib.util.hypixelapi.HypixelFriend;
import com.skyerzz.hypixellib.util.hypixelapi.HypixelPlayer;
import com.skyerzz.hypixellib.util.hypixelapi.exception.MalformedAPIKeyException;
import com.skyerzz.hypixellib.util.hypixelapi.exception.NoPlayerStatsException;
import com.skyerzz.hypixellib.util.hypixelapi.exception.PlayerNonExistentException;
import com.skyerzz.hypixellib.util.hypixelapi.exception.RequestTypeException;
import com.skyerzz.hypixellib.util.hypixelapi.playerstats.PlayerCommonStats;
import java.io.IOException;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class RemoveFriends {
    public long systemTimeOnLastHunderdStart = System.currentTimeMillis();
    public int friendsRemoved = 0;
    private int maxLevel;
    private Date maxLastDate;

    public RemoveFriends(int maxLevel, Date maxLastDate) {
        Logger.toggleWarnLogging(false);
        this.maxLevel = maxLevel;
        this.maxLastDate = maxLastDate;
    }

    public void start() {
        if (FriendRemover.APIKEY == null) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(ChatFormatting.RED + "[Friend Remover] Please use \"/api new\" first! We need your API key to remove friends!"));
            return;
        }
        this.startRemovingFriends(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
    }

    public void removeFriend(String name) {
        System.out.println("Removing Friend uuid: " + name + " (#" + this.friendsRemoved + ")");
        Minecraft.func_71410_x().field_71439_g.func_71165_d("/f remove " + name);
        ++this.friendsRemoved;
    }

    public void startRemovingFriends(final String playerName) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int count = 0;
                    long lastTime = System.currentTimeMillis();
                    HypixelPlayer player = new HypixelPlayer(playerName, FriendRemover.APIKEY);
                    for (HypixelFriend p : player.getPlayerFriends()) {
                        Date lastOnlineDate;
                        double level;
                        HypixelPlayer x = p.getAsHypixelPlayer(FriendRemover.APIKEY);
                        PlayerCommonStats c = null;
                        String uuid = p.getOwnUUID();
                        try {
                            c = x.getPlayerStats().getCommonStats();
                        }
                        catch (NoPlayerStatsException e) {
                            Logger.logError("No stats found for player " + uuid);
                            continue;
                        }
                        catch (PlayerNonExistentException e) {
                            Logger.logError("NO PLAYER FOUND?");
                        }
                        System.out.println(c.getNetworkLevel() + " | " + (Object)((Object)c.getRank()));
                        if (c.getRank() == null) {
                            Logger.logError("Rank null for player " + p.getFriendUUID());
                        }
                        if (RemoveFriends.this.shouldBeRemoved(uuid, level = c.getNetworkLevel(), lastOnlineDate = p.getDateAccepted(), c.getRank())) {
                            RemoveFriends.this.removeFriend(uuid);
                        } else {
                            Logger.logError("skipping friend " + uuid + " due to higher network level (" + level + ") than " + RemoveFriends.this.maxLevel + " or earlier friend date (" + lastOnlineDate.getTime() + ") than " + RemoveFriends.this.maxLastDate.getTime());
                            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("skipping friend " + uuid + " due to higher network level (" + level + ") than " + RemoveFriends.this.maxLevel + " or earlier friend date (" + lastOnlineDate.getTime() + ") than " + RemoveFriends.this.maxLastDate.getTime()));
                        }
                        if (++count < 100) continue;
                        count = 0;
                        if (System.currentTimeMillis() - lastTime < 60000L) {
                            Logger.logInfo("Done 100, Waiting " + (System.currentTimeMillis() - lastTime));
                            try {
                                Thread.sleep(System.currentTimeMillis() - lastTime);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        lastTime = System.currentTimeMillis();
                    }
                }
                catch (PlayerNonExistentException e) {
                    e.printStackTrace();
                }
                catch (RequestTypeException e) {
                    e.printStackTrace();
                }
                catch (NoPlayerStatsException e) {
                    e.printStackTrace();
                }
                catch (MalformedAPIKeyException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private boolean shouldBeRemoved(String uuid, double level, Date lastOnline, RANK rank) {
        return level < (double)this.maxLevel && lastOnline.after(this.maxLastDate);
    }
}

