/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util.games.copsandcrims;

import com.skyerzz.hypixellib.util.CURRENCY;
import com.skyerzz.hypixellib.util.games.copsandcrims.GUNSKIN;

public class Gun {
    private int damageIncrease = 0;
    private int recoilReduction = 0;
    private int reloadReduction = 0;
    private int costReduction = 0;
    private int targetAquire = 0;
    private GUNTYPE gunType;
    private GUNSKIN selectedSkin;
    private boolean ammoClip;

    public Gun(GUNTYPE guntype, GUNSKIN selectedSkin, boolean ammoClip, int firstPerk, int secondPerk, int thirdPerk, int fourthPerk) throws IncompatibleGunSkinException {
        this.gunType = guntype;
        this.selectedSkin = selectedSkin;
        if (selectedSkin.getGunType() != guntype) {
            throw new IncompatibleGunSkinException(selectedSkin, guntype);
        }
        this.ammoClip = ammoClip;
        this.damageIncrease = firstPerk;
        this.reloadReduction = thirdPerk;
        this.costReduction = fourthPerk;
        if (guntype == GUNTYPE.SNIPER) {
            this.targetAquire = secondPerk;
        } else {
            this.recoilReduction = secondPerk;
        }
    }

    public int getDamageIncrease() {
        return this.damageIncrease;
    }

    public int getRecoilReduction() throws IncompatbileGunPerkException {
        if (this.gunType == GUNTYPE.SNIPER) {
            throw new IncompatbileGunPerkException();
        }
        return this.recoilReduction;
    }

    public int getReloadReduction() {
        return this.reloadReduction;
    }

    public int getCostReduction() throws IncompatbileGunPerkException {
        if (this.gunType == GUNTYPE.PISTOL) {
            throw new IncompatbileGunPerkException();
        }
        return this.costReduction;
    }

    public int getTargetAquire() throws IncompatbileGunPerkException {
        if (this.gunType != GUNTYPE.SNIPER) {
            throw new IncompatbileGunPerkException();
        }
        return this.targetAquire;
    }

    public GUNTYPE getGunType() {
        return this.gunType;
    }

    public GUNSKIN getSelectedSkin() {
        return this.selectedSkin;
    }

    public boolean isAmmoClip() {
        return this.ammoClip;
    }

    public int getCost(int level) {
        double multiplier = this.gunType.getCostMultiplier();
        switch (level) {
            case 1: {
                return (int)(50.0 * multiplier);
            }
            case 2: {
                return (int)(100.0 * multiplier);
            }
            case 3: {
                return (int)(250.0 * multiplier);
            }
            case 4: {
                return (int)(625.0 * multiplier);
            }
            case 5: {
                return (int)(1550.0 * multiplier);
            }
            case 6: {
                return (int)(4000.0 * multiplier);
            }
            case 7: {
                return (int)(10000.0 * multiplier);
            }
            case 8: {
                return (int)(25000.0 * multiplier);
            }
            case 9: {
                return (int)(90000.0 * multiplier);
            }
        }
        return 0;
    }

    public int getAmmoClipCost() {
        return (int)(25000.0 * this.gunType.getCostMultiplier());
    }

    public CURRENCY getCurrencyType() {
        return CURRENCY.COINS;
    }

    public static enum GUNTYPE {
        PISTOL(1.0),
        MAGNUM(1.5),
        SMG(2.0),
        CARBINE(2.0),
        RIFLE(2.0),
        SHOTGUN(2.0),
        SNIPER(2.0);

        private double costMultiplier;

        private GUNTYPE(double costMultiplier) {
            this.costMultiplier = costMultiplier;
        }

        public double getCostMultiplier() {
            return this.costMultiplier;
        }
    }

    private class IncompatbileGunPerkException
    extends Exception {
        private IncompatbileGunPerkException() {
        }
    }

    private class IncompatibleGunSkinException
    extends Exception {
        private GUNSKIN gunskin;
        private GUNTYPE guntype;

        public IncompatibleGunSkinException(GUNSKIN gunskin, GUNTYPE guntype) {
            this.gunskin = gunskin;
            this.guntype = guntype;
        }

        private GUNTYPE getGuntype() {
            return this.guntype;
        }

        private GUNSKIN getGunskin() {
            return this.gunskin;
        }
    }
}

