/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util.hypixelapi.playerstats;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.skyerzz.hypixellib.Logger;
import com.skyerzz.hypixellib.OutDated;
import com.skyerzz.hypixellib.util.games.turbokartracers.HELMET;
import com.skyerzz.hypixellib.util.games.turbokartracers.HORN;
import com.skyerzz.hypixellib.util.games.turbokartracers.JACKET;
import com.skyerzz.hypixellib.util.games.turbokartracers.KARTSKIN;
import com.skyerzz.hypixellib.util.games.turbokartracers.Kart;
import com.skyerzz.hypixellib.util.games.turbokartracers.KartPart;
import com.skyerzz.hypixellib.util.games.turbokartracers.PANTS;
import com.skyerzz.hypixellib.util.games.turbokartracers.PARTICLETRAIL;
import com.skyerzz.hypixellib.util.games.turbokartracers.SHOES;
import com.skyerzz.hypixellib.util.hypixelapi.playerstats.PlayerGameStats;
import java.util.ArrayList;
import java.util.Map;

public class PlayerTurboKartRacersStats
extends PlayerGameStats {
    private int coins;
    private int wins;
    private int boxPickups;
    private int coinPickups;
    private int bananaHitsSent;
    private int bananaHitsReceived;
    private int blueTorpedoHits;
    private int lapsCompleted;
    private int goldTrophies;
    private int silverTrophies;
    private int bronzeTrophies;
    @OutDated
    private int goldTrophiesWeekly_b;
    @OutDated
    private int goldTrophiesWeekly_a;
    @OutDated
    private int goldTrophiesMonthly_b;
    @OutDated
    private int goldTrophiesMonthly_a;
    private int goldTrophiesOlympus;
    private int goldTrophiesJungleRush;
    private int goldTrophiesHypixelGP;
    private int goldTrophiesRetro;
    private int goldTrophiesCanyon;
    @OutDated
    private int silverTrophiesWeekly_b;
    @OutDated
    private int silverTrophiesWeekly_a;
    @OutDated
    private int silverTrophiesMonthly_b;
    @OutDated
    private int silverTrophiesMonthly_a;
    private int silverTrophiesOlympus;
    private int silverTrophiesJungleRush;
    private int silverTrophiesHypixelGP;
    private int silverTrophiesRetro;
    private int silverTrophiesCanyon;
    @OutDated
    private int bronzeTrophiesWeekly_b;
    @OutDated
    private int bronzeTrophiesWeekly_a;
    @OutDated
    private int bronzeTrophiesMonthly_b;
    @OutDated
    private int bronzeTrophiesMonthly_a;
    private int bronzeTrophiesOlympus;
    private int bronzeTrophiesJungleRush;
    private int bronzeTrophiesHypixelGP;
    private int bronzeTrophiesRetro;
    private int bronzeTrophiesCanyon;
    @OutDated
    private int boxPickupsWeekly_b;
    @OutDated
    private int boxPickupsWeekly_a;
    @OutDated
    private int boxPickupsMonthly_b;
    @OutDated
    private int boxPickupsMonthly_a;
    private int boxPickupsOlympus;
    private int boxPickupsJungleRush;
    private int boxPickupsHypixelGP;
    private int boxPickupsRetro;
    private int boxPickupsCanyon;
    private int olympusPlays;
    private int junglerushPlays;
    private int hypixelGPPlays;
    private int retroPlays;
    private int canyonPlays;
    private ArrayList<HELMET> unlockedHelmets = new ArrayList();
    private ArrayList<KARTSKIN> unlockedKartSkins = new ArrayList();
    private ArrayList<PANTS> unlockedPants = new ArrayList();
    private ArrayList<JACKET> unlockedJackets = new ArrayList();
    private ArrayList<SHOES> unlockedShoes = new ArrayList();
    private ArrayList<HORN> unlockedHorns = new ArrayList();
    private ArrayList<PARTICLETRAIL> unlockedParticleTrails = new ArrayList();
    private ArrayList<KartPart> unlockedKartParts = new ArrayList();
    private HELMET selectedHelmet;
    private PANTS selectedPants;
    private JACKET selectedJacket;
    private SHOES selectedShoes;
    private Kart selectedKart;
    private boolean canyonMuted;
    private boolean endgameMuted;
    private boolean lobbyMuted;
    private boolean hypixelGPMuted;
    private boolean jungleRushMuted;
    private boolean retroMuted;
    private boolean olympusMuted;

    public PlayerTurboKartRacersStats(JsonObject json) {
        super(json);
        this.initialize();
    }

    private void initialize() {
        for (Map.Entry e : this.json.entrySet()) {
            String key = ((String)e.getKey()).toUpperCase();
            if (this.setValue(key, (JsonElement)e.getValue()) || this.setSpecialValue(key, (JsonElement)e.getValue())) continue;
            Logger.logWarn("[PlayerAPI.TurboKartRacers.initialize] Unknown value: " + key);
        }
    }

    private boolean setValue(String key, JsonElement value) {
        switch (key) {
            case "COINS": {
                this.coins = value.getAsInt();
                return true;
            }
            case "BOX_PICKUPS": {
                this.boxPickups = value.getAsInt();
                return true;
            }
            case "BANANA_HITS_SENT": {
                this.bananaHitsSent = value.getAsInt();
                return true;
            }
            case "BANANA_HITS_RECEIVED": {
                this.bananaHitsReceived = value.getAsInt();
                return true;
            }
            case "LAPS_COMPLETED": {
                this.lapsCompleted = value.getAsInt();
                return true;
            }
            case "COINS_PICKED_UP": {
                this.coinPickups = value.getAsInt();
                return true;
            }
            case "BLUE_TORPEDO_HIT": {
                this.blueTorpedoHits = value.getAsInt();
                return true;
            }
            case "GOLD_TROPHY": {
                this.goldTrophies = value.getAsInt();
                return true;
            }
            case "SILVER_TROPHY": {
                this.silverTrophies = value.getAsInt();
                return true;
            }
            case "BRONZE_TROPHY": {
                this.bronzeTrophies = value.getAsInt();
                return true;
            }
            case "WINS": {
                this.wins = value.getAsInt();
                return true;
            }
            case "OLYMPUS_PLAYS": {
                this.olympusPlays = value.getAsInt();
                return true;
            }
            case "JUNGLERUSH_PLAYS": {
                this.junglerushPlays = value.getAsInt();
                return true;
            }
            case "HYPIXELGP_PLAYS": {
                this.hypixelGPPlays = value.getAsInt();
                return true;
            }
            case "RETRO_PLAYS": {
                this.retroPlays = value.getAsInt();
                return true;
            }
            case "CANYON_PLAYS": {
                this.canyonPlays = value.getAsInt();
                return true;
            }
            case "GOLD_TROPHY_OLYMPUS": {
                this.goldTrophiesOlympus = value.getAsInt();
                return true;
            }
            case "GOLD_TROPHY_JUNGLERUSH": {
                this.goldTrophiesJungleRush = value.getAsInt();
                return true;
            }
            case "GOLD_TROPHY_HYPIXELGP": {
                this.goldTrophiesHypixelGP = value.getAsInt();
                return true;
            }
            case "GOLD_TROPHY_RETRO": {
                this.goldTrophiesRetro = value.getAsInt();
                return true;
            }
            case "GOLD_TROPHY_CANYON": {
                this.goldTrophiesCanyon = value.getAsInt();
                return true;
            }
            case "GOLD_TROPHY_WEEKLY_A": {
                this.goldTrophiesWeekly_a = value.getAsInt();
                return true;
            }
            case "GOLD_TROPHY_WEEKLY_B": {
                this.goldTrophiesWeekly_b = value.getAsInt();
                return true;
            }
            case "GOLD_TROPHY_MONTHLY_A": {
                this.goldTrophiesMonthly_a = value.getAsInt();
                return true;
            }
            case "GOLD_TROPHY_MONTHLY_B": {
                this.goldTrophiesMonthly_b = value.getAsInt();
                return true;
            }
            case "SILVER_TROPHY_OLYMPUS": {
                this.silverTrophiesOlympus = value.getAsInt();
                return true;
            }
            case "SILVER_TROPHY_JUNGLERUSH": {
                this.silverTrophiesJungleRush = value.getAsInt();
                return true;
            }
            case "SILVER_TROPHY_HYPIXELGP": {
                this.silverTrophiesHypixelGP = value.getAsInt();
                return true;
            }
            case "SILVER_TROPHY_RETRO": {
                this.silverTrophiesRetro = value.getAsInt();
                return true;
            }
            case "SILVER_TROPHY_CANYON": {
                this.silverTrophiesCanyon = value.getAsInt();
                return true;
            }
            case "SILVER_TROPHY_WEEKLY_A": {
                this.silverTrophiesWeekly_a = value.getAsInt();
                return true;
            }
            case "SILVER_TROPHY_WEEKLY_B": {
                this.silverTrophiesWeekly_b = value.getAsInt();
                return true;
            }
            case "SILVER_TROPHY_MONTHLY_A": {
                this.silverTrophiesMonthly_a = value.getAsInt();
                return true;
            }
            case "SILVER_TROPHY_MONTHLY_B": {
                this.silverTrophiesMonthly_b = value.getAsInt();
                return true;
            }
            case "BRONZE_TROPHY_OLYMPUS": {
                this.bronzeTrophiesOlympus = value.getAsInt();
                return true;
            }
            case "BRONZE_TROPHY_JUNGLERUSH": {
                this.bronzeTrophiesJungleRush = value.getAsInt();
                return true;
            }
            case "BRONZE_TROPHY_HYPIXELGP": {
                this.bronzeTrophiesHypixelGP = value.getAsInt();
                return true;
            }
            case "BRONZE_TROPHY_RETRO": {
                this.bronzeTrophiesRetro = value.getAsInt();
                return true;
            }
            case "BRONZE_TROPHY_CANYON": {
                this.bronzeTrophiesCanyon = value.getAsInt();
                return true;
            }
            case "BRONZE_TROPHY_WEEKLY_A": {
                this.bronzeTrophiesWeekly_a = value.getAsInt();
                return true;
            }
            case "BRONZE_TROPHY_WEEKLY_B": {
                this.bronzeTrophiesWeekly_b = value.getAsInt();
                return true;
            }
            case "BRONZE_TROPHY_MONTHLY_A": {
                this.bronzeTrophiesMonthly_a = value.getAsInt();
                return true;
            }
            case "BRONZE_TROPHY_MONTHLY_B": {
                this.bronzeTrophiesMonthly_b = value.getAsInt();
                return true;
            }
            case "BOX_PICKUPS_OLYMPUS": {
                this.boxPickupsOlympus = value.getAsInt();
                return true;
            }
            case "BOX_PICKUPS_JUNGLERUSH": {
                this.boxPickupsJungleRush = value.getAsInt();
                return true;
            }
            case "BOX_PICKUPS_HYPIXELGP": {
                this.boxPickupsHypixelGP = value.getAsInt();
                return true;
            }
            case "BOX_PICKUPS_RETRO": {
                this.boxPickupsRetro = value.getAsInt();
                return true;
            }
            case "BOX_PICKUPS_CANYON": {
                this.boxPickupsCanyon = value.getAsInt();
                return true;
            }
            case "BOX_PICKUPS_WEEKLY_A": {
                this.boxPickupsWeekly_a = value.getAsInt();
                return true;
            }
            case "BOX_PICKUPS_WEEKLY_B": {
                this.boxPickupsWeekly_b = value.getAsInt();
                return true;
            }
            case "BOX_PICKUPS_MONTHLY_A": {
                this.boxPickupsMonthly_a = value.getAsInt();
                return true;
            }
            case "BOX_PICKUPS_MONTHLY_B": {
                this.boxPickupsMonthly_b = value.getAsInt();
                return true;
            }
        }
        return false;
    }

    private boolean setSpecialValue(String key, JsonElement value) {
        switch (key) {
            case "SKIN_ACTIVE": 
            case "FRAME_ACTIVE": 
            case "ENGINE_ACTIVE": 
            case "BOOSTER_ACTIVE": 
            case "HORN": 
            case "PARTICLE_TRAIL": {
                if (this.selectedKart != null) {
                    this.setActiveKart();
                }
                return true;
            }
            case "HELMET_ACTIVE": 
            case "JACKET_ACTIVE": 
            case "PANTS_ACTIVE": 
            case "SHOES_ACTIVE": {
                this.setActiveSuitPart(key, value.getAsString().replaceAll(":[A-Z]+", ""));
                return true;
            }
            case "PACKAGES": {
                this.initPackages(value.getAsJsonArray());
                return true;
            }
            case "PARTS": {
                this.initParts(value.getAsString());
                return true;
            }
        }
        return false;
    }

    private void initParts(String object) {
        String jsonString = "[" + object.replace(";", ",") + "]";
        JsonArray array = new JsonParser().parse(jsonString).getAsJsonArray();
        for (JsonElement element : array) {
            this.unlockedKartParts.add(KartPart.getKartPartByJson(element.getAsJsonObject().get("GingerbreadPart").getAsJsonObject()));
        }
    }

    private void initPackages(JsonArray array) {
        for (JsonElement element : array) {
            String s = element.getAsString().replace("_unlocked", "").toUpperCase();
            if (HELMET.mapping.contains(s)) {
                this.unlockedHelmets.add(HELMET.valueOf(s));
                continue;
            }
            if (HORN.mapping.contains(s)) {
                this.unlockedHorns.add(HORN.valueOf(s));
                continue;
            }
            if (JACKET.mapping.contains(s)) {
                this.unlockedJackets.add(JACKET.valueOf(s));
                continue;
            }
            if (KARTSKIN.mapping.contains(s)) {
                this.unlockedKartSkins.add(KARTSKIN.valueOf(s));
                continue;
            }
            if (PANTS.mapping.contains(s)) {
                this.unlockedPants.add(PANTS.valueOf(s));
                continue;
            }
            if (PARTICLETRAIL.mapping.contains(s)) {
                this.unlockedParticleTrails.add(PARTICLETRAIL.valueOf(s));
                continue;
            }
            if (SHOES.mapping.contains(s)) {
                this.unlockedShoes.add(SHOES.valueOf(s));
                continue;
            }
            if (s.contains("_MUTED")) {
                this.muteTrack(s.replace("_MUTED", ""));
                continue;
            }
            Logger.logWarn("[PlayerAPI.TurboKartRacers.initPackages] Unknown value: " + s);
        }
    }

    private void muteTrack(String track) {
        switch (track) {
            case "CANYON": {
                this.canyonMuted = true;
                break;
            }
            case "ENDGAME": {
                this.endgameMuted = true;
                break;
            }
            case "LOBBY": {
                this.lobbyMuted = true;
                break;
            }
            case "HYPIXEL_GP": {
                this.hypixelGPMuted = true;
                break;
            }
            case "JUNGLE_RUSH": {
                this.jungleRushMuted = true;
                break;
            }
            case "RETRO": {
                this.retroMuted = true;
                break;
            }
            case "OLYMPUS": {
                this.olympusMuted = true;
            }
        }
    }

    private void setActiveKart() {
        String temp = this.getJsonString("skin_active").toUpperCase();
        KARTSKIN kartSkin = null;
        if (KARTSKIN.mapping.contains(temp)) {
            kartSkin = KARTSKIN.valueOf(temp);
        }
        temp = this.getJsonString("horn").toUpperCase();
        HORN horn = null;
        if (HORN.mapping.contains(temp)) {
            horn = HORN.valueOf(temp);
        }
        temp = this.getJsonString("particle_trail").toUpperCase();
        PARTICLETRAIL trail = null;
        if (PARTICLETRAIL.mapping.contains(temp)) {
            trail = PARTICLETRAIL.valueOf(temp);
        }
        JsonObject tempObject = this.getJsonObject("frame_active").get("GingerbreadPart").getAsJsonObject();
        KartPart frame = KartPart.getKartPartByJson(tempObject);
        tempObject = this.getJsonObject("engine_active").get("GingerbreadPart").getAsJsonObject();
        KartPart engine = KartPart.getKartPartByJson(tempObject);
        tempObject = this.getJsonObject("booster_active").get("GingerbreadPart").getAsJsonObject();
        KartPart booster = KartPart.getKartPartByJson(tempObject);
        this.selectedKart = new Kart(kartSkin, horn, trail, frame, engine, booster);
    }

    private void setActiveSuitPart(String key, String value) {
        if (HELMET.mapping.contains(value)) {
            this.selectedHelmet = HELMET.valueOf(value);
        } else if (PANTS.mapping.contains(value)) {
            this.selectedPants = PANTS.valueOf(value);
        } else if (JACKET.mapping.contains(value)) {
            this.selectedJacket = JACKET.valueOf(value);
        } else if (SHOES.mapping.contains(value)) {
            this.selectedShoes = SHOES.valueOf(value);
        } else {
            Logger.logWarn("[PlayerAPI.TurboKartRacers." + key + "] Unknown value: " + value);
        }
    }

    public int getCoins() {
        return this.coins;
    }

    public int getWins() {
        return this.wins;
    }

    public int getBoxPickups() {
        return this.boxPickups;
    }

    public int getCoinPickups() {
        return this.coinPickups;
    }

    public int getBananaHitsSent() {
        return this.bananaHitsSent;
    }

    public int getBananaHitsReceived() {
        return this.bananaHitsReceived;
    }

    public int getBlueTorpedoHits() {
        return this.blueTorpedoHits;
    }

    public int getLapsCompleted() {
        return this.lapsCompleted;
    }

    public int getGoldTrophies() {
        return this.goldTrophies;
    }

    public int getSilverTrophies() {
        return this.silverTrophies;
    }

    public int getBronzeTrophies() {
        return this.bronzeTrophies;
    }

    @OutDated
    public int getGoldTrophiesWeekly_b() {
        return this.goldTrophiesWeekly_b;
    }

    @OutDated
    public int getGoldTrophiesWeekly_a() {
        return this.goldTrophiesWeekly_a;
    }

    @OutDated
    public int getGoldTrophiesMonthly_b() {
        return this.goldTrophiesMonthly_b;
    }

    @OutDated
    public int getGoldTrophiesMonthly_a() {
        return this.goldTrophiesMonthly_a;
    }

    public int getGoldTrophiesOlympus() {
        return this.goldTrophiesOlympus;
    }

    public int getGoldTrophiesJungleRush() {
        return this.goldTrophiesJungleRush;
    }

    public int getGoldTrophiesHypixelGP() {
        return this.goldTrophiesHypixelGP;
    }

    public int getGoldTrophiesRetro() {
        return this.goldTrophiesRetro;
    }

    public int getGoldTrophiesCanyon() {
        return this.goldTrophiesCanyon;
    }

    @OutDated
    public int getSilverTrophiesWeekly_b() {
        return this.silverTrophiesWeekly_b;
    }

    @OutDated
    public int getSilverTrophiesWeekly_a() {
        return this.silverTrophiesWeekly_a;
    }

    @OutDated
    public int getSilverTrophiesMonthly_b() {
        return this.silverTrophiesMonthly_b;
    }

    @OutDated
    public int getSilverTrophiesMonthly_a() {
        return this.silverTrophiesMonthly_a;
    }

    public int getSilverTrophiesOlympus() {
        return this.silverTrophiesOlympus;
    }

    public int getSilverTrophiesJungleRush() {
        return this.silverTrophiesJungleRush;
    }

    public int getSilverTrophiesHypixelGP() {
        return this.silverTrophiesHypixelGP;
    }

    public int getSilverTrophiesRetro() {
        return this.silverTrophiesRetro;
    }

    public int getSilverTrophiesCanyon() {
        return this.silverTrophiesCanyon;
    }

    @OutDated
    public int getBronzeTrophiesWeekly_b() {
        return this.bronzeTrophiesWeekly_b;
    }

    @OutDated
    public int getBronzeTrophiesWeekly_a() {
        return this.bronzeTrophiesWeekly_a;
    }

    @OutDated
    public int getBronzeTrophiesMonthly_b() {
        return this.bronzeTrophiesMonthly_b;
    }

    @OutDated
    public int getBronzeTrophiesMonthly_a() {
        return this.bronzeTrophiesMonthly_a;
    }

    public int getBronzeTrophiesOlympus() {
        return this.bronzeTrophiesOlympus;
    }

    public int getBronzeTrophiesJungleRush() {
        return this.bronzeTrophiesJungleRush;
    }

    public int getBronzeTrophiesHypixelGP() {
        return this.bronzeTrophiesHypixelGP;
    }

    public int getBronzeTrophiesRetro() {
        return this.bronzeTrophiesRetro;
    }

    public int getBronzeTrophiesCanyon() {
        return this.bronzeTrophiesCanyon;
    }

    @OutDated
    public int getBoxPickupsWeekly_b() {
        return this.boxPickupsWeekly_b;
    }

    @OutDated
    public int getBoxPickupsWeekly_a() {
        return this.boxPickupsWeekly_a;
    }

    @OutDated
    public int getBoxPickupsMonthly_b() {
        return this.boxPickupsMonthly_b;
    }

    @OutDated
    public int getBoxPickupsMonthly_a() {
        return this.boxPickupsMonthly_a;
    }

    public int getBoxPickupsOlympus() {
        return this.boxPickupsOlympus;
    }

    public int getBoxPickupsJungleRush() {
        return this.boxPickupsJungleRush;
    }

    public int getBoxPickupsHypixelGP() {
        return this.boxPickupsHypixelGP;
    }

    public int getBoxPickupsRetro() {
        return this.boxPickupsRetro;
    }

    public int getBoxPickupsCanyon() {
        return this.boxPickupsCanyon;
    }

    public int getOlympusPlays() {
        return this.olympusPlays;
    }

    public int getJunglerushPlays() {
        return this.junglerushPlays;
    }

    public int getHypixelGPPlays() {
        return this.hypixelGPPlays;
    }

    public int getRetroPlays() {
        return this.retroPlays;
    }

    public int getCanyonPlays() {
        return this.canyonPlays;
    }

    public ArrayList<HELMET> getUnlockedHelmets() {
        return this.unlockedHelmets;
    }

    public ArrayList<KARTSKIN> getUnlockedKartSkins() {
        return this.unlockedKartSkins;
    }

    public ArrayList<PANTS> getUnlockedPants() {
        return this.unlockedPants;
    }

    public ArrayList<JACKET> getUnlockedJackets() {
        return this.unlockedJackets;
    }

    public ArrayList<SHOES> getUnlockedShoes() {
        return this.unlockedShoes;
    }

    public ArrayList<HORN> getUnlockedHorns() {
        return this.unlockedHorns;
    }

    public ArrayList<PARTICLETRAIL> getUnlockedParticleTrails() {
        return this.unlockedParticleTrails;
    }

    public ArrayList<KartPart> getUnlockedKartParts() {
        return this.unlockedKartParts;
    }

    public HELMET getSelectedHelmet() {
        return this.selectedHelmet;
    }

    public PANTS getSelectedPants() {
        return this.selectedPants;
    }

    public JACKET getSelectedJacket() {
        return this.selectedJacket;
    }

    public SHOES getSelectedShoes() {
        return this.selectedShoes;
    }

    public Kart getSelectedKart() {
        return this.selectedKart;
    }

    public boolean isCanyonMuted() {
        return this.canyonMuted;
    }

    public boolean isEndgameMuted() {
        return this.endgameMuted;
    }

    public boolean isLobbyMuted() {
        return this.lobbyMuted;
    }

    public boolean isHypixelGPMuted() {
        return this.hypixelGPMuted;
    }

    public boolean isJungleRushMuted() {
        return this.jungleRushMuted;
    }

    public boolean isRetroMuted() {
        return this.retroMuted;
    }

    public boolean isOlympusMuted() {
        return this.olympusMuted;
    }
}

