/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util.games.arcade.miniwalls;

import com.skyerzz.hypixellib.util.items.all.Item;
import com.skyerzz.hypixellib.util.items.all.ItemStack;
import com.skyerzz.hypixellib.util.items.all.Material;
import java.util.ArrayList;

public enum KIT {
    SOLDIER(new ItemStack(new Item(Material.STONE_SWORD)), new ItemStack(new Item(Material.STONE_PICKAXE)), new ItemStack(new Item(Material.WOOD_AXE)), new ItemStack(new Item(Material.WOOL), 10)),
    ARCHER(new ItemStack(new Item(Material.WOOD_SWORD)), new ItemStack(new Item(Material.STONE_PICKAXE)), new ItemStack(new Item(Material.WOOD_AXE)), new ItemStack(new Item(Material.WOOL), 10)),
    BUILDER(new ItemStack(new Item(Material.WOOD_SWORD)), new ItemStack(new Item(Material.IRON_PICKAXE)), new ItemStack(new Item(Material.STONE_AXE)), new ItemStack(new Item(Material.WOOL), 20));

    private ArrayList<ItemStack> kitItems;
    public static final ArrayList<String> mapping;

    private KIT(ItemStack ... stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack s : stack) {
            list.add(s);
        }
        this.kitItems = list;
    }

    private static ArrayList<String> initializeMapping() {
        ArrayList<String> list = new ArrayList<String>();
        for (KIT item : KIT.values()) {
            list.add(item.name());
        }
        return list;
    }

    public ArrayList<ItemStack> getKitItems() {
        return this.kitItems;
    }

    public int getHeartsOnKill() {
        switch (this) {
            case ARCHER: 
            case SOLDIER: {
                return 3;
            }
            case BUILDER: {
                return 4;
            }
        }
        return -1;
    }

    public int getMaxArrowCount() {
        switch (this) {
            case SOLDIER: 
            case BUILDER: {
                return 2;
            }
            case ARCHER: {
                return 4;
            }
        }
        return -1;
    }

    public int getArrowRegenerationSeconds() {
        switch (this) {
            case SOLDIER: 
            case BUILDER: {
                return 8;
            }
            case ARCHER: {
                return 4;
            }
        }
        return -1;
    }

    static {
        mapping = KIT.initializeMapping();
    }
}

