/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util.games.paintball;

import com.skyerzz.hypixellib.util.CURRENCY;
import com.skyerzz.hypixellib.util.RANK;
import java.util.ArrayList;

public enum PERK {
    GODFATHER("Godfather", 5000, 50, RANK.NONE),
    ENDURANCE("Endurance", 7500, 50, RANK.NONE),
    SUPERLUCK("Superluck", 250, 20, RANK.NONE),
    FORTUNE("Fortune", 1000, 20, RANK.NONE),
    ADRENALINE("Adrenaline", 1000, 10, RANK.NONE),
    TRANSFUSION("Transfusion", 100, 10, RANK.NONE),
    HEADSTART("Headstart", 10000, 5, RANK.NONE);

    private String displayName;
    private int maxLevel;
    private int cost;
    private RANK rankRequirement;
    public static final ArrayList<String> mapping;

    private PERK(String displayName, int cost, int maxLevel, RANK rankRequirement) {
        this.displayName = displayName;
        this.maxLevel = maxLevel;
        this.cost = cost;
        this.rankRequirement = rankRequirement;
    }

    private static ArrayList<String> initializeMapping() {
        ArrayList<String> list = new ArrayList<String>();
        for (PERK item : PERK.values()) {
            list.add(item.name());
        }
        return list;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getCost(int level) {
        if (level > this.maxLevel || level < 1) {
            return 0;
        }
        return level * this.cost;
    }

    public CURRENCY getCurrencyType() {
        return CURRENCY.COINS;
    }

    public RANK getRankRequirement() {
        return this.rankRequirement;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    static {
        mapping = PERK.initializeMapping();
    }
}

