/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.hypixellib.util.hypixelapi;

import com.skyerzz.hypixellib.util.hypixelapi.HypixelAPI;
import com.skyerzz.hypixellib.util.hypixelapi.HypixelFriend;
import com.skyerzz.hypixellib.util.hypixelapi.PlayerAPI;
import com.skyerzz.hypixellib.util.hypixelapi.exception.MalformedAPIKeyException;
import com.skyerzz.hypixellib.util.hypixelapi.exception.NoPlayerStatsException;
import com.skyerzz.hypixellib.util.hypixelapi.exception.PlayerNonExistentException;
import com.skyerzz.hypixellib.util.hypixelapi.exception.RequestTypeException;
import java.io.IOException;
import java.util.ArrayList;

public class HypixelPlayer {
    private String uuid;
    private String apiKey;
    private HypixelAPI api = new HypixelAPI();
    private PlayerAPI playerStats;
    private ArrayList<HypixelFriend> playerFriends;

    public HypixelPlayer(String uuid, String APIKey) {
        this.uuid = uuid;
        this.apiKey = APIKey;
    }

    public PlayerAPI getPlayerStats() throws RequestTypeException, PlayerNonExistentException, NoPlayerStatsException, MalformedAPIKeyException, IOException {
        if (this.playerStats == null) {
            this.playerStats = this.api.getPlayerAPI(this.uuid, this.apiKey);
        }
        return this.playerStats;
    }

    public ArrayList<HypixelFriend> getPlayerFriends() throws PlayerNonExistentException, RequestTypeException, NoPlayerStatsException, MalformedAPIKeyException, IOException {
        if (this.playerFriends == null) {
            this.playerFriends = this.api.getPlayerFriends(this.uuid, this.apiKey);
        }
        return this.playerFriends;
    }

    public void reset() {
        this.playerStats = null;
        this.playerFriends = null;
    }
}

