/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.pitevents;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.skyerzz.pitevents.ChatListener;
import com.skyerzz.pitevents.PitEventHandler;
import com.skyerzz.pitevents.PitEventsCommand;
import com.skyerzz.pitevents.ServerConnection;
import com.skyerzz.pitevents.Settings;
import com.skyerzz.pitevents.gui.PitEventGUI;
import com.skyerzz.pitevents.music.SongPlayer;
import java.io.File;
import java.io.IOException;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;

@Mod(modid="pitevents", version="2.0.1", clientSideOnly=true, acceptedMinecraftVersions="[1.8,1.8.9]", name="PitEvents")
public class PitEvents {
    public static final String MODID = "pitevents";
    public static final String VERSION = "2.0.1";
    public static Configuration config;
    public static boolean isServerOnline;
    public static boolean isNewVersionAvailable;
    public static boolean isNewPitJsonAvailable;
    public static boolean isNewPitImageAvailable;
    private String iconImagePath = "./config/pitevents/IconsPitEvents.png";
    private boolean hasCheckedForNewVersion = false;

    public static void setConfigValue(String value, float option) {
        config.get("general", value, (double)option).set((double)option);
        config.save();
    }

    public static void setConfigValue(String value, String option) {
        config.get("general", value, option).set(option);
        config.save();
    }

    public static void setConfigValue(String value, boolean option) {
        config.get("general", value, option).set(option);
        config.save();
    }

    public boolean isServerOnline() {
        ServerConnection conn = new ServerConnection(new byte[]{0});
        return conn.getResponseAsByteArray().length > 0;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Settings.initialise();
        MinecraftForge.EVENT_BUS.register((Object)PitEventHandler.getInstance());
        PitEventHandler.getInstance();
        new PitEventGUI();
        SongPlayer.getInstance();
        ClientCommandHandler.instance.func_71560_a((ICommand)new PitEventsCommand());
        MinecraftForge.EVENT_BUS.register((Object)new ChatListener());
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent ev) {
        config = new Configuration(ev.getSuggestedConfigurationFile());
        config.load();
        isServerOnline = this.isServerOnline();
        System.out.println("[PitEvents] Online: " + isServerOnline);
        if (isServerOnline) {
            System.out.println("[PitEvents] Update: " + this.isNewVersionAvailable());
            System.out.println("[PitEvents] new Json: " + this.isNewPitJsonAvailable());
            boolean isNewPitJsonAvailable = this.isNewPitJsonAvailable();
            if (isNewPitJsonAvailable) {
                JsonParser parser = new JsonParser();
                JsonObject o = parser.parse(this.getPitJsonFromServer()).getAsJsonObject();
                Settings.setPitJson(o);
                Settings.setPitJsonVersion(o.get("jsonVersion").getAsString());
                System.out.println("[PitEvents] newJsonVersion downloaded: " + o.toString());
            }
            boolean isNewEventImageAvailable = this.isNewPitImageAvailable();
            System.out.println("[PitEvents] new event image: " + isNewEventImageAvailable);
            if (isNewEventImageAvailable) {
                String latest = this.getLatestPitImageVersion();
                Settings.setImageVersion(latest);
                System.out.println("[PitEvents] latest img version: " + latest);
                byte[] img = Base64.decodeBase64((byte[])this.getLatestImage());
                File f = new File(this.iconImagePath);
                System.out.println("[PitEvents] Saving latest image at" + f.getAbsolutePath());
                if (!f.exists()) {
                    try {
                        f.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    FileUtils.writeByteArrayToFile((File)new File(this.iconImagePath), (byte[])img);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean isNewVersionAvailable() {
        if (this.hasCheckedForNewVersion) {
            return isNewVersionAvailable;
        }
        byte[] code = new byte[]{10, 32, 32};
        byte[] arr = new byte[code.length + VERSION.getBytes().length];
        System.arraycopy(code, 0, arr, 0, code.length);
        System.arraycopy(VERSION.getBytes(), 0, arr, code.length, VERSION.getBytes().length);
        ServerConnection conn = new ServerConnection(arr);
        isNewVersionAvailable = conn.getResponseAsByteArray()[0] == 1;
        this.hasCheckedForNewVersion = true;
        return isNewVersionAvailable;
    }

    public boolean isNewPitJsonAvailable() {
        String curVersion = Settings.getPitJsonVersion();
        byte[] code = new byte[]{10, 32, 33};
        byte[] arr = new byte[code.length + curVersion.getBytes().length];
        System.arraycopy(code, 0, arr, 0, code.length);
        System.arraycopy(curVersion.getBytes(), 0, arr, code.length, curVersion.getBytes().length);
        ServerConnection conn = new ServerConnection(arr);
        return conn.getResponseAsByteArray()[0] == 1;
    }

    public boolean isNewPitImageAvailable() {
        String curVersion = Settings.getPitImageVersion();
        byte[] code = new byte[]{10, 32, 35};
        byte[] arr = new byte[code.length + curVersion.getBytes().length];
        System.arraycopy(code, 0, arr, 0, code.length);
        System.arraycopy(curVersion.getBytes(), 0, arr, code.length, curVersion.getBytes().length);
        ServerConnection conn = new ServerConnection(arr);
        return conn.getResponseAsByteArray()[0] == 1;
    }

    public String getLatestPitImageVersion() {
        byte[] code = new byte[]{10, 32, 36};
        ServerConnection conn = new ServerConnection(code);
        return conn.getResponseAsString();
    }

    public byte[] getLatestImage() {
        byte[] code = new byte[]{10, 32, 37};
        ServerConnection conn = new ServerConnection(code);
        return conn.getResponseAsByteArray();
    }

    public String getPitJsonFromServer() {
        byte[] code = new byte[]{10, 32, 34};
        ServerConnection conn = new ServerConnection(code);
        return conn.getResponseAsString();
    }
}

