/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.pitevents;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.skyerzz.pitevents.PitEvents;

public class Settings {
    private static boolean doSound = true;
    private static boolean showEmbattle = true;
    private static boolean showEvents = true;
    private static boolean notifyOutsidePit = true;
    private static float heightPercentage = 0.1f;
    private static float widthPercentage = 0.95f;

    public static void initialise() {
        doSound = PitEvents.config.get("general", "sound", true).getBoolean();
        heightPercentage = (float)PitEvents.config.get("general", "heightPerc", (double)0.1f).getDouble();
        widthPercentage = (float)PitEvents.config.get("general", "widthPerc", (double)0.95f).getDouble();
        showEmbattle = PitEvents.config.get("general", "showEmbattle", true).getBoolean();
        showEvents = PitEvents.config.get("general", "showEvents", true).getBoolean();
        notifyOutsidePit = PitEvents.config.get("general", "notifyOutsidePit", true).getBoolean();
    }

    public static void setSound(boolean value) {
        doSound = value;
        PitEvents.setConfigValue("sound", value);
    }

    public static boolean hasSound() {
        return doSound;
    }

    public static boolean doShowEmbattle() {
        return showEmbattle;
    }

    public static boolean doShowEvents() {
        return showEvents;
    }

    public static float getHeightPercentage() {
        return heightPercentage;
    }

    public static float getWidthPercentage() {
        return widthPercentage;
    }

    public static void setShowEmbattle(boolean value) {
        showEmbattle = value;
        PitEvents.setConfigValue("showEmbattle", value);
    }

    public static void setShowEvents(boolean value) {
        showEvents = value;
        PitEvents.setConfigValue("showEvents", value);
    }

    public static void setHeightPercentage(float value) {
        heightPercentage = value;
        PitEvents.setConfigValue("heightPerc", value);
    }

    public static void setWidthPercentage(float value) {
        widthPercentage = value;
        PitEvents.setConfigValue("widthPerc", value);
    }

    public static boolean doNotifyOutsidePit() {
        return notifyOutsidePit;
    }

    public static void setNotifyOutsidePit(boolean value) {
        notifyOutsidePit = value;
        PitEvents.setConfigValue("notifyOutsidePit", value);
    }

    public static void setPitJsonVersion(String version) {
        PitEvents.setConfigValue("PitJsonVersion", version);
    }

    public static String getPitJsonVersion() {
        return PitEvents.config.get("general", "PitJsonVersion", "0.0.0").getString();
    }

    public static String getPitImageVersion() {
        return PitEvents.config.get("general", "PitImageVersion", "0.0.0").getString();
    }

    public static void setPitJson(JsonObject pitJson) {
        PitEvents.config.get("general", "PitJson", "{}").set(pitJson.toString());
        PitEvents.config.save();
    }

    public static JsonObject getPitJson() {
        return new JsonParser().parse(PitEvents.config.get("general", "PitJson", "{}").getString()).getAsJsonObject();
    }

    public static void setImageVersion(String imageVersion) {
        PitEvents.config.get("general", "PitImageVersion", "0.0.0").set(imageVersion);
        PitEvents.config.save();
    }
}

