/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.pitevents.gui;

import com.skyerzz.pitevents.Event;
import com.skyerzz.pitevents.Settings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class PitEditGui
extends GuiScreen {
    private static final ResourceLocation icons = new ResourceLocation("pitevents", "textures/overlay/IconsPitEvents.png");
    private static final int CARE_PACKAGE = 0;
    private static final int TDM = 1;
    private static final int KOTH = 2;
    private static final int DOUBLE_COINS = 3;
    private static final int MATHS = 4;
    private static final int ROBBERY = 5;
    private static final int BEAST = 6;
    private static final int RAGE_PIT = 7;
    private static final int RAFFLE = 8;
    private static final int UNKNOWN = 56;
    private static final int Ctime = -65536;
    private static final int Cbrack = -5069660;
    private static final int Cloc = -11619816;
    private static final int Cname = -15606310;
    private long timeSinceLastScale = 0L;
    private float newXPerc = -1.0f;
    private float newYPerc = -1.0f;
    private Event testEvent = new Event("minor", "Test Event", "Some Location", 599);

    public PitEditGui() {
        this.newXPerc = Settings.getWidthPercentage();
        this.newYPerc = Settings.getHeightPercentage();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        int midX = res.func_78326_a() / 2;
        int midY = res.func_78328_b() / 2;
        int textWidth = this.field_146297_k.field_71466_p.func_78256_a("LeftClick and Drag to move");
        int textHeight = this.field_146297_k.field_71466_p.field_78288_b;
        int paddingheight = 4;
        this.func_73731_b(this.field_146297_k.field_71466_p, "LeftClick and Drag to move", midX -= textWidth / 2, midY -= textHeight / 2, -1);
        this.drawEmbattlementStatus(res.func_78326_a(), res.func_78328_b(), 0);
        this.drawEvent(this.testEvent, res.func_78326_a(), res.func_78328_b(), paddingheight + textHeight);
    }

    public void drawEmbattlementStatus(int fullwidth, int fullheight, int yOffset) {
        String status = "Status:";
        String embattle = "Embattled";
        String time = "15";
        int statusLength = this.field_146297_k.field_71466_p.func_78256_a(status);
        int embattleLength = this.field_146297_k.field_71466_p.func_78256_a(embattle);
        int timeLength = this.field_146297_k.field_71466_p.func_78256_a(time);
        int bracketLength = this.field_146297_k.field_71466_p.func_78256_a("(");
        int defaultPadding = this.field_146297_k.field_71466_p.func_78256_a(" ");
        int y = (int)((float)fullheight * this.newYPerc) + yOffset;
        if (this.newXPerc < 0.5f) {
            int startX = (int)(this.newXPerc * (float)fullwidth);
            this.func_73731_b(this.field_146297_k.field_71466_p, status, startX, y, -5069660);
            this.func_73731_b(this.field_146297_k.field_71466_p, embattle, startX += statusLength + defaultPadding, y, -65536);
            this.func_73731_b(this.field_146297_k.field_71466_p, "(", startX += embattleLength + defaultPadding, y, -5069660);
            this.func_73731_b(this.field_146297_k.field_71466_p, time, startX += bracketLength, y, -15606310);
            this.func_73731_b(this.field_146297_k.field_71466_p, ")", startX += timeLength, y, -5069660);
            startX += bracketLength + defaultPadding;
        } else {
            int startX = (int)(this.newXPerc * (float)fullwidth);
            this.func_73731_b(this.field_146297_k.field_71466_p, ")", startX -= bracketLength, y, -5069660);
            this.func_73731_b(this.field_146297_k.field_71466_p, time, startX -= timeLength, y, -15606310);
            this.func_73731_b(this.field_146297_k.field_71466_p, "(", startX -= bracketLength, y, -5069660);
            this.func_73731_b(this.field_146297_k.field_71466_p, embattle, startX -= embattleLength + defaultPadding, y, -65536);
            this.func_73731_b(this.field_146297_k.field_71466_p, status, startX -= statusLength + defaultPadding, y, -5069660);
        }
    }

    public void func_146273_a(int mouseX, int mouseY, int buttonHeld, long timeSinceLastClick) {
        if (buttonHeld == 0 && timeSinceLastClick - this.timeSinceLastScale > 25L) {
            ScaledResolution res = new ScaledResolution(this.field_146297_k);
            int width = res.func_78326_a();
            int height = res.func_78328_b();
            float percWidth = (float)mouseX / (float)width;
            float percHeight = (float)mouseY / (float)height;
            System.out.println("X% " + percWidth + "   Y%  " + percHeight);
            this.newXPerc = percWidth;
            this.newYPerc = percHeight;
        }
    }

    public void func_146281_b() {
        System.out.println("Closed gui");
        Settings.setHeightPercentage(this.newYPerc);
        Settings.setWidthPercentage(this.newXPerc);
    }

    private void drawEvent(Event e, int fullwidth, int fullHeight, int yOffset) {
        int drawItem = 0;
        switch (e.getName().toLowerCase()) {
            case "care package": {
                drawItem = 0;
                break;
            }
            case "team deathmatch": {
                drawItem = 1;
                break;
            }
            case "koth": {
                drawItem = 2;
                break;
            }
            case "2x rewards": {
                drawItem = 3;
                break;
            }
            case "quick maths": {
                drawItem = 4;
                break;
            }
            case "robbery": {
                drawItem = 5;
                break;
            }
            case "beast": {
                drawItem = 6;
                break;
            }
            case "rage pit": {
                drawItem = 7;
                break;
            }
            case "raffle": {
                drawItem = 8;
            }
        }
        String timeLeft = null;
        if (e.getTimeLeft() >= 0) {
            timeLeft = this.getCountString(e.getTimeLeft());
        }
        String loc = e.getLocation();
        String ev = e.getName();
        int y = (int)((float)fullHeight * this.newYPerc) + yOffset;
        int startX = (int)((float)fullwidth * this.newXPerc);
        int defaultPadding = this.field_146297_k.field_71466_p.func_78256_a(" ");
        int trackX = startX;
        if (this.newXPerc < 0.5f) {
            trackX = startX;
            this.drawImg(this.field_146297_k, drawItem, trackX, y - 4);
            trackX += 16 + defaultPadding;
            if (ev != null) {
                int evWidth = this.field_146297_k.field_71466_p.func_78256_a(ev);
                this.field_146297_k.field_71466_p.func_78276_b(ev, trackX, y, -15606310);
                trackX += evWidth + defaultPadding;
            }
            if (loc != null) {
                int locWidth = this.field_146297_k.field_71466_p.func_78256_a(loc);
                int atWidth = this.field_146297_k.field_71466_p.func_78256_a("@");
                this.field_146297_k.field_71466_p.func_78276_b("@", trackX, y, -5069660);
                this.field_146297_k.field_71466_p.func_78276_b(loc, trackX += atWidth + defaultPadding, y, -11619816);
                trackX += locWidth + defaultPadding;
            }
            if (timeLeft != null) {
                int bracketWith = this.field_146297_k.field_71466_p.func_78256_a("]");
                int timeLeftWidth = this.field_146297_k.field_71466_p.func_78256_a(timeLeft);
                this.field_146297_k.field_71466_p.func_78276_b("[", trackX, y, -5069660);
                this.field_146297_k.field_71466_p.func_78276_b(timeLeft, trackX += bracketWith, y, -65536);
                this.field_146297_k.field_71466_p.func_78276_b("]", trackX += timeLeftWidth, y, -5069660);
                trackX += bracketWith + defaultPadding;
            }
        } else {
            trackX = startX;
            if (timeLeft != null) {
                int bracketWith = this.field_146297_k.field_71466_p.func_78256_a("]");
                int timeLeftWidth = this.field_146297_k.field_71466_p.func_78256_a(timeLeft);
                this.field_146297_k.field_71466_p.func_78276_b("]", trackX -= bracketWith, y, -5069660);
                this.field_146297_k.field_71466_p.func_78276_b(timeLeft, trackX -= timeLeftWidth, y, -65536);
                this.field_146297_k.field_71466_p.func_78276_b("[", trackX -= bracketWith, y, -5069660);
                trackX -= defaultPadding;
            }
            if (loc != null) {
                int locWidth = this.field_146297_k.field_71466_p.func_78256_a(loc);
                int atWidth = this.field_146297_k.field_71466_p.func_78256_a("@");
                this.field_146297_k.field_71466_p.func_78276_b(loc, trackX -= locWidth, y, -11619816);
                trackX -= atWidth;
                this.field_146297_k.field_71466_p.func_78276_b("@", trackX -= defaultPadding, y, -5069660);
                trackX -= defaultPadding;
            }
            if (ev != null) {
                int evWidth = this.field_146297_k.field_71466_p.func_78256_a(ev);
                this.field_146297_k.field_71466_p.func_78276_b(ev, trackX -= evWidth, y, -15606310);
                trackX -= defaultPadding;
            }
            this.drawImg(this.field_146297_k, drawItem, trackX -= 16, y -= 4);
        }
    }

    private void drawImg(Minecraft mc, int option, int x, int y) {
        int startx = 0 + 32 * (option % 8);
        int starty = 0 + 32 * (option / 8);
        mc.func_110434_K().func_110577_a(icons);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(x * 2, y * 2, startx, starty, 32, 32);
        GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    private String getCountString(int seconds) {
        if (seconds <= 0) {
            return "";
        }
        int min = seconds / 60;
        int sec = seconds % 60;
        String m = min + "";
        String s = sec < 10 ? "0" + sec : sec + "";
        return m + ":" + s;
    }
}

