/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.pitevents;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skyerzz.pitevents.Event;
import com.skyerzz.pitevents.PitEventHandler;
import com.skyerzz.pitevents.ServerConnection;
import com.skyerzz.pitevents.Settings;
import com.skyerzz.pitevents.music.SongPlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ChatListener {
    ArrayList<Pattern> eventMatches = new ArrayList();
    Pattern event = Pattern.compile("^(MINOR|MAJOR) EVENT!\\s((.*?)($|starting now|in(.*?)($|ended|((for\\s|)(\\d)\\smin(.*?)))))$");
    Pattern maths = Pattern.compile("^QUICK\\sMATHS!\\sSolve:\\s(.*)$");
    Pattern looted = Pattern.compile("^LOOTED.*?care package");
    Pattern gameserver = Pattern.compile("(?i)^Server found! Sending to ((mini|mega)\\d+\\w).*?$");
    public static String lastMiniGameServerFound = "NULL";
    private HashMap<String, Integer> defaultEventTimings = new HashMap();

    public ChatListener() {
        this.indexEventMatches();
    }

    public void indexEventMatches() {
        JsonObject json = Settings.getPitJson();
        JsonArray arr = json.get("events").getAsJsonArray();
        for (JsonElement e : arr) {
            JsonObject o = e.getAsJsonObject();
            String name = o.get("name").getAsString();
            int defaulttime = o.get("defaulttime").getAsInt();
            this.defaultEventTimings.put(name, defaulttime);
        }
    }

    public void sendEventStringToJade(String minigame, String msg) {
        byte[] code = new byte[]{10, 32, 38, (byte)minigame.length()};
        byte[] arr = new byte[code.length + minigame.getBytes().length + msg.getBytes().length];
        System.arraycopy(code, 0, arr, 0, code.length);
        System.arraycopy(minigame.getBytes(), 0, arr, code.length, minigame.getBytes().length);
        System.arraycopy(msg.getBytes(), 0, arr, code.length + minigame.getBytes().length, msg.getBytes().length);
        ServerConnection conn = new ServerConnection(arr);
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent e) {
        if (e.type != 0) {
            return;
        }
        String message = e.message.func_150260_c().trim();
        Matcher gameMatcher = this.gameserver.matcher(message = message.replaceAll("\u00a7[\\w\\d]", ""));
        if (gameMatcher.matches()) {
            lastMiniGameServerFound = gameMatcher.group(1).trim();
            System.out.println("[PitEvents] Found new minigameServer: " + lastMiniGameServerFound);
            return;
        }
        if (!PitEventHandler.getInstance().isInPitGameMode()) {
            return;
        }
        Matcher m = this.event.matcher(message);
        boolean matches = m.matches();
        if (matches) {
            System.out.println("[PitEvents] Found event : " + message);
            System.out.println("[PitEvents] Sending event to JADE...");
            this.sendEventStringToJade(lastMiniGameServerFound, message);
            if (message.toLowerCase().contains("everyone gets a bounty")) {
                SongPlayer.playStartingSong();
                return;
            }
            for (int i = 0; i < m.groupCount(); ++i) {
                System.out.println("[PitEvents] Group: " + i + " message: " + m.group(i));
            }
            if (m.group(6) != null && m.group(6).trim().equalsIgnoreCase("ended")) {
                PitEventHandler.getInstance().removeEvent(m.group(3).trim(), m.group(5).trim());
                return;
            }
            int duration = Integer.MIN_VALUE;
            try {
                int x = Integer.parseInt(m.group(9).trim());
                duration = -(x * 60);
            }
            catch (NullPointerException | NumberFormatException x) {
                // empty catch block
            }
            boolean hasStarted = false;
            if (message.toLowerCase().contains("starting now")) {
                int timeLeft;
                hasStarted = true;
                duration = timeLeft = this.defaultEventTimings.get(m.group(3).trim()).intValue();
            } else if (message.toLowerCase().contains("for")) {
                hasStarted = true;
                duration *= -1;
            }
            PitEventHandler.getInstance().addEvent(new Event(m.group(1), m.group(3), m.group(5), duration, hasStarted));
        } else if (message.contains("QUICK MATHS")) {
            System.out.println("QUITCK MATHS?!");
            if (message.contains("QUICK MATHS OVER")) {
                System.out.println("Aww its over, RIP quick maths");
                PitEventHandler.getInstance().removeMathsEvent();
            } else {
                Matcher mathMatcher = this.maths.matcher(message);
                if (mathMatcher.matches()) {
                    for (int i = 0; i < mathMatcher.groupCount(); ++i) {
                        System.out.println("[PitEvents] Maths! Group: " + i + " message: " + mathMatcher.group(i));
                    }
                    PitEventHandler.getInstance().addEvent(new Event("Maths", "QUICK MATHS", mathMatcher.group(1), -1));
                } else {
                    System.out.println("[PitEvents] Couldnt find the correct QUICK MATHS sum?? " + message);
                }
            }
        } else if (message.contains("EVENT!")) {
            System.out.println("No Match for \"" + message + "\".");
        } else if (message.contains("DRAGON EGG OVER") || message.contains("DRAGON EGG! event over!")) {
            PitEventHandler.getInstance().reset();
            System.out.println("Dragon egg over, resetting events!");
        } else {
            Matcher lootm = this.looted.matcher(message);
            boolean lootmatch = lootm.matches();
            if (lootmatch) {
                System.out.println("[PitEvents] Matched for care package looted!");
                PitEventHandler.getInstance().removeCarePackageEvent();
            }
        }
    }
}

