/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.pitevents;

public class Event {
    private String type;
    private String name;
    private String location;
    private int seconds = -1;
    private boolean hasStarted;

    public Event(String type, String name) {
        this(type, name, null, -1);
    }

    public Event(String type, String name, String location) {
        this(type, name, location, -1);
    }

    public Event(String type, String name, String location, int seconds) {
        this.type = type.trim();
        this.name = name.trim();
        if (location != null) {
            this.location = location.trim();
        }
        this.seconds = seconds;
    }

    public Event(String type, String name, String location, int seconds, boolean hasStarted) {
        this.type = type.trim();
        this.name = name.trim();
        if (location != null) {
            this.location = location.trim();
        }
        this.seconds = seconds;
        this.hasStarted = hasStarted;
    }

    public boolean tick() {
        if (this.hasStarted) {
            if (this.seconds > 0) {
                --this.seconds;
            }
            return this.seconds <= 0;
        }
        if (this.seconds < 0) {
            ++this.seconds;
        }
        return this.seconds >= 0;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getLocation() {
        return this.location;
    }

    public int getTimeLeft() {
        return this.seconds;
    }

    public boolean hasStarted() {
        return this.hasStarted;
    }

    public String toString() {
        return "[" + this.type + "] " + this.name + (this.location != null ? " at " + this.location : "") + " for " + this.seconds;
    }
}

