/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.pitevents;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.skyerzz.pitevents.Event;
import com.skyerzz.pitevents.PitEvents;
import com.skyerzz.pitevents.ServerConnection;
import com.skyerzz.pitevents.Settings;
import com.skyerzz.pitevents.music.SongPlayer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PitEventHandler {
    private final int cooldownmilliseconds = 15000;
    private static PitEventHandler instance;
    public static boolean isInPitGamemode;
    private ArrayList<Event> events = new ArrayList();
    private long lastPlayertickTime = -1L;
    private long lastDamageTaken = -1L;
    private float lastHealth = -1.0f;

    private PitEventHandler() {
        this.startLoop();
    }

    public static PitEventHandler getInstance() {
        if (instance == null) {
            instance = new PitEventHandler();
        }
        return instance;
    }

    public boolean isInPitGameMode() {
        return isInPitGamemode;
    }

    public ArrayList<Event> getEvents() {
        return this.events;
    }

    public void addEvent(Event event) {
        for (Event e : this.events) {
            if (!e.getName().equals(event.getName()) || !e.getLocation().equals(event.getLocation())) continue;
            return;
        }
        System.out.println("[PitEvents] Adding event " + event.toString());
        this.events.add(event);
        SongPlayer.playStartingSong();
    }

    public void removeCarePackageEvent() {
        Event toRemove = null;
        for (Event e : this.events) {
            if (!e.getName().equalsIgnoreCase("Care Package")) continue;
            toRemove = e;
            System.out.println("[PitEvents] Removed care package event: " + e.toString());
            break;
        }
        if (toRemove != null) {
            this.events.remove(toRemove);
        }
    }

    public void removeMathsEvent() {
        Event toRemove = null;
        for (Event e : this.events) {
            if (!e.getName().equalsIgnoreCase("Quick Maths")) continue;
            toRemove = e;
            System.out.println("[PitEvents] Removed Quick Maths event: " + e.toString());
            break;
        }
        if (toRemove != null) {
            this.events.remove(toRemove);
        }
    }

    public void removeEvent(String name, String location) {
        Event toRemove = null;
        for (Event e : this.events) {
            if (!e.getName().equalsIgnoreCase(name) || !e.getLocation().equalsIgnoreCase(location)) continue;
            toRemove = e;
            System.out.println("[PitEvents] Removed event: " + e.toString());
            break;
        }
        if (toRemove != null) {
            this.events.remove(toRemove);
        }
    }

    public int getTimeToIdle() {
        if (this.lastDamageTaken == -1L) {
            return 0;
        }
        long time = System.currentTimeMillis();
        long diff = time - this.lastDamageTaken;
        return (int)Math.ceil((15000L - diff) / 1000L);
    }

    public void reset() {
        this.events.clear();
        this.lastPlayertickTime = -1L;
        this.lastDamageTaken = -1L;
        this.lastHealth = -1.0f;
    }

    public void startLoop() {
        new Thread(new Runnable(){
            long lastTick = System.currentTimeMillis();
            long lastServerUpdate = System.currentTimeMillis() - 60000L;

            @Override
            public void run() {
                while (true) {
                    long time;
                    if (this.lastTick <= (time = System.currentTimeMillis())) {
                        this.lastTick += 1000L;
                        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_96441_U() != null && Minecraft.func_71410_x().field_71441_e.func_96441_U().func_96539_a(1) != null) {
                            ScoreObjective objective = Minecraft.func_71410_x().field_71441_e.func_96441_U().func_96539_a(1);
                            isInPitGamemode = objective.func_96679_b().equalsIgnoreCase("pit");
                        }
                        ArrayList<Event> toRemove = new ArrayList<Event>();
                        for (Event ev : PitEventHandler.this.events) {
                            if (!ev.tick()) continue;
                            System.out.println("[PitEvents] Removing event " + ev.getName() + " : " + ev.getLocation());
                            toRemove.add(ev);
                            break;
                        }
                        for (Event e : toRemove) {
                            PitEventHandler.this.events.remove(e);
                        }
                    }
                    if (!isInPitGamemode && PitEvents.isServerOnline && Settings.doNotifyOutsidePit() && this.lastServerUpdate + 60000L < time) {
                        System.out.println("Checking server for new events");
                        this.lastServerUpdate += 60000L;
                        PitEventHandler.this.getEventsFromServer();
                    }
                    try {
                        long slp = this.lastTick - System.currentTimeMillis();
                        slp = slp < 0L ? 0L : slp;
                        Thread.sleep(slp);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    public void getEventsFromServer() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ServerConnection conn = new ServerConnection(new byte[]{10, 32, 39});
                JsonArray jsonEvents = new JsonParser().parse(conn.getResponseAsString()).getAsJsonArray();
                PitEventHandler.this.addServerEvents(jsonEvents);
            }
        }).start();
    }

    public void addServerEvents(JsonArray arr) {
        for (JsonElement el : arr) {
            JsonObject jsonObject = el.getAsJsonObject();
            if (!jsonObject.get("type").getAsString().equalsIgnoreCase("major")) continue;
            int timeLeft = (int)(System.currentTimeMillis() / 1000L - jsonObject.get("time").getAsLong());
            Event e = new Event(jsonObject.get("type").getAsString(), jsonObject.get("name").getAsString(), "", timeLeft, false);
            this.addEvent(e);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.PlayerTickEvent e) {
        long time = System.currentTimeMillis();
        if (isInPitGamemode && this.lastPlayertickTime + 50L < time && e.player.func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            this.lastPlayertickTime = time;
            float health = e.player.func_110143_aJ();
            if (this.lastHealth > health) {
                this.lastDamageTaken = time;
            }
            this.lastHealth = health;
        }
    }

    static {
        isInPitGamemode = false;
    }
}

