/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.pitevents.gui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skyerzz.pitevents.Event;
import com.skyerzz.pitevents.PitEventHandler;
import com.skyerzz.pitevents.Settings;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class PitEventGUI {
    private static final ResourceLocation icons = new ResourceLocation("pitevents", "textures/overlay/IconsPitEvents.png");
    private static final int UNKNOWN = 56;
    private static final int Ctime = -65536;
    private static final int Cbrack = -5069660;
    private static final int Cloc = -11619816;
    private static final int Cname = -15606310;
    public static HashMap<String, Integer> eventImageIndex = new HashMap();

    public static void index() {
        JsonObject o = Settings.getPitJson();
        JsonArray events = o.get("events").getAsJsonArray();
        for (JsonElement e : events) {
            JsonObject ev = e.getAsJsonObject();
            eventImageIndex.put(ev.get("name").getAsString(), ev.get("img").getAsInt());
        }
    }

    public PitEventGUI() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        PitEventGUI.index();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDraw(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
            ScaledResolution res = event.resolution;
            int width = res.func_78326_a();
            int height = res.func_78328_b();
            int stringHeight = Minecraft.func_71410_x().field_71466_p.field_78288_b;
            int y = 0;
            if (Settings.doShowEmbattle()) {
                this.drawEmbattlementStatus(width, height, 0);
                y = 4 + stringHeight;
            }
            if (Settings.doShowEvents()) {
                for (Event e : PitEventHandler.getInstance().getEvents()) {
                    this.drawEvent(e, width, height, y);
                    y += 4 + stringHeight;
                }
            }
        }
    }

    public void drawEmbattlementStatus(int fullwidth, int fullheight, int yOffset) {
        Minecraft mc = Minecraft.func_71410_x();
        float newXPerc = Settings.getWidthPercentage();
        float newYPerc = Settings.getHeightPercentage();
        String status = "Status:";
        int timeToIdle = PitEventHandler.getInstance().getTimeToIdle();
        String embattleStatus = timeToIdle > 0 ? "Embattled" : "Idle";
        String time = timeToIdle + "";
        int statusLength = mc.field_71466_p.func_78256_a(status);
        int embattleLength = mc.field_71466_p.func_78256_a(embattleStatus);
        int timeLength = mc.field_71466_p.func_78256_a(time);
        int bracketLength = mc.field_71466_p.func_78256_a("(");
        int defaultPadding = mc.field_71466_p.func_78256_a(" ");
        int y = (int)((float)fullheight * newYPerc) + yOffset;
        if (newXPerc < 0.5f) {
            int startX = (int)(newXPerc * (float)fullwidth);
            mc.field_71466_p.func_78276_b(status, startX, y, -5069660);
            mc.field_71466_p.func_78276_b(embattleStatus, startX += statusLength + defaultPadding, y, timeToIdle > 0 ? -65536 : -11619816);
            startX += embattleLength + defaultPadding;
            if (timeToIdle > 0) {
                mc.field_71466_p.func_78276_b("(", startX, y, -5069660);
                mc.field_71466_p.func_78276_b(time, startX += bracketLength, y, -15606310);
                mc.field_71466_p.func_78276_b(")", startX += timeLength, y, -5069660);
                startX += bracketLength + defaultPadding;
            }
        } else {
            int startX = (int)(newXPerc * (float)fullwidth);
            if (timeToIdle > 0) {
                mc.field_71466_p.func_78276_b(")", startX -= bracketLength, y, -5069660);
                mc.field_71466_p.func_78276_b(time, startX -= timeLength, y, -15606310);
                mc.field_71466_p.func_78276_b("(", startX -= bracketLength, y, -5069660);
            }
            mc.field_71466_p.func_78276_b(embattleStatus, startX -= embattleLength + defaultPadding, y, timeToIdle > 0 ? -65536 : -11619816);
            mc.field_71466_p.func_78276_b(status, startX -= statusLength + defaultPadding, y, -5069660);
        }
    }

    private void drawEvent(Event e, int fullwidth, int fullHeight, int yOffset) {
        Minecraft mc = Minecraft.func_71410_x();
        float newXPerc = Settings.getWidthPercentage();
        float newYPerc = Settings.getHeightPercentage();
        int drawItem = 56;
        if (eventImageIndex.containsKey(e.getName().toLowerCase())) {
            drawItem = eventImageIndex.get(e.getName().toLowerCase());
        }
        String timeLeft = null;
        if (e.getTimeLeft() != 0) {
            timeLeft = this.getCountString(e.getTimeLeft());
        }
        String loc = e.getLocation();
        String ev = e.getName();
        int y = (int)((float)fullHeight * newYPerc) + yOffset;
        int startX = (int)((float)fullwidth * newXPerc);
        int defaultPadding = mc.field_71466_p.func_78256_a(" ");
        int trackX = startX;
        if (newXPerc < 0.5f) {
            trackX = startX;
            this.drawImg(mc, drawItem, trackX, y - 4);
            trackX += 16 + defaultPadding;
            if (ev != null) {
                int evWidth = mc.field_71466_p.func_78256_a(ev);
                mc.field_71466_p.func_78276_b(ev, trackX, y, -15606310);
                trackX += evWidth + defaultPadding;
            }
            if (loc != null && !loc.isEmpty()) {
                int locWidth = mc.field_71466_p.func_78256_a(loc);
                int atWidth = mc.field_71466_p.func_78256_a("@");
                mc.field_71466_p.func_78276_b("@", trackX, y, -5069660);
                mc.field_71466_p.func_78276_b(loc, trackX += atWidth + defaultPadding, y, -11619816);
                trackX += locWidth + defaultPadding;
            }
            if (timeLeft != null) {
                int bracketWith = mc.field_71466_p.func_78256_a("]");
                int timeLeftWidth = mc.field_71466_p.func_78256_a(timeLeft);
                mc.field_71466_p.func_78276_b("[", trackX, y, -5069660);
                mc.field_71466_p.func_78276_b(timeLeft, trackX += bracketWith, y, -65536);
                mc.field_71466_p.func_78276_b("]", trackX += timeLeftWidth, y, -5069660);
                trackX += bracketWith + defaultPadding;
            }
        } else {
            trackX = startX;
            if (timeLeft != null) {
                int bracketWith = mc.field_71466_p.func_78256_a("]");
                int timeLeftWidth = mc.field_71466_p.func_78256_a(timeLeft);
                mc.field_71466_p.func_78276_b("]", trackX -= bracketWith, y, -5069660);
                mc.field_71466_p.func_78276_b(timeLeft, trackX -= timeLeftWidth, y, -65536);
                mc.field_71466_p.func_78276_b("[", trackX -= bracketWith, y, -5069660);
                trackX -= defaultPadding;
            }
            if (loc != null && !loc.isEmpty()) {
                int locWidth = mc.field_71466_p.func_78256_a(loc);
                int atWidth = mc.field_71466_p.func_78256_a("@");
                mc.field_71466_p.func_78276_b(loc, trackX -= locWidth, y, -11619816);
                trackX -= atWidth;
                mc.field_71466_p.func_78276_b("@", trackX -= defaultPadding, y, -5069660);
                trackX -= defaultPadding;
            }
            if (ev != null) {
                int evWidth = mc.field_71466_p.func_78256_a(ev);
                mc.field_71466_p.func_78276_b(ev, trackX -= evWidth, y, -15606310);
                trackX -= defaultPadding;
            }
            this.drawImg(mc, drawItem, trackX -= 16, y -= 4);
        }
    }

    private String getCountString(int seconds) {
        if (seconds == 0) {
            return "";
        }
        int abSec = Math.abs(seconds);
        int min = abSec / 60;
        int sec = abSec % 60;
        String m = min + "";
        String s = sec < 10 ? "0" + sec : sec + "";
        return (seconds < 0 ? "-" : "") + m + ":" + s;
    }

    private void drawImg(Minecraft mc, int option, int x, int y) {
        int startx = 0 + 32 * (option % 8);
        int starty = 0 + 32 * (option / 8);
        mc.func_110434_K().func_110577_a(icons);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71456_v.func_73729_b(x * 2, y * 2, startx, starty, 32, 32);
        GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    public static void enableAlpha(float alpha) {
        GlStateManager.func_179147_l();
        if (alpha == 1.0f) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    public static void disableAlpha(float alpha) {
        GlStateManager.func_179084_k();
        if (alpha == 1.0f) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

