/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.pitevents;

import com.skyerzz.pitevents.Event;
import com.skyerzz.pitevents.music.SongPlayer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class PitEventHandler {
    private final int cooldownmilliseconds = 15000;
    private static PitEventHandler instance;
    private boolean isInPitGamemode = false;
    private ArrayList<Event> events = new ArrayList();
    private long lastTickTime = -1L;
    private long lastPlayertickTime = -1L;
    private long lastDamageTaken = -1L;
    private float lastHealth = -1.0f;

    private PitEventHandler() {
    }

    public static PitEventHandler getInstance() {
        if (instance == null) {
            instance = new PitEventHandler();
        }
        return instance;
    }

    public boolean isInPitGameMode() {
        return this.isInPitGamemode;
    }

    public ArrayList<Event> getEvents() {
        return this.events;
    }

    public void addEvent(Event event) {
        for (Event e : this.events) {
            if (!e.getName().equals(event.getName()) || !e.getLocation().equals(event.getLocation())) continue;
            return;
        }
        System.out.println("[PitEvents] Adding event " + event.toString());
        this.events.add(event);
        SongPlayer.playStartingSong();
    }

    public void removeCarePackageEvent() {
        Event toRemove = null;
        for (Event e : this.events) {
            if (!e.getName().equalsIgnoreCase("Care Package")) continue;
            toRemove = e;
            System.out.println("[PitEvents] Removed care package event: " + e.toString());
            break;
        }
        if (toRemove != null) {
            this.events.remove(toRemove);
        }
    }

    public void removeMathsEvent() {
        Event toRemove = null;
        for (Event e : this.events) {
            if (!e.getName().equalsIgnoreCase("Quick Maths")) continue;
            toRemove = e;
            System.out.println("[PitEvents] Removed Quick Maths event: " + e.toString());
            break;
        }
        if (toRemove != null) {
            this.events.remove(toRemove);
        }
    }

    public void removeEvent(String name, String location) {
        Event toRemove = null;
        for (Event e : this.events) {
            if (!e.getName().equalsIgnoreCase(name) || !e.getLocation().equalsIgnoreCase(location)) continue;
            toRemove = e;
            System.out.println("[PitEvents] Removed event: " + e.toString());
            break;
        }
        if (toRemove != null) {
            this.events.remove(toRemove);
        }
    }

    public int getTimeToIdle() {
        if (this.lastDamageTaken == -1L) {
            return 0;
        }
        long time = System.currentTimeMillis();
        long diff = time - this.lastDamageTaken;
        return (int)Math.ceil((15000L - diff) / 1000L);
    }

    public void reset() {
        this.events.clear();
        this.lastTickTime = -1L;
        this.lastPlayertickTime = -1L;
        this.lastDamageTaken = -1L;
        this.lastHealth = -1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void loop(TickEvent.ClientTickEvent e) {
        if (e.side == Side.CLIENT && e.phase == TickEvent.Phase.END) {
            long time = System.currentTimeMillis();
            if (this.lastTickTime == -1L) {
                this.lastTickTime = time;
            }
            if (this.lastTickTime + 1000L < time) {
                PitEventHandler pitEventHandler = this;
                synchronized (pitEventHandler) {
                    if (this.lastTickTime + 1000L < time) {
                        this.lastTickTime += 1000L;
                        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_96441_U() != null && Minecraft.func_71410_x().field_71441_e.func_96441_U().func_96539_a(1) != null) {
                            ScoreObjective objective = Minecraft.func_71410_x().field_71441_e.func_96441_U().func_96539_a(1);
                            if (objective.func_96679_b().equalsIgnoreCase("pit")) {
                                this.isInPitGamemode = true;
                            } else {
                                this.isInPitGamemode = false;
                                PitEventHandler.getInstance().reset();
                            }
                        }
                        Event toRemove = null;
                        for (Event ev : this.events) {
                            if (!ev.tick()) continue;
                            System.out.println("[PitEvents] Removing event " + ev.getName() + " : " + ev.getLocation());
                            toRemove = ev;
                            break;
                        }
                        if (toRemove != null) {
                            this.events.remove(toRemove);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.PlayerTickEvent e) {
        long time = System.currentTimeMillis();
        if (this.isInPitGamemode && this.lastPlayertickTime + 50L < time && e.player.func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            this.lastPlayertickTime = time;
            float health = e.player.func_110143_aJ();
            if (this.lastHealth > health) {
                this.lastDamageTaken = time;
            }
            this.lastHealth = health;
        }
    }
}

