/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.tweetchieve;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.skyerzz.tweetchieve.ChatListener;
import com.skyerzz.tweetchieve.ConfigHandler;
import com.skyerzz.tweetchieve.ServerConnection;
import com.skyerzz.tweetchieve.TweetChieveCommand;
import com.skyerzz.tweetchieve.TweetHandler;
import com.skyerzz.tweetchieve.achievement.AchievementGameType;
import com.skyerzz.tweetchieve.achievement.SingleAchievement;
import com.skyerzz.tweetchieve.achievement.TieredAchievement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.command.ICommand;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twitter4j.TwitterException;

@Mod(modid="tweetchieve", version="2.0.0", acceptedMinecraftVersions="[1.8,1.8.9]", clientSideOnly=true)
public class TweetChieve {
    public static final String MODID = "tweetchieve";
    public static final String VERSION = "2.0.0";
    private static final String updateURL = "http://skyerzz.com/tweetchieve";
    private boolean hasCheckedForNewVersion = false;
    public static TweetHandler tweetHandler;
    public static Configuration config;
    public static boolean isOnHypixel;
    public static String ip;
    boolean isServerOnline;
    boolean isNewAchievementFileAvailable;
    boolean isNewVersionAvailable;
    boolean loadedFromCache = false;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent e) {
        config = new Configuration(e.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        System.out.println("[TweetChieve] registering chatListener...");
        MinecraftForge.EVENT_BUS.register((Object)new ChatListener());
        System.out.println("[TweetChieve] registering ServerListener...");
        MinecraftForge.EVENT_BUS.register((Object)this);
        System.out.println("[TweetChieve] registering command...");
        ClientCommandHandler.instance.func_71560_a((ICommand)new TweetChieveCommand());
        System.out.println("[TweetChieve] instancing tweethandler...");
        tweetHandler = new TweetHandler();
        new ConfigHandler(config);
        if (ConfigHandler.getAccessTokenFromFile() != null) {
            tweetHandler.setAccessToken(ConfigHandler.getAccessTokenFromFile());
            System.out.println("[TweetChieve] Loaded access token from file!");
        } else {
            System.out.println("[TweetChieve] Couldnt load access token from file!");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.out.println("[Tweetchieve] FOUND CLIENT SHUTDOWN");
            System.out.println("[Tweetchieve] Sending forced tweetqueue...");
            try {
                tweetHandler.sendTweetQueue(true);
            }
            catch (TwitterException e1) {
                System.out.println("[Tweetchieve] Some error happened!");
                e1.printStackTrace();
            }
        }));
        System.out.println("[Tweetchieve] Pinging Tweetchieve Server...");
        this.isServerOnline = this.isServerOnline();
        JsonParser parser = new JsonParser();
        if (this.isServerOnline) {
            System.out.println("[Tweetchieve] Server online!");
            this.isNewVersionAvailable = this.isNewVersionAvailable();
            System.out.println("[Tweetchieve] [INIT] Update available: " + this.isNewVersionAvailable);
            this.isNewAchievementFileAvailable = this.isNewAchievementVersionAvailable();
            System.out.println("[Tweetchieve] [INIT] New achievement version available: " + this.isNewAchievementFileAvailable);
            JsonObject json = parser.parse(ConfigHandler.getAchievementsJsonFromFile()).getAsJsonObject();
            if (this.isNewAchievementFileAvailable) {
                json = parser.parse(this.getAchievementFileFromServer()).getAsJsonObject();
            }
            if (json != null) {
                ConfigHandler.setAchievementsFileVersion(json.get("version").getAsString());
                ConfigHandler.setAchievementsJson(json.toString());
                AchievementGameType.index(json.get("gameTypes").getAsJsonObject());
                SingleAchievement.index(json.get("singleAchievements").getAsJsonObject());
                TieredAchievement.index(json.get("tieredAchievements").getAsJsonObject());
            } else {
                System.out.println("[Tweetchieve] [INIT] ERROR: null json file!");
            }
        } else {
            System.out.println("[Tweetchieve] Server offline! Please contact the mod author if this keeps happening!");
            JsonObject json = parser.parse(ConfigHandler.getAchievementsJsonFromFile()).getAsJsonObject();
            if (json != null) {
                System.out.println("[TweetChieve] Loaded latest achievement list from memory");
                AchievementGameType.index(json.get("gameTypes").getAsJsonObject());
                SingleAchievement.index(json.get("singleAchievements").getAsJsonObject());
                TieredAchievement.index(json.get("tieredAchievements").getAsJsonObject());
            } else {
                System.out.println("[Tweetchieve] [INIT] ERROR: null json file from memory & server offline!");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onServerJoined(FMLNetworkEvent.ClientConnectedToServerEvent e) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            ServerData data = Minecraft.func_71410_x().func_147104_D();
            ip = data.field_78845_b;
            if (data != null && data.field_78845_b != null && !e.isLocal) {
                System.out.println("[Tweetchieve] Connecting to server: " + data.field_78845_b);
                if (data.field_78845_b.equalsIgnoreCase("mc.hypixel.net")) {
                    System.out.println("[Tweetchieve] Found the official hypixel IP! Enabling mod...");
                    isOnHypixel = true;
                    this.sendUpdateMessage(250);
                } else if (data.field_78845_b.equalsIgnoreCase(ConfigHandler.getAlternativeIP()) && this.isValidIP(ConfigHandler.getAlternativeIP())) {
                    System.out.println("[Tweetchieve] Found an alternative hypixel IP! Enabling mod...");
                    isOnHypixel = true;
                    this.sendUpdateMessage(250);
                }
            }
        });
    }

    public void sendUpdateMessage(int delay) {
        if (!this.isNewVersionAvailable) {
            return;
        }
        if (delay > 2500) {
            System.out.println("[Tweetchieve] ERROR: Could not send update message due to timeout!");
            return;
        }
        new Thread(() -> {
            try {
                Thread.sleep(delay);
                if (this.isNewVersionAvailable) {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "[TweetChieve] There is a new update available! Please update to the latest version!"));
                    ChatComponentText t = new ChatComponentText(ChatFormatting.RED + "Please update at " + updateURL);
                    t.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, updateURL));
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)t);
                } else if (!this.isServerOnline) {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "[TweetChieve] Couldnt Connect to the Tweetchieve Server! Please contact the mod owner about this."));
                }
            }
            catch (InterruptedException e1) {
                System.out.println("[Tweetchieve] Error occured! Trying update delay of " + delay * 2 + " now...");
                this.sendUpdateMessage(delay * 2);
            }
        }).start();
    }

    public boolean isValidIP(String ip) {
        return ip.endsWith(".hypixel.net");
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onServerLeft(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        System.out.println("LEFT SERVER: OFFLINE");
        isOnHypixel = false;
    }

    public boolean isServerOnline() {
        ServerConnection conn = new ServerConnection(new byte[]{0});
        return conn.getResponseAsByteArray().length > 0;
    }

    public boolean isNewVersionAvailable() {
        if (this.hasCheckedForNewVersion) {
            return this.isNewVersionAvailable;
        }
        byte[] code = new byte[]{10, 16, 32, 1};
        byte[] arr = new byte[code.length + VERSION.getBytes().length];
        System.arraycopy(code, 0, arr, 0, code.length);
        System.arraycopy(VERSION.getBytes(), 0, arr, code.length, VERSION.getBytes().length);
        ServerConnection conn = new ServerConnection(arr);
        this.isNewVersionAvailable = conn.getResponseAsByteArray()[0] == 1;
        this.hasCheckedForNewVersion = true;
        return this.isNewVersionAvailable;
    }

    public boolean isNewAchievementVersionAvailable() {
        String curVersion = ConfigHandler.getAchievementsFileVersion();
        byte[] code = new byte[]{10, 16, 33};
        byte[] arr = new byte[code.length + curVersion.getBytes().length];
        System.arraycopy(code, 0, arr, 0, code.length);
        System.arraycopy(curVersion.getBytes(), 0, arr, code.length, curVersion.getBytes().length);
        ServerConnection conn = new ServerConnection(arr);
        return conn.getResponseAsByteArray()[0] == 1;
    }

    public String getAchievementFileFromServer() {
        byte[] code = new byte[]{10, 16, 34};
        ServerConnection conn = new ServerConnection(code);
        return conn.getResponseAsString();
    }

    static {
        isOnHypixel = false;
        ip = "";
    }
}

