/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import twitter4j.GeoLocation;
import twitter4j.HTMLEntity;
import twitter4j.HashtagEntity;
import twitter4j.HashtagEntityJSONImpl;
import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONImplFactory;
import twitter4j.JSONObject;
import twitter4j.Logger;
import twitter4j.MediaEntity;
import twitter4j.MediaEntityJSONImpl;
import twitter4j.ParseUtil;
import twitter4j.Place;
import twitter4j.PlaceJSONImpl;
import twitter4j.ResponseList;
import twitter4j.ResponseListImpl;
import twitter4j.Scopes;
import twitter4j.ScopesImpl;
import twitter4j.Status;
import twitter4j.SymbolEntity;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponseImpl;
import twitter4j.URLEntity;
import twitter4j.URLEntityJSONImpl;
import twitter4j.User;
import twitter4j.UserJSONImpl;
import twitter4j.UserMentionEntity;
import twitter4j.UserMentionEntityJSONImpl;
import twitter4j.conf.Configuration;

final class StatusJSONImpl
extends TwitterResponseImpl
implements Status,
Serializable {
    private static final Logger logger = Logger.getLogger(StatusJSONImpl.class);
    private static final long serialVersionUID = -6461195536943679985L;
    private Date createdAt;
    private long id;
    private String text;
    private int displayTextRangeStart = -1;
    private int displayTextRangeEnd = -1;
    private String source;
    private boolean isTruncated;
    private long inReplyToStatusId;
    private long inReplyToUserId;
    private boolean isFavorited;
    private boolean isRetweeted;
    private int favoriteCount;
    private String inReplyToScreenName;
    private GeoLocation geoLocation = null;
    private Place place = null;
    private long retweetCount;
    private boolean isPossiblySensitive;
    private String lang;
    private long[] contributorsIDs;
    private Status retweetedStatus;
    private UserMentionEntity[] userMentionEntities;
    private URLEntity[] urlEntities;
    private HashtagEntity[] hashtagEntities;
    private MediaEntity[] mediaEntities;
    private SymbolEntity[] symbolEntities;
    private long currentUserRetweetId = -1L;
    private Scopes scopes;
    private User user = null;
    private String[] withheldInCountries = null;
    private Status quotedStatus;
    private long quotedStatusId = -1L;

    StatusJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(this, json);
        }
    }

    StatusJSONImpl(JSONObject json, Configuration conf) throws TwitterException {
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            TwitterObjectFactory.registerJSONObject(this, json);
        }
    }

    StatusJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    StatusJSONImpl() {
    }

    private void init(JSONObject json) throws TwitterException {
        this.id = ParseUtil.getLong("id", json);
        this.source = ParseUtil.getUnescapedString("source", json);
        this.createdAt = ParseUtil.getDate("created_at", json);
        this.isTruncated = ParseUtil.getBoolean("truncated", json);
        this.inReplyToStatusId = ParseUtil.getLong("in_reply_to_status_id", json);
        this.inReplyToUserId = ParseUtil.getLong("in_reply_to_user_id", json);
        this.isFavorited = ParseUtil.getBoolean("favorited", json);
        this.isRetweeted = ParseUtil.getBoolean("retweeted", json);
        this.inReplyToScreenName = ParseUtil.getUnescapedString("in_reply_to_screen_name", json);
        this.retweetCount = ParseUtil.getLong("retweet_count", json);
        this.favoriteCount = ParseUtil.getInt("favorite_count", json);
        this.isPossiblySensitive = ParseUtil.getBoolean("possibly_sensitive", json);
        try {
            JSONObject scopesJson;
            if (!json.isNull("user")) {
                this.user = new UserJSONImpl(json.getJSONObject("user"));
            }
            this.geoLocation = JSONImplFactory.createGeoLocation(json);
            if (!json.isNull("place")) {
                this.place = new PlaceJSONImpl(json.getJSONObject("place"));
            }
            if (!json.isNull("retweeted_status")) {
                this.retweetedStatus = new StatusJSONImpl(json.getJSONObject("retweeted_status"));
            }
            if (!json.isNull("contributors")) {
                JSONArray contributorsArray = json.getJSONArray("contributors");
                this.contributorsIDs = new long[contributorsArray.length()];
                for (int i = 0; i < contributorsArray.length(); ++i) {
                    this.contributorsIDs[i] = Long.parseLong(contributorsArray.getString(i));
                }
            } else {
                this.contributorsIDs = new long[0];
            }
            this.collectEntities(json);
            this.mergeExtendedEntities(json);
            if (!json.isNull("quoted_status")) {
                this.quotedStatus = new StatusJSONImpl(json.getJSONObject("quoted_status"));
            }
            if (!json.isNull("quoted_status_id")) {
                this.quotedStatusId = ParseUtil.getLong("quoted_status_id", json);
            }
            if (!json.isNull("display_text_range")) {
                JSONArray indicesArray = json.getJSONArray("display_text_range");
                this.displayTextRangeStart = indicesArray.getInt(0);
                this.displayTextRangeEnd = indicesArray.getInt(1);
            }
            this.userMentionEntities = this.userMentionEntities == null ? new UserMentionEntity[]{} : this.userMentionEntities;
            this.urlEntities = this.urlEntities == null ? new URLEntity[]{} : this.urlEntities;
            this.hashtagEntities = this.hashtagEntities == null ? new HashtagEntity[]{} : this.hashtagEntities;
            this.symbolEntities = this.symbolEntities == null ? new SymbolEntity[]{} : this.symbolEntities;
            MediaEntity[] mediaEntityArray = this.mediaEntities = this.mediaEntities == null ? new MediaEntity[]{} : this.mediaEntities;
            if (!json.isNull("text")) {
                this.text = HTMLEntity.unescapeAndSlideEntityIncdices(json.getString("text"), this.userMentionEntities, this.urlEntities, this.hashtagEntities, this.mediaEntities);
            }
            if (!json.isNull("full_text")) {
                this.text = HTMLEntity.unescapeAndSlideEntityIncdices(json.getString("full_text"), this.userMentionEntities, this.urlEntities, this.hashtagEntities, this.mediaEntities);
            }
            if (!json.isNull("extended_tweet")) {
                this.mergeExtendedTweet(json.getJSONObject("extended_tweet"));
            }
            if (!json.isNull("current_user_retweet")) {
                this.currentUserRetweetId = json.getJSONObject("current_user_retweet").getLong("id");
            }
            if (!json.isNull("lang")) {
                this.lang = ParseUtil.getUnescapedString("lang", json);
            }
            if (!json.isNull("scopes") && !(scopesJson = json.getJSONObject("scopes")).isNull("place_ids")) {
                JSONArray placeIdsArray = scopesJson.getJSONArray("place_ids");
                int len = placeIdsArray.length();
                String[] placeIds = new String[len];
                for (int i = 0; i < len; ++i) {
                    placeIds[i] = placeIdsArray.getString(i);
                }
                this.scopes = new ScopesImpl(placeIds);
            }
            if (!json.isNull("withheld_in_countries")) {
                JSONArray withheld_in_countries = json.getJSONArray("withheld_in_countries");
                int length = withheld_in_countries.length();
                this.withheldInCountries = new String[length];
                for (int i = 0; i < length; ++i) {
                    this.withheldInCountries[i] = withheld_in_countries.getString(i);
                }
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    private void collectEntities(JSONObject json) throws JSONException, TwitterException {
        if (!json.isNull("entities")) {
            JSONArray hashtagsArray;
            int i;
            int len;
            JSONObject entities = json.getJSONObject("entities");
            if (!entities.isNull("user_mentions")) {
                JSONArray userMentionsArray = entities.getJSONArray("user_mentions");
                len = userMentionsArray.length();
                this.userMentionEntities = new UserMentionEntity[len];
                for (i = 0; i < len; ++i) {
                    this.userMentionEntities[i] = new UserMentionEntityJSONImpl(userMentionsArray.getJSONObject(i));
                }
            }
            if (!entities.isNull("urls")) {
                JSONArray urlsArray = entities.getJSONArray("urls");
                len = urlsArray.length();
                this.urlEntities = new URLEntity[len];
                for (i = 0; i < len; ++i) {
                    this.urlEntities[i] = new URLEntityJSONImpl(urlsArray.getJSONObject(i));
                }
            }
            if (!entities.isNull("hashtags")) {
                hashtagsArray = entities.getJSONArray("hashtags");
                len = hashtagsArray.length();
                this.hashtagEntities = new HashtagEntity[len];
                for (i = 0; i < len; ++i) {
                    this.hashtagEntities[i] = new HashtagEntityJSONImpl(hashtagsArray.getJSONObject(i));
                }
            }
            if (!entities.isNull("symbols")) {
                hashtagsArray = entities.getJSONArray("symbols");
                len = hashtagsArray.length();
                this.symbolEntities = new SymbolEntity[len];
                for (i = 0; i < len; ++i) {
                    this.symbolEntities[i] = new HashtagEntityJSONImpl(hashtagsArray.getJSONObject(i));
                }
            }
            if (!entities.isNull("media")) {
                JSONArray mediaArray = entities.getJSONArray("media");
                len = mediaArray.length();
                this.mediaEntities = new MediaEntity[len];
                for (i = 0; i < len; ++i) {
                    this.mediaEntities[i] = new MediaEntityJSONImpl(mediaArray.getJSONObject(i));
                }
            }
        }
    }

    private void mergeExtendedEntities(JSONObject json) throws JSONException, TwitterException {
        JSONObject extendedEntities;
        if (!json.isNull("extended_entities") && !(extendedEntities = json.getJSONObject("extended_entities")).isNull("media")) {
            JSONArray mediaArray = extendedEntities.getJSONArray("media");
            int len = mediaArray.length();
            this.mediaEntities = new MediaEntity[len];
            for (int i = 0; i < len; ++i) {
                this.mediaEntities[i] = new MediaEntityJSONImpl(mediaArray.getJSONObject(i));
            }
        }
    }

    private void mergeExtendedTweet(JSONObject extendedTweet) throws TwitterException {
        try {
            JSONArray indicesArray = extendedTweet.getJSONArray("display_text_range");
            this.displayTextRangeStart = indicesArray.getInt(0);
            this.displayTextRangeEnd = indicesArray.getInt(1);
            this.collectEntities(extendedTweet);
            this.userMentionEntities = this.userMentionEntities == null ? new UserMentionEntity[]{} : this.userMentionEntities;
            this.urlEntities = this.urlEntities == null ? new URLEntity[]{} : this.urlEntities;
            this.hashtagEntities = this.hashtagEntities == null ? new HashtagEntity[]{} : this.hashtagEntities;
            this.symbolEntities = this.symbolEntities == null ? new SymbolEntity[]{} : this.symbolEntities;
            this.mediaEntities = this.mediaEntities == null ? new MediaEntity[]{} : this.mediaEntities;
            this.text = HTMLEntity.unescapeAndSlideEntityIncdices(extendedTweet.getString("full_text"), this.userMentionEntities, this.urlEntities, this.hashtagEntities, this.mediaEntities);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public int compareTo(Status that) {
        long delta = this.id - that.getId();
        if (delta < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (delta > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)delta;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public int getDisplayTextRangeStart() {
        return this.displayTextRangeStart;
    }

    @Override
    public int getDisplayTextRangeEnd() {
        return this.displayTextRangeEnd;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public boolean isTruncated() {
        return this.isTruncated;
    }

    @Override
    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    @Override
    public long getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    @Override
    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    @Override
    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public long[] getContributors() {
        return this.contributorsIDs;
    }

    @Override
    public boolean isFavorited() {
        return this.isFavorited;
    }

    @Override
    public boolean isRetweeted() {
        return this.isRetweeted;
    }

    @Override
    public int getFavoriteCount() {
        return this.favoriteCount;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public boolean isRetweet() {
        return this.retweetedStatus != null;
    }

    @Override
    public Status getRetweetedStatus() {
        return this.retweetedStatus;
    }

    @Override
    public int getRetweetCount() {
        return (int)this.retweetCount;
    }

    @Override
    public boolean isRetweetedByMe() {
        return this.currentUserRetweetId != -1L;
    }

    @Override
    public long getCurrentUserRetweetId() {
        return this.currentUserRetweetId;
    }

    @Override
    public boolean isPossiblySensitive() {
        return this.isPossiblySensitive;
    }

    @Override
    public UserMentionEntity[] getUserMentionEntities() {
        return this.userMentionEntities;
    }

    @Override
    public URLEntity[] getURLEntities() {
        return this.urlEntities;
    }

    @Override
    public HashtagEntity[] getHashtagEntities() {
        return this.hashtagEntities;
    }

    @Override
    public MediaEntity[] getMediaEntities() {
        return this.mediaEntities;
    }

    @Override
    public SymbolEntity[] getSymbolEntities() {
        return this.symbolEntities;
    }

    @Override
    public Scopes getScopes() {
        return this.scopes;
    }

    @Override
    public String[] getWithheldInCountries() {
        return this.withheldInCountries;
    }

    @Override
    public long getQuotedStatusId() {
        return this.quotedStatusId;
    }

    @Override
    public Status getQuotedStatus() {
        return this.quotedStatus;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    static ResponseList<Status> createStatusList(HttpResponse res, Configuration conf) throws TwitterException {
        try {
            if (conf.isJSONStoreEnabled()) {
                TwitterObjectFactory.clearThreadLocalMap();
            }
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ResponseListImpl<Status> statuses = new ResponseListImpl<Status>(size, res);
            for (int i = 0; i < size; ++i) {
                JSONObject json = list.getJSONObject(i);
                StatusJSONImpl status = new StatusJSONImpl(json);
                if (conf.isJSONStoreEnabled()) {
                    TwitterObjectFactory.registerJSONObject(status, json);
                }
                statuses.add(status);
            }
            if (conf.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject(statuses, list);
            }
            return statuses;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Status && ((Status)obj).getId() == this.id;
    }

    public String toString() {
        return "StatusJSONImpl{createdAt=" + this.createdAt + ", id=" + this.id + ", text='" + this.text + '\'' + ", source='" + this.source + '\'' + ", isTruncated=" + this.isTruncated + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", isFavorited=" + this.isFavorited + ", isRetweeted=" + this.isRetweeted + ", favoriteCount=" + this.favoriteCount + ", inReplyToScreenName='" + this.inReplyToScreenName + '\'' + ", geoLocation=" + this.geoLocation + ", place=" + this.place + ", retweetCount=" + this.retweetCount + ", isPossiblySensitive=" + this.isPossiblySensitive + ", lang='" + this.lang + '\'' + ", contributorsIDs=" + Arrays.toString(this.contributorsIDs) + ", retweetedStatus=" + this.retweetedStatus + ", userMentionEntities=" + Arrays.toString(this.userMentionEntities) + ", urlEntities=" + Arrays.toString(this.urlEntities) + ", hashtagEntities=" + Arrays.toString(this.hashtagEntities) + ", mediaEntities=" + Arrays.toString(this.mediaEntities) + ", symbolEntities=" + Arrays.toString(this.symbolEntities) + ", currentUserRetweetId=" + this.currentUserRetweetId + ", user=" + this.user + ", withHeldInCountries=" + Arrays.toString(this.withheldInCountries) + ", quotedStatusId=" + this.quotedStatusId + ", quotedStatus=" + this.quotedStatus + '}';
    }
}

