/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.tweetchieve.achievement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import javax.annotation.Nullable;

public class AchievementGameType {
    public static ArrayList<AchievementGameType> types = new ArrayList();
    private String gameType;
    public ArrayList<String> scoreboardvalues;
    private JsonArray timeSlot;

    AchievementGameType(String gameType, @Nullable JsonArray timeSlot, String ... scoreboardvalues) {
        this(gameType, timeSlot, new ArrayList<String>(Arrays.asList(scoreboardvalues)));
    }

    AchievementGameType(String gameType, @Nullable JsonArray timeSlot, ArrayList<String> scoreboardvalues) {
        this.gameType = gameType;
        this.scoreboardvalues = scoreboardvalues;
        this.timeSlot = timeSlot;
    }

    public String getGameType() {
        return this.gameType;
    }

    public boolean hasScoreboardValue(String val) {
        return this.scoreboardvalues.contains(val.toLowerCase());
    }

    public static AchievementGameType getAchievementGameTypeByName(String gameType) {
        for (AchievementGameType type : types) {
            if (!type.getGameType().equalsIgnoreCase(gameType.toLowerCase()) && !type.scoreboardvalues.contains(gameType.toLowerCase())) continue;
            return type;
        }
        return null;
    }

    public static void index(JsonObject achievementGameTypes) {
        for (Map.Entry key : achievementGameTypes.entrySet()) {
            String name = (String)key.getKey();
            JsonObject el = ((JsonElement)key.getValue()).getAsJsonObject();
            JsonArray timeslot = null;
            if (el.has("timeslot")) {
                timeslot = el.get("timeslot").getAsJsonArray();
            }
            ArrayList<String> scoreboards = new ArrayList<String>();
            for (JsonElement sb : el.get("scoreboards").getAsJsonArray()) {
                scoreboards.add(sb.getAsString());
            }
            types.add(new AchievementGameType(name, timeslot, scoreboards));
        }
    }

    public String toString() {
        return this.gameType;
    }

    public boolean isActiveInPeriod() {
        if (this.timeSlot == null) {
            return true;
        }
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        for (JsonElement el : this.timeSlot) {
            JsonObject time = el.getAsJsonObject();
            int Jyear = time.has("year") ? time.get("year").getAsInt() : year;
            int minMonth = time.get("minMonth").getAsInt();
            int maxMonth = time.get("maxMonth").getAsInt();
            int minDay = time.get("minDay").getAsInt();
            int maxDay = time.get("maxDay").getAsInt();
            if (year != Jyear || month < minMonth || day < minDay || month > maxMonth || day > maxDay) continue;
            return true;
        }
        return false;
    }
}

