/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.tweetchieve.achievement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skyerzz.tweetchieve.achievement.AchievementGameType;
import java.util.ArrayList;
import java.util.Map;

public class SingleAchievement {
    public static ArrayList<SingleAchievement> singleAchievements = new ArrayList();
    private AchievementGameType gameType;
    private String name;
    private String description;
    private int points;

    SingleAchievement(AchievementGameType gameType, int points, String name, String description) {
        this.gameType = gameType;
        this.points = points;
        this.name = name;
        this.description = description;
    }

    public AchievementGameType getGameType() {
        return this.gameType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getAchievementPoints() {
        return this.points;
    }

    public static SingleAchievement getSingleAchievementByNameType(String name, AchievementGameType gameType) {
        SingleAchievement found = null;
        for (SingleAchievement ach : singleAchievements) {
            if (!ach.name.equalsIgnoreCase(name)) continue;
            if (gameType == null || ach.gameType == gameType && ach.gameType.isActiveInPeriod()) {
                return ach;
            }
            System.out.println("[Tweetchieve] Found value without correct scoreboard for achievement: " + name + "::" + gameType.getGameType() + " >> " + ach.toString());
            found = ach;
        }
        System.out.println("[Tweetchieve] Returning unmatched achievementGameType achievement: " + found);
        return found;
    }

    public String toString() {
        return "SingleAchievement(" + this.name + "|" + this.description + "|" + this.points + "|" + this.gameType + ")";
    }

    public static void index(JsonObject achievementGameTypes) {
        for (Map.Entry set : achievementGameTypes.entrySet()) {
            String key = (String)set.getKey();
            AchievementGameType type = AchievementGameType.getAchievementGameTypeByName(key);
            if (type == null) {
                System.out.println("[Tweetchieve] ERROR: Couldnt index single achievements for type " + key + "! No such GameType found!");
                continue;
            }
            JsonArray achs = ((JsonElement)set.getValue()).getAsJsonArray();
            for (JsonElement el : achs) {
                JsonObject a = el.getAsJsonObject();
                int points = a.get("points").getAsInt();
                String name = a.get("name").getAsString();
                String desc = a.get("description").getAsString();
                singleAchievements.add(new SingleAchievement(type, points, name, desc));
            }
        }
    }
}

