/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.tweetchieve;

import com.mojang.realmsclient.gui.ChatFormatting;
import com.skyerzz.tweetchieve.ConfigHandler;
import com.skyerzz.tweetchieve.TweetChieve;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import twitter4j.TwitterException;
import twitter4j.auth.AccessToken;

public class TweetChieveCommand
extends CommandBase {
    public String func_71517_b() {
        return "tweetchieve";
    }

    public String func_71518_a(ICommandSender sender) {
        return "tweetchieve [code] | tweetchieve settings";
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        AccessToken access;
        if (args.length >= 1 && (args[0].equalsIgnoreCase("addIP") || args[0].equalsIgnoreCase("setIP"))) {
            if (TweetChieve.ip.endsWith(".hypixel.net")) {
                ConfigHandler.setAlternativeIP(TweetChieve.ip);
                sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.GREEN + "[TweetChieve] Tweetchieve will now recognize the ip " + TweetChieve.ip + " as an hypixel IP. Please relog for it to take effect."));
                return;
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "[TweetChieve] Can not recognize this IP as an Hypixel IP! If this was in error, please contact the mod author."));
            return;
        }
        if (!TweetChieve.isOnHypixel) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.GREEN + "[TweetChieve] You're not on hypixel!"));
            return;
        }
        if (args.length < 1) {
            if (TweetChieve.tweetHandler.twitter.getAuthorization().isEnabled()) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "[TweetChieve] You are already connected to twitter! "));
                return;
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.GREEN + "[TweetChieve] Creating a new connection link... "));
            try {
                String u = TweetChieve.tweetHandler.getURL();
                ChatComponentText url = new ChatComponentText(ChatFormatting.GREEN + "[TweetChieve] Link: " + u.toString());
                url.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, u));
                sender.func_145747_a((IChatComponent)url);
                sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.GREEN + "[TweetChieve] Please open the link to connect your account to the TweetChieve Twitter plugin"));
                sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.GREEN + "[TweetChieve] Enter the code twitter supplies through \"/tweetchieve <code>\" to complete the process!"));
            }
            catch (TwitterException e) {
                e.printStackTrace();
                sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "[TweetChieve] Something went wrong! Errorcode " + e.getErrorCode() + ": " + e.getErrorMessage()));
                return;
            }
            return;
        }
        if (args[0].equalsIgnoreCase("force")) {
            new Thread(() -> {
                try {
                    TweetChieve.tweetHandler.sendTweetQueue(true);
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.GREEN + "[TweetChieve] Forced out the tweetqueue!"));
                }
                catch (TwitterException e) {
                    e.printStackTrace();
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "[TweetChieve] Something went wrong! Errorcode " + e.getErrorCode() + ": " + e.getErrorMessage()));
                }
            }).start();
            return;
        }
        if (args[0].equalsIgnoreCase("testSB")) {
            ScoreObjective objective = Minecraft.func_71410_x().field_71441_e.func_96441_U().func_96539_a(1);
            if (objective == null) {
                System.out.println("Found NULL scoreboard!");
                return;
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText(objective.func_96679_b()));
            return;
        }
        if (args[0].equalsIgnoreCase("settings") || args[0].equalsIgnoreCase("setting")) {
            if (args.length < 3) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "[TweetChieve] Usage: /tweetchieve settings <setting> <true|false>"));
                return;
            }
            boolean answer = args[2].equalsIgnoreCase("true");
            switch (args[1].toLowerCase()) {
                case "tweetmark": 
                case "watermark": 
                case "tweetad": 
                case "adtweet": {
                    ConfigHandler.setTweetMark(answer);
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.GREEN + "[TweetChieve] Set tweetMark to : " + answer));
                    return;
                }
                case "dotweet": 
                case "tweet": 
                case "tweetout": {
                    ConfigHandler.setDoTweet(answer);
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.GREEN + "[TweetChieve] Set doTweet to : " + answer));
                    return;
                }
                case "update": 
                case "notification": 
                case "notify": 
                case "updatenotify": 
                case "updatenotification": {
                    ConfigHandler.setUpdateNotif(answer);
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.GREEN + "[TweetChieve] Set updateNotification to : " + answer));
                    return;
                }
                case "bulktweet": 
                case "bulk": 
                case "summarytweet": 
                case "summary": {
                    ConfigHandler.setBulkTweet(answer);
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.GREEN + "[TweetChieve] Set bulkTweet to : " + answer));
                    return;
                }
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "[TweetChieve] could not find that setting! Known settings are tweetmark,dotweet,updatenotification,bulktweet."));
            return;
        }
        if (args[0].equalsIgnoreCase("status")) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "[TweetChieve] Testing: account connected: " + TweetChieve.tweetHandler.twitter.getAuthorization().isEnabled() + "\n" + ChatFormatting.RED + "Setting TweetMark: " + ConfigHandler.getTweetMark() + "\n" + ChatFormatting.RED + "Setting doTweet: " + ConfigHandler.doTweet() + "\n" + ChatFormatting.RED + "Setting BulkTweet: " + ConfigHandler.getbulkTweet() + "\n" + ChatFormatting.RED + "Alternative IP: " + ConfigHandler.getAlternativeIP()));
            return;
        }
        if (args[0].equalsIgnoreCase("info") || args[0].equalsIgnoreCase("about")) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.DARK_GRAY + "[TweetChieve] A mod created by Skyerzz.\n" + ChatFormatting.GRAY + "Version: " + "2.0.0" + "\n" + ChatFormatting.GRAY + "Achievements Version: " + ConfigHandler.getAchievementsFileVersion()));
            String u = "http://skyerzz.com/tweetchieve";
            ChatComponentText url = new ChatComponentText(ChatFormatting.GRAY + "Website: " + u.toString());
            url.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, u));
            sender.func_145747_a((IChatComponent)url);
            return;
        }
        if (args[0].equalsIgnoreCase("help")) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.DARK_GRAY + "==[TweetChieve Commands]==\n" + ChatFormatting.GRAY + "addIP - adds your currently used IP as a valid hypixel domain\n" + ChatFormatting.GRAY + "settings - change tweetchieve's settings\n" + ChatFormatting.GRAY + "status - shows the current status and connections of the mod\n" + ChatFormatting.GRAY + "about - shows mod information"));
            return;
        }
        if (args.length > 1 || TweetChieve.tweetHandler.twitter.getAuthorization().isEnabled()) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "[TweetChieve] Invalid Usage or already connected!"));
            return;
        }
        try {
            try {
                access = TweetChieve.tweetHandler.getAccesToken(args[0]);
            }
            catch (TwitterException e) {
                if (e.getStatusCode() == 401) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "[TweetChieve] Unable to get the access token. Try again later."));
                    return;
                }
                sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "[TweetChieve] Something went wrong! Errorcode " + e.getErrorCode() + ": " + e.getErrorMessage()));
                e.printStackTrace();
                return;
            }
            TweetChieve.tweetHandler.setAccessToken(access.getToken(), access.getTokenSecret());
        }
        catch (IllegalStateException e) {
            if (!TweetChieve.tweetHandler.twitter.getAuthorization().isEnabled()) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "[TweetChieve] Consumer Keys are not set! use \"/tweetchieve\" first!"));
                return;
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "[TweetChieve] Illegal State: Something went wrong: " + e.getMessage()));
            return;
        }
        ConfigHandler.saveTokens(access.getToken(), access.getTokenSecret());
        sender.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "[TweetChieve] Succesfully connected your twitter account!"));
    }

    public int func_82362_a() {
        return 0;
    }
}

