/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.tweetchieve.achievement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skyerzz.tweetchieve.achievement.AchievementGameType;
import java.util.ArrayList;
import java.util.Map;

public class TieredAchievement {
    public static ArrayList<TieredAchievement> tieredAchievements = new ArrayList();
    private AchievementGameType gameType;
    private String name;
    private String description;
    private int[] reqTiers;

    TieredAchievement(AchievementGameType gameType, String name, String description, int ... reqTiers) {
        this.gameType = gameType;
        this.reqTiers = reqTiers;
        this.name = name;
        this.description = description;
    }

    public AchievementGameType getGameType() {
        return this.gameType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription(int level) {
        return this.description.replace("%s", this.getRequirement(level) + "");
    }

    public int getRequirement(int tier) {
        if (this.reqTiers.length < tier || tier < 0) {
            return -1;
        }
        return this.reqTiers[tier];
    }

    public int getAchievementPoints(int tier) {
        if (this.reqTiers.length < tier || tier < 0) {
            return -1;
        }
        return tier * 5;
    }

    public static TieredAchievement getTieredAchievementByNameType(String name, AchievementGameType gameType) {
        TieredAchievement found = null;
        for (TieredAchievement ach : tieredAchievements) {
            if (!ach.name.equalsIgnoreCase(name)) continue;
            if (gameType == null || ach.gameType == gameType && ach.gameType.isActiveInPeriod()) {
                return ach;
            }
            System.out.println("[Tweetchieve] Found value without correct scoreboard for Tiered achievement: " + name + "::" + gameType.getGameType() + " >> " + ach.toString());
            found = ach;
        }
        return found;
    }

    public String toString() {
        String tiers = "";
        for (int i : this.reqTiers) {
            tiers = tiers + i + ",";
        }
        tiers = tiers.substring(0, tiers.lastIndexOf(","));
        return "TieredAchievement(" + this.name + "|" + this.description + "((" + tiers + "))|" + this.gameType + ")";
    }

    public static void index(JsonObject achievementGameTypes) {
        for (Map.Entry set : achievementGameTypes.entrySet()) {
            String key = (String)set.getKey();
            AchievementGameType type = AchievementGameType.getAchievementGameTypeByName(key);
            if (type == null) {
                System.out.println("[Tweetchieve] ERROR: Couldnt index single achievements for type " + key + "! No such GameType found!");
                continue;
            }
            JsonArray achs = ((JsonElement)set.getValue()).getAsJsonArray();
            for (JsonElement el : achs) {
                JsonObject a = el.getAsJsonObject();
                JsonArray tiers = a.get("tiers").getAsJsonArray();
                String name = a.get("name").getAsString();
                String desc = a.get("description").getAsString();
                int[] x = new int[tiers.size()];
                for (int i = 0; i < tiers.size(); ++i) {
                    x[i] = tiers.get(i).getAsInt();
                }
                tieredAchievements.add(new TieredAchievement(type, name, desc, x));
            }
        }
    }
}

