/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.tweetchieve;

import com.skyerzz.tweetchieve.TweetChieve;
import com.skyerzz.tweetchieve.achievement.SingleAchievement;
import com.skyerzz.tweetchieve.achievement.TieredAchievement;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;
import twitter4j.auth.AccessToken;

public class ConfigHandler {
    public static final String configurationTypeNormal = "default";
    public static Configuration config;

    public ConfigHandler(Configuration config) {
        ConfigHandler.config = config;
        config.load();
        if (ConfigHandler.getAccessTokenFromFile() != null) {
            TweetChieve.tweetHandler.setAccessToken(ConfigHandler.getAccessTokenFromFile());
            System.out.println("[TweetChieve] Loaded token from file!");
        }
    }

    public static void saveTokens(String key, String secret) {
        config.get(configurationTypeNormal, "Ckey", key).set(key);
        config.get(configurationTypeNormal, "Csec", secret).set(secret);
        config.save();
    }

    public static AccessToken getAccessTokenFromFile() {
        String key = config.get(configurationTypeNormal, "Ckey", "").getString();
        String sec = config.get(configurationTypeNormal, "Csec", "").getString();
        if (key.isEmpty() || sec.isEmpty() || key == null || sec == null) {
            return null;
        }
        return new AccessToken(key, sec);
    }

    public static void setTweetMark(boolean answer) {
        config.get(configurationTypeNormal, "TweetMark", true).set(answer);
        config.save();
    }

    public static boolean getTweetMark() {
        return config.get(configurationTypeNormal, "TweetMark", true).getBoolean();
    }

    public static void setDoTweet(boolean tweet) {
        config.get(configurationTypeNormal, "DoTweet", true).set(tweet);
        config.save();
    }

    public static boolean doTweet() {
        return config.get(configurationTypeNormal, "DoTweet", true).getBoolean();
    }

    public static void setBulkTweet(boolean on) {
        config.get(configurationTypeNormal, "BulkTweet", false).set(on);
        config.save();
    }

    public static boolean getbulkTweet() {
        return config.get(configurationTypeNormal, "BulkTweet", false).getBoolean();
    }

    public static void setAlternativeIP(String ip) {
        config.get(configurationTypeNormal, "AltIP", "mc.hypixel.net").set(ip);
        config.save();
    }

    public static String getAlternativeIP() {
        return config.get(configurationTypeNormal, "AltIP", "mc.hypixel.net").getString();
    }

    public static void setUpdateNotif(boolean update) {
        config.get(configurationTypeNormal, "updateNotif", true).set(update);
        config.save();
    }

    public static boolean getUpdateNotif() {
        return config.get(configurationTypeNormal, "updateNotif", true).getBoolean();
    }

    public static boolean unlockAchievement(SingleAchievement achievement) {
        System.out.println("Single " + achievement.getName());
        ArrayList<String> singles = new ArrayList<String>(Arrays.asList(config.get(configurationTypeNormal, "SingleAchievements", new String[0]).getStringList()));
        for (String ach : singles) {
            if (!ach.equalsIgnoreCase(achievement.getName())) continue;
            return false;
        }
        singles.add(achievement.getName());
        config.get(configurationTypeNormal, "SingleAchievements", new String[0]).set(singles.toArray(new String[singles.size() - 1]));
        config.save();
        return true;
    }

    public static boolean unlockAchievement(TieredAchievement achievement, int level) {
        System.out.println("Tiered " + achievement.getName() + " L " + level);
        ArrayList<String> tiered = new ArrayList<String>(Arrays.asList(config.get(configurationTypeNormal, "TieredAchievements", new String[0]).getStringList()));
        for (String ach : tiered) {
            if (!ach.equalsIgnoreCase(achievement.getName() + "-" + level)) continue;
            return false;
        }
        tiered.add(achievement.getName() + "-" + level);
        config.get(configurationTypeNormal, "TieredAchievements", new String[0]).set(tiered.toArray(new String[tiered.size() - 1]));
        config.save();
        return true;
    }

    public static String getAchievementsJsonFromFile() {
        String json = config.get(configurationTypeNormal, "AchievementFile", "{}").getString();
        return json;
    }

    public static String getAchievementsFileVersion() {
        return config.get(configurationTypeNormal, "AchievementFileVersion", "0.0.0").getString();
    }

    public static void setAchievementsJson(String json) {
        config.get(configurationTypeNormal, "AchievementFile", "{}").set(json);
        config.save();
    }

    public static void setAchievementsFileVersion(String json) {
        config.get(configurationTypeNormal, "AchievementFileVersion", "").set(json);
        config.save();
    }
}

