/*
 * Decompiled with CFR 0.152.
 */
package com.skyerzz.tweetchieve;

import com.mojang.realmsclient.gui.ChatFormatting;
import com.skyerzz.tweetchieve.ConfigHandler;
import com.skyerzz.tweetchieve.TweetChieve;
import com.skyerzz.tweetchieve.achievement.SingleAchievement;
import com.skyerzz.tweetchieve.achievement.TieredAchievement;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;

public class TweetHandler {
    public Twitter twitter;
    private RequestToken token = null;
    public ArrayList<String> tweetQueue = new ArrayList();
    public Status lastStatus = null;

    public TweetHandler() {
        this.twitter = new TwitterFactory().getInstance();
        this.twitter.setOAuthConsumer("7MexyxXtO5xhKPzjMFCUeqXui", "2AzjZkfBsUURNamh8OkGtgVIbfO7jalvBxb4LHO9jPZiNn64Ak");
    }

    private Status sendTweet(String tweet) throws TwitterException {
        if (!TweetChieve.isOnHypixel || !ConfigHandler.doTweet()) {
            return null;
        }
        if (tweet.isEmpty() || tweet == null) {
            return null;
        }
        this.lastStatus = this.twitter.updateStatus(tweet);
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null) {
            TextComponentString t = new TextComponentString(ChatFormatting.GREEN + "Sent out your tweet! (click to open) ");
            t.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://twitter.com/" + this.lastStatus.getUser().getScreenName() + "/" + this.lastStatus.getId()));
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)t);
        }
        return this.lastStatus;
    }

    public Status sendTweetQueue(boolean force) throws TwitterException {
        if (!TweetChieve.isOnHypixel || !ConfigHandler.doTweet()) {
            return null;
        }
        System.out.println("TweetQueue: " + this.tweetQueue.size() + " force: " + force);
        if (this.tweetQueue.size() >= 3 || force && this.tweetQueue.size() >= 1) {
            String tweet = "I unlocked the following achievements on hypixel:\n\n";
            for (String s : this.tweetQueue) {
                tweet = tweet + s + "\n";
            }
            this.tweetQueue.clear();
            if (ConfigHandler.getTweetMark()) {
                tweet = tweet + "\n//Automatically tweeted by the @tweetChieveHPXL mod";
            }
            System.out.println("TweetQUEUE TWEETING: \n" + tweet);
            return this.sendTweet(tweet);
        }
        System.out.println("TweetQueue: Not tweeting.");
        return null;
    }

    public void setAccessToken(String key, String secret) {
        this.twitter.setOAuthAccessToken(new AccessToken(key, secret));
    }

    public void setAccessToken(AccessToken token) {
        this.twitter.setOAuthAccessToken(token);
    }

    public String getURL() throws TwitterException {
        this.token = this.twitter.getOAuthRequestToken();
        return this.token.getAuthorizationURL().toString();
    }

    public AccessToken getAccesToken(String pin) throws TwitterException {
        if (this.token == null) {
            return null;
        }
        return this.twitter.getOAuthAccessToken(this.token, pin);
    }

    public boolean sendTweet(SingleAchievement achievement) throws TwitterException {
        if (ConfigHandler.getbulkTweet()) {
            String ach = achievement.getName() + " (" + achievement.getAchievementPoints() + "p) in " + achievement.getGameType();
            this.tweetQueue.add(ach);
            System.out.println("[SINGLE] Found BulkTweet setting! Adding " + ach + " to tweetQueue. Queue length: " + this.tweetQueue.size());
            return this.sendTweetQueue(false) != null;
        }
        System.out.println("[SINGLE] Bulktweet is OFF! Tweeting out directly...");
        String tweet = "I unlocked a challenge achievement in " + achievement.getGameType().getGameType() + " for " + achievement.getAchievementPoints() + " points!\n" + achievement.getName() + ": " + achievement.getDescription();
        if (ConfigHandler.getTweetMark()) {
            tweet = tweet + "\n\n//Automatically tweeted by the @tweetChieveHPXL mod";
        }
        this.sendTweet(tweet);
        return true;
    }

    public boolean sendTweet(TieredAchievement achievement, int level) throws TwitterException {
        if (ConfigHandler.getbulkTweet()) {
            String ach = achievement.getName() + " " + this.getRoman(level) + " (" + achievement.getAchievementPoints(level) + "p) in " + achievement.getGameType();
            this.tweetQueue.add(ach);
            System.out.println("[TIER] Found BulkTweet setting! Adding " + ach + " to tweetQueue. Queue length: " + this.tweetQueue.size());
            this.sendTweetQueue(false);
            return false;
        }
        System.out.println("[TIER] Bulktweet is OFF! Tweeting out directly...");
        String tweet = "I unlocked a tiered achievement in " + achievement.getGameType().getGameType() + " for " + achievement.getAchievementPoints(level) + " points!\n" + achievement.getName() + " " + this.getRoman(level) + ": " + achievement.getDescription(level - 1);
        if (ConfigHandler.getTweetMark()) {
            tweet = tweet + "\n\n//Automatically tweeted by the @tweetChieveHPXL mod";
        }
        this.sendTweet(tweet);
        return true;
    }

    public String getRoman(int level) {
        switch (level) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
            case 6: {
                return "VI";
            }
            case 7: {
                return "VII";
            }
            case 8: {
                return "VIII";
            }
            case 9: {
                return "IX";
            }
            case 10: {
                return "X";
            }
        }
        return "?";
    }
}

